/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.dataaccess;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import pt.webdetails.cda.dataaccess.AbstractDataAccess;
import pt.webdetails.cda.dataaccess.Parameter;
import pt.webdetails.cda.dataaccess.ScriptableDataAccess;

public class JsonScriptableDataAccess
extends ScriptableDataAccess {
    private static final Log logger = LogFactory.getLog(AbstractDataAccess.class);

    public JsonScriptableDataAccess(Element element) {
        super(element);
    }

    public JsonScriptableDataAccess() {
    }

    @Override
    public String getType() {
        return "jsonScriptable";
    }

    @Override
    public String getQuery() {
        String query = this.query;
        try {
            JSONObject jsonQuery = new JSONObject(query);
            if (!jsonQuery.isNull("metadata") && !jsonQuery.isNull("resultset")) {
                int i;
                StringBuilder builder = new StringBuilder();
                JSONArray metadata = jsonQuery.getJSONArray("metadata");
                JSONArray resultSet = jsonQuery.getJSONArray("resultset");
                int columns = metadata.length();
                String[] columnTypes = new String[columns];
                String colNames = "";
                String colTypes = "";
                for (i = 0; i < columns; ++i) {
                    JSONObject column = metadata.getJSONObject(i);
                    String classType = this.getClassFromType(Parameter.Type.parse(column.getString("colType")));
                    if (i > 0) {
                        colNames = colNames + ", ";
                        colTypes = colTypes + ", ";
                    }
                    colNames = colNames + "\"" + column.getString("colName") + "\"";
                    colTypes = colTypes + classType + ".class";
                    columnTypes[i] = classType;
                }
                builder.append(this.addTypedModelObject(colNames, colTypes));
                int L = resultSet.length();
                for (i = 0; i < L; ++i) {
                    JSONArray row = resultSet.getJSONArray(i);
                    builder.append("model.addRow(new Object[]{");
                    for (int j = 0; j < columns; ++j) {
                        if (j > 0) {
                            builder.append(", ");
                        }
                        builder.append(this.addParameter(row.getString(j), columnTypes[j]));
                    }
                    builder.append("});\n");
                }
                builder.append("return model;\n");
                query = builder.toString();
            }
        }
        catch (JSONException e) {
            logger.error((Object)e.getMessage());
        }
        return query;
    }

    private String addTypedModelObject(String columnNames, String columnTypes) {
        String typedModel = "import org.pentaho.reporting.engine.classic.core.util.TypedTableModel;\n\nString[] columnNames = new String[]{\n" + columnNames + "\n};\n\nClass[] columnTypes = new Class[]{\n" + columnTypes + "\n};\n\nTypedTableModel model = new TypedTableModel(columnNames, columnTypes);\n\n";
        return typedModel;
    }

    private String addParameter(String value, String type) {
        if (value.equals("null")) {
            return value;
        }
        if (type.equals("String")) {
            value = "\"" + value + "\"";
        }
        return "new " + type + "(" + value + ")";
    }

    private String getClassFromType(Parameter.Type type) {
        if (Parameter.Type.NUMERIC.equals((Object)type)) {
            return "Double";
        }
        if (Parameter.Type.INTEGER.equals((Object)type)) {
            return "Long";
        }
        if (Parameter.Type.STRING.equals((Object)type)) {
            return "String";
        }
        return "";
    }
}

