/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.dataaccess;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.metadata.model.concept.types.JoinType;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import pt.webdetails.cda.CdaEngine;
import pt.webdetails.cda.connections.ConnectionCatalog;
import pt.webdetails.cda.dataaccess.CompoundDataAccess;
import pt.webdetails.cda.dataaccess.PropertyDescriptor;
import pt.webdetails.cda.dataaccess.QueryException;
import pt.webdetails.cda.query.QueryOptions;
import pt.webdetails.cda.settings.UnknownDataAccessException;
import pt.webdetails.cda.utils.MetadataTableModel;
import pt.webdetails.cda.utils.kettle.RowMetaToTableModel;
import pt.webdetails.robochef.DynamicTransConfig;
import pt.webdetails.robochef.DynamicTransMetaConfig;
import pt.webdetails.robochef.DynamicTransformation;
import pt.webdetails.robochef.RowProductionManager;
import pt.webdetails.robochef.TableModelInput;

public class JoinCompoundDataAccess
extends CompoundDataAccess
implements RowProductionManager {
    public static final String MAX_ROWS_VALUE_TYPE_SEARCH_PROPERTY = "pt.webdetails.cda.TypeSearchMaxRows";
    private static final Log logger = LogFactory.getLog(JoinCompoundDataAccess.class);
    private static final String TYPE = "join";
    private static final long DEFAULT_ROW_PRODUCTION_TIMEOUT = 120L;
    private static TimeUnit DEFAULT_ROW_PRODUCTION_TIMEOUT_UNIT = TimeUnit.SECONDS;
    private static int DEFAULT_MAX_ROWS_VALUE_TYPE_SEARCH = 500;
    protected JoinType joinType;
    private String leftId;
    private String rightId;
    private String[] leftKeys;
    private String[] rightKeys;
    private ExecutorService executorService = CdaEngine.getInstance().getExecutorService();

    public JoinCompoundDataAccess() {
    }

    public JoinCompoundDataAccess(Element element) {
        super(element);
        Element joinTypeNode = (Element)element.selectSingleNode("JoinType");
        this.joinType = joinTypeNode != null && org.apache.commons.lang.StringUtils.isNotBlank((String)joinTypeNode.getText()) ? JoinType.valueOf((String)joinTypeNode.getText()) : JoinType.FULL_OUTER;
        Element left = (Element)element.selectSingleNode("Left");
        Element right = (Element)element.selectSingleNode("Right");
        this.leftId = left.attributeValue("id");
        this.rightId = right.attributeValue("id");
        this.leftKeys = left.attributeValue("keys").split(",");
        this.rightKeys = right.attributeValue("keys").split(",");
    }

    private static String getMergeJoinType(JoinType joinType) {
        switch (joinType) {
            case INNER: {
                return "INNER";
            }
            case LEFT_OUTER: {
                return "LEFT OUTER";
            }
            case RIGHT_OUTER: {
                return "RIGHT OUTER";
            }
        }
        return "FULL OUTER";
    }

    protected TableModel voidMerge(TableModel tableModelA, TableModel tableModelB) {
        TableModel empty = null;
        TableModel full = null;
        if (tableModelA.getRowCount() == 0) {
            empty = tableModelA;
            full = tableModelB;
        } else if (tableModelB.getRowCount() == 0) {
            empty = tableModelB;
            full = tableModelA;
        }
        switch (this.joinType) {
            case INNER: {
                return empty;
            }
            case LEFT_OUTER: {
                return tableModelA;
            }
            case RIGHT_OUTER: {
                return tableModelB;
            }
            case FULL_OUTER: {
                return full;
            }
        }
        return null;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    @Override
    protected TableModel queryDataSource(QueryOptions queryOptions) throws QueryException {
        TableModel output;
        ArrayList<Callable<Boolean>> inputCallables = new ArrayList<Callable<Boolean>>();
        try {
            QueryOptions croppedOptions = (QueryOptions)queryOptions.clone();
            croppedOptions.setSortBy(new ArrayList<String>());
            croppedOptions.setPageSize(0);
            croppedOptions.setPageStart(0);
            TableModel tableModelA = this.getCdaSettings().getDataAccess(this.leftId).doQuery(croppedOptions);
            TableModel tableModelB = this.getCdaSettings().getDataAccess(this.rightId).doQuery(croppedOptions);
            if (tableModelA.getColumnCount() == 0 || tableModelB.getColumnCount() == 0) {
                return new MetadataTableModel(new String[0], new Class[0], 0);
            }
            if (tableModelA.getRowCount() == 0 || tableModelB.getRowCount() == 0) {
                return this.voidMerge(tableModelA, tableModelB);
            }
            String[] leftColumnNames = new String[this.leftKeys.length];
            for (int i = 0; i < this.leftKeys.length; ++i) {
                leftColumnNames[i] = tableModelA.getColumnName(Integer.parseInt(this.leftKeys[i]));
            }
            String[] rightColumnNames = new String[this.rightKeys.length];
            for (int i = 0; i < this.rightKeys.length; ++i) {
                rightColumnNames[i] = tableModelB.getColumnName(Integer.parseInt(this.rightKeys[i]));
            }
            String sortLeftXML = this.getSortXmlStep("sortLeft", leftColumnNames);
            String sortRightXML = this.getSortXmlStep("sortRight", rightColumnNames);
            String mergeJoinXML = this.getMergeJoinXml(leftColumnNames, rightColumnNames);
            DynamicTransMetaConfig transMetaConfig = new DynamicTransMetaConfig(DynamicTransMetaConfig.Type.EMPTY, "JoinCompoundData", null, null);
            DynamicTransConfig transConfig = new DynamicTransConfig();
            String input1Xml = this.getInjectorStepXmlString("input1", tableModelA);
            String input2Xml = this.getInjectorStepXmlString("input2", tableModelB);
            transConfig.addConfigEntry(DynamicTransConfig.EntryType.STEP, "input1", input1Xml);
            transConfig.addConfigEntry(DynamicTransConfig.EntryType.STEP, "input2", input2Xml);
            transConfig.addConfigEntry(DynamicTransConfig.EntryType.STEP, "sortLeft", sortLeftXML);
            transConfig.addConfigEntry(DynamicTransConfig.EntryType.STEP, "sortRight", sortRightXML);
            transConfig.addConfigEntry(DynamicTransConfig.EntryType.STEP, "mergeJoin", mergeJoinXML);
            transConfig.addConfigEntry(DynamicTransConfig.EntryType.HOP, "input1", "sortLeft");
            transConfig.addConfigEntry(DynamicTransConfig.EntryType.HOP, "input2", "sortRight");
            transConfig.addConfigEntry(DynamicTransConfig.EntryType.HOP, "sortLeft", "mergeJoin");
            transConfig.addConfigEntry(DynamicTransConfig.EntryType.HOP, "sortRight", "mergeJoin");
            TableModelInput input1 = new TableModelInput();
            transConfig.addInput("input1", input1);
            inputCallables.add(input1.getCallableRowProducer(tableModelA, true));
            TableModelInput input2 = new TableModelInput();
            transConfig.addInput("input2", input2);
            inputCallables.add(input2.getCallableRowProducer(tableModelB, true));
            RowMetaToTableModel outputListener = new RowMetaToTableModel(false, true, false);
            transConfig.addOutput("mergeJoin", outputListener);
            DynamicTransformation trans = new DynamicTransformation(transConfig, transMetaConfig, inputCallables);
            trans.executeCheckedSuccess(null, null, this);
            logger.info((Object)trans.getReadWriteThroughput());
            output = outputListener.getRowsWritten();
            if (output == null) {
                return new MetadataTableModel(new String[0], new Class[0], 0);
            }
        }
        catch (UnknownDataAccessException e) {
            throw new QueryException("Unknown Data access in CompoundDataAccess ", e);
        }
        catch (Exception e) {
            throw new QueryException("Exception during query ", e);
        }
        return output;
    }

    private String getMergeJoinXml(String[] leftColumnNames, String[] rightColumnNames) {
        int i;
        StringBuilder mergeJoinXML = new StringBuilder("<step><name>mergeJoin</name><type>MergeJoin</type><join_type>");
        mergeJoinXML.append(JoinCompoundDataAccess.getMergeJoinType(this.joinType));
        mergeJoinXML.append("</join_type><copies>1</copies><step1>sortLeft</step1><step2>sortRight</step2>");
        mergeJoinXML.append("<keys_1>");
        for (i = 0; i < this.leftKeys.length; ++i) {
            mergeJoinXML.append("<key>").append(leftColumnNames[i]).append("</key>");
        }
        mergeJoinXML.append("</keys_1><keys_2>");
        for (i = 0; i < this.rightKeys.length; ++i) {
            mergeJoinXML.append("<key>").append(rightColumnNames[i]).append("</key>");
        }
        mergeJoinXML.append("</keys_2></step>");
        return mergeJoinXML.toString();
    }

    private String getSortXmlStep(String name, String[] columnNames) {
        StringBuilder sortXML = new StringBuilder("  <step>\n    <name>" + name + "</name>\n    <type>SortRows</type>\n    <description/>\n    <distribute>Y</distribute>\n    <copies>1</copies>\n         <partitioning>\n           <method>none</method>\n           <schema_name/>\n           </partitioning>\n      <directory>%%java.io.tmpdir%%</directory>\n      <prefix>out</prefix>\n      <sort_size/>\n      <free_memory>25</free_memory>\n      <compress>N</compress>\n      <compress_variable/>\n      <unique_rows>N</unique_rows>\n    <fields>\n");
        for (String columnName : columnNames) {
            sortXML.append("      <field>\n").append("        <name>").append(columnName).append("</name>\n").append("        <ascending>Y</ascending>\n").append("        <case_sensitive>Y</case_sensitive>\n").append("      </field>\n");
        }
        sortXML.append("    </fields>\n").append("     <cluster_schema/>\n").append(" <remotesteps>   <input>   </input>   <output>   </output> </remotesteps>    <GUI>\n").append("      <xloc>615</xloc>\n").append("      <yloc>188</yloc>\n").append("      <draw>Y</draw>\n").append("      </GUI>\n").append("    </step>\n");
        return sortXML.toString();
    }

    private String getInjectorStepXmlString(String name, TableModel t) {
        StringBuilder xml = new StringBuilder("<step><name>");
        xml.append(name).append("</name><type>Injector</type><copies>1</copies>");
        int maxRowsTypeSearch = this.getMaxTypeSearchRowCount(t);
        if (t.getColumnCount() > 0) {
            xml.append("<fields>");
            for (int i = 0; i < t.getColumnCount(); ++i) {
                Class<?> columnClass = t.getColumnClass(i);
                if (columnClass.equals(Object.class) && t.getRowCount() > 0) {
                    for (int j = 0; j < maxRowsTypeSearch; ++j) {
                        if (t.getValueAt(j, i) == null) continue;
                        columnClass = t.getValueAt(j, i).getClass();
                        break;
                    }
                }
                xml.append("<field>");
                xml.append("<name>").append(t.getColumnName(i)).append("</name>");
                xml.append("<type>").append(this.getKettleTypeFromColumnClass(columnClass)).append("</type>");
                xml.append("<length>-1</length><precision>-1</precision></field>");
            }
            xml.append("</fields>");
        }
        xml.append("</step>");
        return xml.toString();
    }

    private int getMaxTypeSearchRowCount(TableModel t) {
        int maxRowsTypeSearch = DEFAULT_MAX_ROWS_VALUE_TYPE_SEARCH;
        String maxRowsTypeSearchProperty = CdaEngine.getInstance().getConfigProperty(MAX_ROWS_VALUE_TYPE_SEARCH_PROPERTY);
        if (!StringUtils.isEmpty((String)maxRowsTypeSearchProperty)) {
            try {
                maxRowsTypeSearch = Integer.parseInt(maxRowsTypeSearchProperty);
            }
            catch (NumberFormatException nfe) {
                logger.error((Object)("pt.webdetails.cda.TypeSearchMaxRows:" + maxRowsTypeSearchProperty + " not a valid integer."));
            }
        }
        maxRowsTypeSearch = maxRowsTypeSearch <= 0 ? t.getRowCount() : Math.min(maxRowsTypeSearch, t.getRowCount());
        return maxRowsTypeSearch;
    }

    private String getKettleTypeFromColumnClass(Class<?> clazz) {
        if (clazz == String.class) {
            return "String";
        }
        if (clazz == Double.class || clazz == Float.class) {
            return "Number";
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return "Date";
        }
        if (clazz == Long.class || clazz == Integer.class) {
            return "Integer";
        }
        if (clazz == BigDecimal.class) {
            return "BigNumber";
        }
        if (clazz == Boolean.class) {
            return "Boolean";
        }
        if (clazz == Object.class) {
            logger.warn((Object)"Mapping column class Object to kettle type String");
            return "String";
        }
        throw new IllegalArgumentException("Unexpected class " + clazz + ", can't convert to kettle type");
    }

    @Override
    public void startRowProduction(Collection<Callable<Boolean>> inputCallables) {
        String timeoutStr = CdaEngine.getInstance().getConfigProperty("pt.webdetails.cda.DefaultRowProductionTimeout");
        long timeout = StringUtil.isEmpty((String)timeoutStr) ? 120L : Long.parseLong(timeoutStr);
        String unitStr = CdaEngine.getInstance().getConfigProperty("pt.webdetails.cda.DefaultRowProductionTimeoutTimeUnit");
        TimeUnit unit = StringUtil.isEmpty((String)unitStr) ? DEFAULT_ROW_PRODUCTION_TIMEOUT_UNIT : TimeUnit.valueOf(unitStr);
        this.startRowProduction(timeout, unit, inputCallables);
    }

    @Override
    public void startRowProduction(long timeout, TimeUnit unit, Collection<Callable<Boolean>> inputCallables) {
        try {
            List<Future<Boolean>> results = this.executorService.invokeAll(inputCallables, timeout, unit);
            for (Future<Boolean> result : results) {
                result.get();
            }
        }
        catch (InterruptedException e) {
            logger.error((Object)"Row production interrupted", (Throwable)e);
        }
        catch (ExecutionException e) {
            logger.error((Object)"Problem starting row production", (Throwable)e);
        }
    }

    @Override
    public ConnectionCatalog.ConnectionType getConnectionType() {
        return ConnectionCatalog.ConnectionType.NONE;
    }

    @Override
    public ArrayList<PropertyDescriptor> getInterface() {
        List properties = super.getInterface();
        ((ArrayList)properties).add(new PropertyDescriptor("left", PropertyDescriptor.Type.STRING, PropertyDescriptor.Placement.CHILD));
        ((ArrayList)properties).add(new PropertyDescriptor("right", PropertyDescriptor.Type.STRING, PropertyDescriptor.Placement.CHILD));
        ((ArrayList)properties).add(new PropertyDescriptor("output", PropertyDescriptor.Type.ARRAY, PropertyDescriptor.Placement.CHILD));
        ((ArrayList)properties).add(new PropertyDescriptor("joinType", PropertyDescriptor.Type.STRING, PropertyDescriptor.Placement.CHILD));
        return properties;
    }

    public String getLeftId() {
        return this.leftId;
    }

    public void setLeftId(String leftId) {
        this.leftId = leftId;
    }

    public String getRightId() {
        return this.rightId;
    }

    public String[] getLeftKeys() {
        return this.leftKeys;
    }

    public String[] getRightKeys() {
        return this.rightKeys;
    }

    @Override
    public void setQuery(String query) {
    }
}

