/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.dataaccess;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.ParameterDataRow;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.SQLReportDataFactory;
import pt.webdetails.cda.CdaEngine;
import pt.webdetails.cda.connections.ConnectionCatalog;
import pt.webdetails.cda.connections.InvalidConnectionException;
import pt.webdetails.cda.connections.dataservices.DataservicesConnection;
import pt.webdetails.cda.dataaccess.DataAccessEnums;
import pt.webdetails.cda.dataaccess.PREDataAccess;
import pt.webdetails.cda.dataaccess.PropertyDescriptor;
import pt.webdetails.cda.settings.UnknownConnectionException;
import pt.webdetails.cda.xml.DomVisitor;

public class DataservicesDataAccess
extends PREDataAccess {
    private static final Log logger = LogFactory.getLog(DataservicesDataAccess.class);
    private static final DataAccessEnums.DataAccessInstanceType TYPE = DataAccessEnums.DataAccessInstanceType.DATASERVICES;
    protected String dataServiceName;

    public DataservicesDataAccess(Element element) {
        super(element);
        this.query = element.selectSingleNode("./DataServiceQuery").getText();
        this.dataServiceName = this.parseNode(element, "./DataServiceName", s -> s, null);
    }

    public DataservicesDataAccess() {
    }

    @Override
    public DataFactory getDataFactory(ParameterDataRow parameterDataRow) throws UnknownConnectionException, InvalidConnectionException {
        logger.debug((Object)"Creating DataServicesDataFactory");
        DataservicesConnection connection = (DataservicesConnection)this.getCdaSettings().getConnection(this.getConnectionId());
        SQLReportDataFactory reportDataFactory = this.getSQLReportDataFactory(connection, parameterDataRow);
        reportDataFactory.setQuery("query", this.getQuery());
        return reportDataFactory;
    }

    @Override
    public DataFactory getDataFactory() throws UnknownConnectionException, InvalidConnectionException {
        return this.getDataFactory(null);
    }

    public String getDataServiceName() {
        return this.dataServiceName;
    }

    public void setDataServiceQuery(String dataServiceQuery) {
        this.query = dataServiceQuery;
    }

    public SQLReportDataFactory getSQLReportDataFactory(DataservicesConnection connection, ParameterDataRow parameterDataRow) throws InvalidConnectionException, UnknownConnectionException {
        return new SQLReportDataFactory(connection.getInitializedConnectionProvider(parameterDataRow, CdaEngine.getEnvironment().getFormulaContext()));
    }

    @Override
    public String getType() {
        return TYPE.getType();
    }

    @Override
    public String getLabel() {
        return TYPE.getLabel();
    }

    @Override
    public ConnectionCatalog.ConnectionType getConnectionType() {
        return ConnectionCatalog.ConnectionType.DATASERVICES;
    }

    @Override
    public List<PropertyDescriptor> getInterface() {
        List<PropertyDescriptor> properties = super.getInterface();
        properties.add(new PropertyDescriptor("dataServiceName", PropertyDescriptor.Type.STRING, PropertyDescriptor.Placement.CHILD));
        properties.add(new PropertyDescriptor("dataServiceQuery", PropertyDescriptor.Type.STRING, PropertyDescriptor.Placement.CHILD));
        properties.removeIf(propertyDescriptor -> propertyDescriptor.getName().equalsIgnoreCase("query"));
        return properties;
    }

    @Override
    public void accept(DomVisitor xmlVisitor, Element root) {
        xmlVisitor.visit(this, root);
    }
}

