/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.connections.sql;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.ConnectionProvider;
import pt.webdetails.cda.CdaEngine;
import pt.webdetails.cda.connections.Connection;
import pt.webdetails.cda.connections.EvaluableConnection;
import pt.webdetails.cda.connections.InvalidConnectionException;
import pt.webdetails.cda.connections.sql.AbstractSqlConnection;
import pt.webdetails.cda.connections.sql.SqlJndiConnectionInfo;
import pt.webdetails.cda.dataaccess.IDataAccessUtils;
import pt.webdetails.cda.dataaccess.PropertyDescriptor;
import pt.webdetails.cda.utils.FormulaEvaluator;
import pt.webdetails.cda.utils.Util;

public class JndiConnection
extends AbstractSqlConnection
implements EvaluableConnection {
    private SqlJndiConnectionInfo connectionInfo;

    public JndiConnection(Element connection) throws InvalidConnectionException {
        super(connection);
    }

    public JndiConnection() {
    }

    public JndiConnection(String id, String jndi) {
        super(id);
        this.connectionInfo = new SqlJndiConnectionInfo(jndi, null, null, null, null);
    }

    public JndiConnection(String id, SqlJndiConnectionInfo info) {
        super(id);
        this.connectionInfo = info;
    }

    @Override
    public ConnectionProvider getInitializedConnectionProvider() throws InvalidConnectionException {
        IDataAccessUtils dUtils = CdaEngine.getEnvironment().getDataAccessUtils();
        ConnectionProvider connectionProvider = dUtils.getJndiConnectionProvider(this.connectionInfo);
        try {
            java.sql.Connection connection = connectionProvider.createConnection(null, null);
            connection.close();
        }
        catch (SQLException e) {
            throw new InvalidConnectionException(this.getClass().getName() + ": Found SQLException: " + Util.getExceptionDescription(e), e);
        }
        return connectionProvider;
    }

    @Override
    protected void initializeConnection(Element connection) throws InvalidConnectionException {
        this.connectionInfo = new SqlJndiConnectionInfo(connection);
    }

    @Override
    public String getType() {
        return "sqlJndi";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JndiConnection that = (JndiConnection)o;
        return this.connectionInfo.equals(that.connectionInfo);
    }

    @Override
    public int hashCode() {
        return this.connectionInfo.hashCode();
    }

    @Override
    public ArrayList<PropertyDescriptor> getProperties() {
        List properties = super.getProperties();
        ((ArrayList)properties).add(new PropertyDescriptor("jndi", PropertyDescriptor.Type.STRING, PropertyDescriptor.Placement.CHILD));
        return properties;
    }

    @Override
    public String getPasswordField() {
        return this.connectionInfo.getPasswordField();
    }

    @Override
    public String getUserField() {
        return this.connectionInfo.getUserField();
    }

    @Override
    public Connection evaluate() {
        SqlJndiConnectionInfo info = new SqlJndiConnectionInfo(FormulaEvaluator.replaceFormula(this.connectionInfo.getJndi()), this.connectionInfo.getUser(), this.connectionInfo.getPass(), this.connectionInfo.getUserField(), this.connectionInfo.getPasswordField());
        JndiConnection conn = new JndiConnection(this.getId(), info);
        conn.setCdaSettings(this.getCdaSettings());
        return conn;
    }

    public SqlJndiConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }
}

