/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.connections.sql;

import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class JdbcConnectionInfo {
    private String driver;
    private String url;
    private String user;
    private String pass;
    private String userField;
    private String passwordField;
    private Properties properties;

    public JdbcConnectionInfo(Element connection) {
        String driver = (String)connection.selectObject("string(./Driver)");
        String url = (String)connection.selectObject("string(./Url)");
        String userName = (String)connection.selectObject("string(./User)");
        String password = (String)connection.selectObject("string(./Pass)");
        String userFormula = (String)connection.selectObject("string(./UserField)");
        String passFormula = (String)connection.selectObject("string(./PassField)");
        if (StringUtils.isEmpty((String)driver)) {
            throw new IllegalStateException("A driver is mandatory");
        }
        if (StringUtils.isEmpty((String)url)) {
            throw new IllegalStateException("A url is mandatory");
        }
        this.setDriver(driver);
        this.setUrl(url);
        this.properties = new Properties();
        if (!StringUtils.isEmpty((String)userName)) {
            this.setUser(userName);
            this.properties.setProperty("user", userName);
        }
        if (!StringUtils.isEmpty((String)password)) {
            this.setPass(password);
            this.properties.setProperty("password", password);
        }
        if (!StringUtils.isEmpty((String)userFormula)) {
            this.setUserField(userFormula);
        }
        if (!StringUtils.isEmpty((String)passFormula)) {
            this.setPasswordField(passFormula);
        }
        List list = connection.elements("Property");
        for (int i = 0; i < list.size(); ++i) {
            Element childElement = (Element)list.get(i);
            String name = childElement.attributeValue("name");
            String text = childElement.getText();
            this.properties.put(name, text);
        }
    }

    public String getUserField() {
        return this.userField;
    }

    public void setUserField(String userField) {
        this.userField = userField;
    }

    public String getPasswordField() {
        return this.passwordField;
    }

    public void setPasswordField(String passwordField) {
        this.passwordField = passwordField;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPass() {
        return this.pass;
    }

    public void setPass(String pass) {
        this.pass = pass;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JdbcConnectionInfo that = (JdbcConnectionInfo)o;
        if (this.driver != null ? !this.driver.equals(that.driver) : that.driver != null) {
            return false;
        }
        if (this.pass != null ? !this.pass.equals(that.pass) : that.pass != null) {
            return false;
        }
        if (this.url != null ? !this.url.equals(that.url) : that.url != null) {
            return false;
        }
        return !(this.user != null ? !this.user.equals(that.user) : that.user != null);
    }

    public int hashCode() {
        int result = this.driver != null ? this.driver.hashCode() : 0;
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
        result = 31 * result + (this.pass != null ? this.pass.hashCode() : 0);
        return result;
    }
}

