/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.connections.mondrian;

import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import pt.webdetails.cda.connections.mondrian.MondrianConnectionInfo;
import pt.webdetails.cda.connections.mondrian.OlapJndiConnectionInfo;

public class MondrianJndiConnectionInfo
extends OlapJndiConnectionInfo
implements MondrianConnectionInfo {
    private String catalog;
    private String cube;
    private String mondrianRole;

    public MondrianJndiConnectionInfo(String jndi, String catalog, String cube) {
        super(null, jndi);
        this.setCatalog(catalog);
        this.setCube(cube);
    }

    public MondrianJndiConnectionInfo(Element connection) {
        super(connection);
        this.setCatalog((String)connection.selectObject("string(./Catalog)"));
        this.setCube((String)connection.selectObject("string(./Cube)"));
        String role = (String)connection.selectObject("string(./Role)");
        if (!StringUtils.isEmpty((String)role)) {
            this.setMondrianRole(role);
        }
    }

    @Override
    public String getMondrianRole() {
        return this.mondrianRole;
    }

    public void setMondrianRole(String mondrianRole) {
        this.mondrianRole = mondrianRole;
    }

    @Override
    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String getCube() {
        return this.cube;
    }

    public void setCube(String cube) {
        this.cube = cube;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        MondrianJndiConnectionInfo that = (MondrianJndiConnectionInfo)o;
        if (this.catalog != null ? !this.catalog.equals(that.catalog) : that.catalog != null) {
            return false;
        }
        if (this.cube != null ? !this.cube.equals(that.cube) : that.cube != null) {
            return false;
        }
        if (this.mondrianRole != null ? !this.mondrianRole.equals(that.mondrianRole) : that.mondrianRole != null) {
            return false;
        }
        if (this.getPass() != null ? !this.getPass().equals(that.getPass()) : that.getPass() != null) {
            return false;
        }
        if (this.getPasswordField() != null ? !this.getPasswordField().equals(that.getPasswordField()) : that.getPasswordField() != null) {
            return false;
        }
        if (this.getRoleField() != null ? !this.getRoleField().equals(that.getRoleField()) : that.getRoleField() != null) {
            return false;
        }
        if (this.getUser() != null ? !this.getUser().equals(that.getUser()) : that.getUser() != null) {
            return false;
        }
        return !(this.getUserField() != null ? !this.getUserField().equals(that.getUserField()) : that.getUserField() != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.catalog != null ? this.catalog.hashCode() : 0);
        result = 31 * result + (this.cube != null ? this.cube.hashCode() : 0);
        result = 31 * result + (this.getRoleField() != null ? this.getRoleField().hashCode() : 0);
        result = 31 * result + (this.getUserField() != null ? this.getUserField().hashCode() : 0);
        result = 31 * result + (this.getPasswordField() != null ? this.getPasswordField().hashCode() : 0);
        result = 31 * result + (this.mondrianRole != null ? this.mondrianRole.hashCode() : 0);
        result = 31 * result + (this.getUser() != null ? this.getUser().hashCode() : 0);
        result = 31 * result + (this.getPass() != null ? this.getPass().hashCode() : 0);
        return result;
    }
}

