/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.connections.mondrian;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.DataSourceProvider;
import pt.webdetails.cda.CdaEngine;
import pt.webdetails.cda.connections.Connection;
import pt.webdetails.cda.connections.EvaluableConnection;
import pt.webdetails.cda.connections.InvalidConnectionException;
import pt.webdetails.cda.connections.mondrian.AbstractMondrianConnection;
import pt.webdetails.cda.connections.mondrian.MondrianJndiConnectionInfo;
import pt.webdetails.cda.dataaccess.IDataAccessUtils;
import pt.webdetails.cda.dataaccess.PropertyDescriptor;
import pt.webdetails.cda.utils.FormulaEvaluator;

public class JndiConnection
extends AbstractMondrianConnection
implements EvaluableConnection {
    private static final Log logger = LogFactory.getLog(JndiConnection.class);
    public static final String TYPE = "mondrianJndi";
    private MondrianJndiConnectionInfo connectionInfo;
    private Element connection;

    public JndiConnection(Element connection) throws InvalidConnectionException {
        super(connection);
        this.connection = connection;
    }

    public JndiConnection() {
    }

    public JndiConnection(String id, MondrianJndiConnectionInfo info) {
        super(id);
        this.connectionInfo = info;
    }

    @Override
    protected void initializeConnection(Element connection) throws InvalidConnectionException {
        this.connectionInfo = new MondrianJndiConnectionInfo(connection);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public DataSourceProvider getInitializedDataSourceProvider() throws InvalidConnectionException {
        logger.debug((Object)"Creating new jndi connection");
        IDataAccessUtils idu = CdaEngine.getEnvironment().getDataAccessUtils();
        return idu.getMondrianJndiDatasourceProvider(this.connectionInfo);
    }

    @Override
    public synchronized MondrianJndiConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JndiConnection that = (JndiConnection)o;
        return !(this.connectionInfo != null ? !this.connectionInfo.equals(that.connectionInfo) : that.connectionInfo != null);
    }

    @Override
    public int hashCode() {
        return this.connectionInfo != null ? this.connectionInfo.hashCode() : 0;
    }

    @Override
    public ArrayList<PropertyDescriptor> getProperties() {
        List properties = super.getProperties();
        ((ArrayList)properties).add(new PropertyDescriptor("jndi", PropertyDescriptor.Type.STRING, PropertyDescriptor.Placement.CHILD));
        return properties;
    }

    @Override
    public Connection evaluate() {
        JndiConnection evaluated = this;
        try {
            evaluated = new JndiConnection(this.connection);
        }
        catch (InvalidConnectionException e) {
            logger.error((Object)"Unable to duplicate connection for evaluation", (Throwable)e);
        }
        evaluated.setCdaSettings(this.getCdaSettings());
        evaluated.getConnectionInfo().setJndi(FormulaEvaluator.replaceFormula(this.getConnectionInfo().getJndi()));
        evaluated.getConnectionInfo().setMondrianRole(this.assembleRole(this.getConnectionInfo().getCatalog()));
        return evaluated;
    }
}

