/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.cache.monitor;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import pt.webdetails.cda.exporter.JsonExporter;

public class ExtraCacheInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int TABLE_SNAPSHOT_ROWS = 10;
    static Log logger = LogFactory.getLog(ExtraCacheInfo.class);
    private String cdaSettingsId;
    private String dataAccessId;
    private long queryDurationMs;
    private JSONObject tableSnapshot;
    private int nbrRows;
    private long entryTime;
    private int timeToLive;

    public ExtraCacheInfo(String cdaSettingsId, String dataAccessId, long queryDurationMs, TableModel tm) {
        this.cdaSettingsId = cdaSettingsId;
        this.dataAccessId = dataAccessId;
        this.queryDurationMs = queryDurationMs;
        this.nbrRows = tm.getRowCount();
        JsonExporter exporter = new JsonExporter(null);
        try {
            this.tableSnapshot = exporter.getTableAsJson(tm, 10);
        }
        catch (Exception e) {
            logger.error((Object)"Error exporting table snapshot as json.", (Throwable)e);
        }
    }

    public String getCdaSettingsId() {
        return this.cdaSettingsId;
    }

    public void setCdaSettingsId(String cdaSettingsId) {
        this.cdaSettingsId = cdaSettingsId;
    }

    public String getDataAccessId() {
        return this.dataAccessId;
    }

    public void setDataAccessId(String dataAccessId) {
        this.dataAccessId = dataAccessId;
    }

    public long getQueryDurationMs() {
        return this.queryDurationMs;
    }

    public void setQueryDurationMs(long queryDurationMs) {
        this.queryDurationMs = queryDurationMs;
    }

    public JSONObject getTableSnapshot() {
        return this.tableSnapshot;
    }

    public void setTableSnapshot(JSONObject tableSnapshot) {
        this.tableSnapshot = tableSnapshot;
    }

    public int getNbrRows() {
        return this.nbrRows;
    }

    public void setNbrRows(int nbrRows) {
        this.nbrRows = nbrRows;
    }

    public long getEntryTime() {
        return this.entryTime;
    }

    public void setEntryTime(long entryTime) {
        this.entryTime = entryTime;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(int timeToLive) {
        this.timeToLive = timeToLive;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.cdaSettingsId);
        out.writeObject(this.dataAccessId);
        out.writeLong(this.queryDurationMs);
        out.writeInt(this.nbrRows);
        out.writeLong(this.entryTime);
        out.writeInt(this.timeToLive);
        out.writeObject(this.tableSnapshot != null ? this.tableSnapshot.toString() : null);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.cdaSettingsId = (String)in.readObject();
        this.dataAccessId = (String)in.readObject();
        this.queryDurationMs = in.readLong();
        this.nbrRows = in.readInt();
        this.entryTime = in.readLong();
        this.timeToLive = in.readInt();
        try {
            this.tableSnapshot = new JSONObject((String)in.readObject());
        }
        catch (Exception e) {
            this.tableSnapshot = null;
        }
    }

    public String toString() {
        return ExtraCacheInfo.class.getName() + " [cdaSettingsId=" + this.cdaSettingsId + ", dataAccessId=" + this.dataAccessId + ", entryTime=" + this.entryTime + ", timeToLive=" + this.timeToLive + ", queryDurationMs=" + this.queryDurationMs + ", nbrRows=" + this.nbrRows + "]";
    }
}

