/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pt.webdetails.cda.CdaEngine;
import pt.webdetails.cda.dataaccess.Parameter;

public class CdaPropertiesHelper {
    static Log logger = LogFactory.getLog(Parameter.class);

    public static String getStringProperty(String key, String defaultValue) {
        return CdaEngine.getInstance().getConfigProperty(key, defaultValue);
    }

    public static boolean getBoolProperty(String key, boolean defaultValue) {
        String value = CdaPropertiesHelper.getStringProperty(key, null);
        if (value != null) {
            if ((value = value.trim().toLowerCase()).equals("true")) {
                return true;
            }
            if (value.equals("false")) {
                return false;
            }
        }
        return defaultValue;
    }

    public static int getIntProperty(String key, int defaultValue) {
        String value = CdaPropertiesHelper.getStringProperty(key, null);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                logger.error((Object)("Unparsable int in property " + key));
            }
        }
        return defaultValue;
    }
}

