/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.util;

import org.pentaho.ui.xul.IMenuCustomization;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.XulLoader;
import org.pentaho.ui.xul.components.XulMenuitem;
import org.pentaho.ui.xul.containers.XulMenu;
import org.pentaho.ui.xul.containers.XulMenubar;
import org.pentaho.ui.xul.containers.XulMenupopup;

public class MenuUtil {
    public static final boolean customizeMenu(XulMenubar menubar, IMenuCustomization customization, XulLoader xulLoader) throws XulException {
        boolean result = false;
        XulComponent anchor = menubar.getElementById(customization.getAnchorId());
        if (anchor != null && (anchor instanceof XulMenuitem || anchor instanceof XulMenupopup)) {
            if (customization.getCustomizationType() == IMenuCustomization.CustomizationType.DELETE) {
                if (anchor.getParent() instanceof XulMenu && anchor.getParent().getParent() instanceof XulMenubar) {
                    anchor.getParent().getParent().removeChild(anchor.getParent());
                } else {
                    anchor.getParent().removeChild(anchor);
                }
                return true;
            }
            XulComponent parent = null;
            int anchorIndex = -1;
            if (customization.getCustomizationType() == IMenuCustomization.CustomizationType.FIRST_CHILD || customization.getCustomizationType() == IMenuCustomization.CustomizationType.LAST_CHILD) {
                parent = anchor;
            } else if (anchor.getParent() instanceof XulMenu && anchor.getParent().getParent() instanceof XulMenubar) {
                parent = anchor.getParent().getParent();
                anchorIndex = parent.getChildNodes().indexOf(anchor.getParent());
                anchor = anchor.getParent();
            } else if (anchor.getParent() instanceof XulMenupopup && anchor.getParent().getParent() instanceof XulMenu) {
                parent = anchor.getParent();
                anchorIndex = parent.getChildNodes().indexOf(anchor);
            }
            XulComponent newItem = MenuUtil.getMenuComponent(customization, xulLoader, parent);
            if (customization.getCustomizationType() == IMenuCustomization.CustomizationType.INSERT_AFTER) {
                parent.addChildAt(newItem, anchorIndex + 1);
                result = true;
            } else if (customization.getCustomizationType() == IMenuCustomization.CustomizationType.INSERT_BEFORE) {
                parent.addChildAt(newItem, anchorIndex);
                result = true;
            } else if (customization.getCustomizationType() == IMenuCustomization.CustomizationType.FIRST_CHILD) {
                parent.addChildAt(newItem, 0);
                result = true;
            } else if (customization.getCustomizationType() == IMenuCustomization.CustomizationType.LAST_CHILD) {
                parent.addChild(newItem);
                result = true;
            } else if (customization.getCustomizationType() == IMenuCustomization.CustomizationType.REPLACE) {
                parent.replaceChild(anchor, newItem);
                result = true;
            }
        } else {
            return false;
        }
        return result;
    }

    public static final XulComponent getMenuComponent(IMenuCustomization customization, XulLoader xulLoader, XulComponent parent) throws XulException {
        XulComponent component = null;
        if (customization.getItemType() == IMenuCustomization.ItemType.MENU_ITEM) {
            XulMenuitem menuItem = (XulMenuitem)xulLoader.createElement("menuitem");
            menuItem.setLabel(customization.getLabel());
            menuItem.setCommand(customization.getCommand());
            menuItem.setId(customization.getId());
            if (parent instanceof XulMenubar) {
                XulMenu menu = (XulMenu)xulLoader.createElement("menu");
                menu.setLabel(customization.getLabel());
                menu.addChild(menuItem);
                menu.setId(customization.getId() + "-menu");
                component = menu;
            } else {
                component = menuItem;
            }
        } else if (customization.getItemType() == IMenuCustomization.ItemType.SUBMENU) {
            XulMenu menu;
            component = menu = (XulMenu)xulLoader.createElement("menu");
            menu.setLabel(customization.getLabel());
            menu.setId(customization.getId() + "-menu");
            XulMenupopup menuPopup = (XulMenupopup)xulLoader.createElement("menupopup");
            menu.addChild(menuPopup);
            menuPopup.setId(customization.getId());
        }
        return component;
    }
}

