/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.dom;

import java.lang.reflect.Constructor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.dom.Document;
import org.pentaho.ui.xul.dom.Element;

public class DocumentFactory {
    private static Class concreteClass;
    private static Class elementClass;
    private static final Log logger;

    public static void registerDOMClass(Class clazz) {
        concreteClass = clazz;
    }

    public static void registerElementClass(Class clazz) {
        elementClass = clazz;
    }

    public static Document createDocument() throws XulException {
        try {
            Constructor constructor = concreteClass.getConstructor(new Class[0]);
            Object concreteDOM = constructor.newInstance(null);
            return (Document)concreteDOM;
        }
        catch (Exception e) {
            logger.error((Object)("Error creating DOM document object: " + e.getMessage()), (Throwable)e);
            throw new XulException(e);
        }
    }

    public static Document createDocument(Object dom) throws XulException {
        try {
            Class<?> cls = dom.getClass();
            Constructor constructor = concreteClass.getConstructor(cls);
            Object concreteDOM = constructor.newInstance(dom);
            return (Document)concreteDOM;
        }
        catch (Exception e) {
            logger.error((Object)("Error creating DOM document object: " + e.getMessage()), (Throwable)e);
            throw new XulException(e);
        }
    }

    public static Element createElement(String name, XulComponent xulElement) throws XulException {
        try {
            Object element = elementClass.getConstructor(String.class, XulComponent.class).newInstance(name, xulElement);
            return (Element)element;
        }
        catch (Exception e) {
            logger.error((Object)("Error creating DOM document object: " + e.getMessage()), (Throwable)e);
            throw new XulException(e);
        }
    }

    public static Element createElement(String name) throws XulException {
        try {
            Object element = elementClass.getConstructor(String.class).newInstance(name);
            return (Element)element;
        }
        catch (Exception e) {
            logger.error((Object)("Error creating DOM document object: " + e.getMessage()), (Throwable)e);
            throw new XulException(e);
        }
    }

    static {
        logger = LogFactory.getLog(DocumentFactory.class);
    }
}

