/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mondrian.publish;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.apache.commons.lang.StringUtils;
import org.pentaho.mondrian.publish.Messages;

public class RepositoryLoginDialog
extends JDialog {
    private static final long serialVersionUID = 2458668776266464325L;
    JComboBox urlCombo = new JComboBox();
    JTextField userField = new JTextField(25);
    JPasswordField userPasswordField = new JPasswordField();
    JTextField jndiDataSourceName = new JTextField("");
    JCheckBox enableXmlaCheckBox = new JCheckBox(Messages.getString("PublishToServerCommand.XMLADataSourceLabel"));
    JCheckBox rememberSettings = new JCheckBox("Remember these Settings", true);
    boolean publishPressed = false;
    String serverURL = null;
    List<String> publishLocations = null;
    List<String> publishUserIds = null;
    List<String> publishUserPasswords = null;
    KeyListener submitListener = new KeyListener(){

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (e.getKeyChar() == '\r' || e.getKeyChar() == '\n') {
                if (StringUtils.isEmpty((String)RepositoryLoginDialog.this.getServerURL()) || StringUtils.isEmpty((String)RepositoryLoginDialog.this.getUsername()) || StringUtils.isEmpty((String)RepositoryLoginDialog.this.getUserPassword())) {
                    JOptionPane.showMessageDialog(RepositoryLoginDialog.this, "You must provide a username/password and server URL.", "Error", 0);
                } else {
                    RepositoryLoginDialog.this.publishPressed = true;
                    RepositoryLoginDialog.this.setVisible(false);
                }
            }
        }
    };

    public RepositoryLoginDialog(Frame parent, String serverURL, List<String> publishLocations, List<String> publishUserIds, List<String> publishUserPasswords, String jndiName, boolean enableXmla) {
        super(parent, "Publish Schema");
        this.init(serverURL, publishLocations, publishUserIds, publishUserPasswords, jndiName, enableXmla);
    }

    public RepositoryLoginDialog(Dialog parent, String serverURL, List<String> publishLocations, List<String> publishUserIds, List<String> publishUserPasswords, String jndiName, boolean enableXmla) {
        super(parent, "Publish Schema");
        this.init(serverURL, publishLocations, publishUserIds, publishUserPasswords, jndiName, enableXmla);
    }

    private void init(String serverURL, List<String> publishLocations, List<String> publishUserIds, List<String> publishUserPasswords, String jndiName, boolean enableXmla) {
        this.serverURL = serverURL;
        this.publishLocations = publishLocations;
        this.publishUserIds = publishUserIds;
        this.publishUserPasswords = publishUserPasswords;
        this.setModal(true);
        this.setResizable(false);
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(10, 10, 5, 10);
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        this.getContentPane().add((Component)this.buildCredentialsPanel(serverURL), c);
        c.gridy = 1;
        c.insets = new Insets(0, 10, 5, 10);
        this.getContentPane().add((Component)this.buildPublishSettingsPanel(jndiName, enableXmla), c);
        c.gridy = 2;
        this.getContentPane().add((Component)this.rememberSettings, c);
        c.gridy = 3;
        c.insets = new Insets(5, 10, 5, 10);
        this.getContentPane().add((Component)this.buildButtonPanel(), c);
        this.pack();
    }

    private JPanel buildButtonPanel() {
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 0, 0, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 0;
        c.anchor = 13;
        c.weightx = 1.0;
        JButton publishButton = new JButton("Publish");
        publishButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StringUtils.isEmpty((String)RepositoryLoginDialog.this.getServerURL()) || StringUtils.isEmpty((String)RepositoryLoginDialog.this.getUsername()) || StringUtils.isEmpty((String)RepositoryLoginDialog.this.getUserPassword())) {
                    JOptionPane.showMessageDialog(RepositoryLoginDialog.this, "You must provide a username/password and server URL.", "Error", 0);
                } else {
                    RepositoryLoginDialog.this.publishPressed = true;
                    RepositoryLoginDialog.this.setVisible(false);
                }
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RepositoryLoginDialog.this.publishPressed = false;
                RepositoryLoginDialog.this.setVisible(false);
            }
        });
        buttonPanel.add((Component)publishButton, c);
        c.gridx = 1;
        c.weightx = 0.0;
        c.insets = new Insets(0, 0, 0, 0);
        buttonPanel.add((Component)cancelButton, c);
        return buttonPanel;
    }

    private JPanel buildCredentialsPanel(String serverURL) {
        JPanel credentialsPanel = new JPanel(new GridBagLayout());
        credentialsPanel.setBorder(BorderFactory.createTitledBorder("Pentaho Credentials"));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 20, 5, 20);
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        JLabel urlLabel = new JLabel("Server URL:");
        this.urlCombo.setEditable(true);
        this.urlCombo.setModel(new DefaultComboBoxModel<Object>(this.publishLocations.toArray()));
        this.urlCombo.setSelectedItem(serverURL);
        this.urlCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RepositoryLoginDialog.this.serverURL = (String)RepositoryLoginDialog.this.urlCombo.getSelectedItem();
                int index = RepositoryLoginDialog.this.publishLocations.indexOf(RepositoryLoginDialog.this.serverURL);
                if (index >= 0 && index < RepositoryLoginDialog.this.publishUserIds.size()) {
                    RepositoryLoginDialog.this.userField.setText(RepositoryLoginDialog.this.publishUserIds.get(index));
                    RepositoryLoginDialog.this.userPasswordField.setText(RepositoryLoginDialog.this.publishUserPasswords.get(index));
                }
            }
        });
        credentialsPanel.add((Component)urlLabel, c);
        c.gridy = 1;
        c.insets = new Insets(0, 20, 0, 20);
        credentialsPanel.add((Component)this.urlCombo, c);
        c.gridy = 2;
        c.insets = new Insets(0, 20, 0, 20);
        credentialsPanel.add((Component)this.buildUserPanel(), c);
        c.gridy = 3;
        c.insets = new Insets(0, 20, 10, 20);
        return credentialsPanel;
    }

    private JPanel buildUserPanel() {
        JPanel userPanel = new JPanel(new GridBagLayout());
        JLabel userLabel = new JLabel("User:");
        JLabel passwordLabel = new JLabel("Password:");
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        userPanel.add((Component)userLabel, c);
        c.gridy = 1;
        int index = this.publishLocations.indexOf(this.serverURL);
        if (index >= 0 && index < this.publishUserIds.size()) {
            this.userField.setText(this.publishUserIds.get(index));
        }
        this.userField.addKeyListener(this.submitListener);
        userPanel.add((Component)this.userField, c);
        c.gridy = 2;
        userPanel.add((Component)passwordLabel, c);
        c.gridy = 3;
        this.userPasswordField.addKeyListener(this.submitListener);
        index = this.publishLocations.indexOf(this.serverURL);
        if (index >= 0 && index < this.publishUserPasswords.size()) {
            this.userPasswordField.setText(this.publishUserPasswords.get(index));
        }
        userPanel.add((Component)this.userPasswordField, c);
        return userPanel;
    }

    private JPanel buildPublishSettingsPanel(String jndiName, boolean enableXmla) {
        JPanel publishSettingsPanel = new JPanel(new GridBagLayout());
        publishSettingsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("PublishToServerCommand.PublishSettingsTitle")));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 0, 5);
        c.gridwidth = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.anchor = 17;
        publishSettingsPanel.add((Component)new JLabel(Messages.getString("PublishToServerCommand.DatasourceLabel")), c);
        c.insets = new Insets(5, 5, 5, 0);
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 2;
        c.anchor = 17;
        c.weightx = 1.0;
        this.jndiDataSourceName.setText(jndiName);
        publishSettingsPanel.add((Component)this.jndiDataSourceName, c);
        this.enableXmlaCheckBox.setSelected(enableXmla);
        c.gridwidth = 2;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 2;
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 2;
        c.weightx = 1.0;
        publishSettingsPanel.add((Component)this.enableXmlaCheckBox, c);
        c.weightx = 0.0;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 3;
        c.fill = 2;
        c.anchor = 17;
        this.getContentPane().add((Component)publishSettingsPanel, c);
        return publishSettingsPanel;
    }

    public boolean isPublishPressed() {
        return this.publishPressed;
    }

    public void setPublishPressed(boolean publishPressed) {
        this.publishPressed = publishPressed;
    }

    public String getServerURL() {
        return this.urlCombo.getSelectedItem().toString();
    }

    public String getUsername() {
        return this.userField.getText();
    }

    public String getUserPassword() {
        return new String(this.userPasswordField.getPassword());
    }

    public boolean getRememberSettings() {
        return this.rememberSettings.isSelected();
    }

    public String getJndiDataSourceName() {
        return this.jndiDataSourceName.getText();
    }

    public boolean getEnableXmla() {
        return this.enableXmlaCheckBox.isSelected();
    }
}

