/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mondrian.publish;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.pentaho.mondrian.publish.LocaleHelper;
import org.pentaho.mondrian.publish.MessageUtil;

public class Messages {
    private static final String BUNDLE_NAME = Messages.class.getPackage().getName() + ".messages";
    private static final Map<Locale, ResourceBundle> locales = Collections.synchronizedMap(new HashMap());

    protected static Map<Locale, ResourceBundle> getLocales() {
        return locales;
    }

    private static ResourceBundle getBundle() {
        Locale locale = LocaleHelper.getLocale();
        ResourceBundle bundle = locales.get(locale);
        if (bundle == null) {
            bundle = ResourceBundle.getBundle(BUNDLE_NAME, locale);
            locales.put(locale, bundle);
        }
        return bundle;
    }

    public static String getString(String key) {
        try {
            return Messages.getBundle().getString(key);
        }
        catch (MissingResourceException e) {
            return '!' + key + '!';
        }
    }

    public static String getString(String key, String param1) {
        return MessageUtil.getString(Messages.getBundle(), key, param1);
    }

    public static String getString(String key, String param1, String param2) {
        return MessageUtil.getString(Messages.getBundle(), key, param1, param2);
    }

    public static String getString(String key, String param1, String param2, String param3) {
        return MessageUtil.getString(Messages.getBundle(), key, param1, param2, param3);
    }

    public static String getString(String key, String param1, String param2, String param3, String param4) {
        return MessageUtil.getString(Messages.getBundle(), key, param1, param2, param3, param4);
    }

    public static String getErrorString(String key) {
        return MessageUtil.formatErrorMessage(key, Messages.getString(key));
    }

    public static String getErrorString(String key, String param1) {
        return MessageUtil.getErrorString(Messages.getBundle(), key, param1);
    }

    public static String getErrorString(String key, String param1, String param2) {
        return MessageUtil.getErrorString(Messages.getBundle(), key, param1, param2);
    }

    public static String getErrorString(String key, String param1, String param2, String param3) {
        return MessageUtil.getErrorString(Messages.getBundle(), key, param1, param2, param3);
    }
}

