/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.complex;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.Table;
import com.healthmarketscience.jackcess.complex.ComplexColumnInfo;
import com.healthmarketscience.jackcess.complex.ComplexDataType;
import com.healthmarketscience.jackcess.complex.ComplexValueForeignKey;
import com.healthmarketscience.jackcess.complex.Version;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionHistoryColumnInfo
extends ComplexColumnInfo<Version> {
    private final Column _valueCol;
    private final Column _modifiedCol;

    public VersionHistoryColumnInfo(Column column, int complexId, Table typeObjTable, Table flatTable) throws IOException {
        super(column, complexId, typeObjTable, flatTable);
        Column valueCol = null;
        Column modifiedCol = null;
        for (Column col : this.getTypeColumns()) {
            switch (col.getType()) {
                case SHORT_DATE_TIME: {
                    modifiedCol = col;
                    break;
                }
                case MEMO: {
                    valueCol = col;
                    break;
                }
            }
        }
        this._valueCol = valueCol;
        this._modifiedCol = modifiedCol;
    }

    @Override
    public void postTableLoadInit() throws IOException {
        super.postTableLoadInit();
        Column versionedCol = this.getColumn().getTable().getColumn(this.getValueColumn().getName());
        versionedCol.setVersionHistoryColumn(this.getColumn());
    }

    public Column getValueColumn() {
        return this._valueCol;
    }

    public Column getModifiedDateColumn() {
        return this._modifiedCol;
    }

    @Override
    public ComplexDataType getType() {
        return ComplexDataType.VERSION_HISTORY;
    }

    @Override
    public int updateValue(Version value) throws IOException {
        throw new UnsupportedOperationException("This column does not support value updates");
    }

    @Override
    public void deleteValue(Version value) throws IOException {
        throw new UnsupportedOperationException("This column does not support value deletes");
    }

    @Override
    public void deleteAllValues(int complexValueFk) throws IOException {
        throw new UnsupportedOperationException("This column does not support value deletes");
    }

    @Override
    protected List<Version> toValues(ComplexValueForeignKey complexValueFk, List<Map<String, Object>> rawValues) throws IOException {
        List<Version> versions = super.toValues(complexValueFk, rawValues);
        Collections.sort(versions);
        return versions;
    }

    @Override
    protected VersionImpl toValue(ComplexValueForeignKey complexValueFk, Map<String, Object> rawValue) {
        int id = (Integer)this.getPrimaryKeyColumn().getRowValue(rawValue);
        String value = (String)this.getValueColumn().getRowValue(rawValue);
        Date modifiedDate = (Date)this.getModifiedDateColumn().getRowValue(rawValue);
        return new VersionImpl(id, complexValueFk, value, modifiedDate);
    }

    @Override
    protected Object[] asRow(Object[] row, Version version) {
        super.asRow(row, version);
        this.getValueColumn().setRowValue(row, (Object)version.getValue());
        this.getModifiedDateColumn().setRowValue(row, (Object)version.getModifiedDate());
        return row;
    }

    public static Version newVersion(String value, Date modifiedDate) {
        return VersionHistoryColumnInfo.newVersion(INVALID_COMPLEX_VALUE_ID, value, modifiedDate);
    }

    public static Version newVersion(ComplexValueForeignKey complexValueFk, String value, Date modifiedDate) {
        return new VersionImpl(-1, complexValueFk, value, modifiedDate);
    }

    public static boolean isVersionHistoryColumn(Table typeObjTable) {
        List<Column> typeCols = typeObjTable.getColumns();
        if (typeCols.size() < 2) {
            return false;
        }
        int numMemo = 0;
        int numDate = 0;
        for (Column col : typeCols) {
            switch (col.getType()) {
                case SHORT_DATE_TIME: {
                    ++numDate;
                    break;
                }
                case MEMO: {
                    ++numMemo;
                    break;
                }
            }
        }
        return numMemo >= 1 && numDate >= 1;
    }

    private static class VersionImpl
    extends ComplexColumnInfo.ComplexValueImpl
    implements Version {
        private final String _value;
        private final Date _modifiedDate;

        private VersionImpl(int id, ComplexValueForeignKey complexValueFk, String value, Date modifiedDate) {
            super(id, complexValueFk);
            this._value = value;
            this._modifiedDate = modifiedDate;
        }

        public String getValue() {
            return this._value;
        }

        public Date getModifiedDate() {
            return this._modifiedDate;
        }

        public int compareTo(Version o) {
            int id2;
            Date d1 = this.getModifiedDate();
            Date d2 = o.getModifiedDate();
            int cmp = d2.compareTo(d1);
            if (cmp != 0) {
                return cmp;
            }
            int id1 = this.getId();
            if (id1 != (id2 = o.getId())) {
                return id1 > id2 ? -1 : 1;
            }
            id1 = this.getComplexValueForeignKey().get();
            return id1 > (id2 = o.getComplexValueForeignKey().get()) ? -1 : (id1 < id2 ? 1 : 0);
        }

        public void update() throws IOException {
            throw new UnsupportedOperationException("This column does not support value updates");
        }

        public void delete() throws IOException {
            throw new UnsupportedOperationException("This column does not support value deletes");
        }

        public String toString() {
            return "Version(" + this.getComplexValueForeignKey() + "," + this.getId() + ") " + this.getModifiedDate() + ", " + this.getValue();
        }
    }
}

