/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.job.entries.hl7mllpin;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.hl7mllpin.HL7MLLPInput;
import org.pentaho.di.job.entry.JobEntryDialogInterface;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.LabelText;
import org.pentaho.di.ui.core.widget.LabelTextVar;
import org.pentaho.di.ui.job.dialog.JobDialog;
import org.pentaho.di.ui.job.entry.JobEntryDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class HL7MLLPInputDialog
extends JobEntryDialog
implements JobEntryDialogInterface {
    private static Class<?> PKG = HL7MLLPInput.class;
    private LabelText wName;
    private LabelTextVar wServer;
    private LabelTextVar wPort;
    private LabelTextVar wMessageVariable;
    private LabelTextVar wMessageTypeVariable;
    private Button wOK;
    private Button wCancel;
    private HL7MLLPInput jobEntry;
    private Shell shell;
    private SelectionAdapter lsDef;
    private boolean changed;

    public HL7MLLPInputDialog(Shell parent, JobEntryInterface jobEntry, Repository rep, JobMeta jobMeta) {
        super(parent, jobEntry, rep, jobMeta);
        this.jobEntry = (HL7MLLPInput)jobEntry;
        if (this.jobEntry.getName() == null) {
            this.jobEntry.setName(BaseMessages.getString(PKG, (String)"HL7MLLPInputDialog.Name.Default", (String[])new String[0]));
        }
    }

    public JobEntryInterface open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, this.props.getJobsDialogStyle());
        this.props.setLook((Control)this.shell);
        JobDialog.setShellImage((Shell)this.shell, (JobEntryInterface)this.jobEntry);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HL7MLLPInputDialog.this.jobEntry.setChanged();
            }
        };
        this.changed = this.jobEntry.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"HL7MLLPInputDialog.Title", (String[])new String[0]));
        int margin = 4;
        this.wName = new LabelText((Composite)this.shell, BaseMessages.getString(PKG, (String)"HL7MLLPInputDialog.Name.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"HL7MLLPInputDialog.Name.Tooltip", (String[])new String[0]));
        this.wName.addModifyListener(lsMod);
        FormData fdName = new FormData();
        fdName.top = new FormAttachment(0, 0);
        fdName.left = new FormAttachment(0, 0);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
        LabelText lastControl = this.wName;
        this.wServer = new LabelTextVar((VariableSpace)this.jobMeta, (Composite)this.shell, BaseMessages.getString(PKG, (String)"HL7MLLPInputDialog.Server.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"HL7MLLPInputDialog.Server.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wServer);
        this.wServer.addModifyListener(lsMod);
        FormData fdBatchIdSchema = new FormData();
        fdBatchIdSchema.left = new FormAttachment(0, 0);
        fdBatchIdSchema.top = new FormAttachment((Control)lastControl, margin);
        fdBatchIdSchema.right = new FormAttachment(100, 0);
        this.wServer.setLayoutData((Object)fdBatchIdSchema);
        lastControl = this.wServer;
        this.wPort = new LabelTextVar((VariableSpace)this.jobMeta, (Composite)this.shell, BaseMessages.getString(PKG, (String)"HL7MLLPInputDialog.Port.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"HL7MLLPInputDialog.Port.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wPort);
        this.wPort.addModifyListener(lsMod);
        FormData fdPort = new FormData();
        fdPort.left = new FormAttachment(0, 0);
        fdPort.top = new FormAttachment((Control)lastControl, margin);
        fdPort.right = new FormAttachment(100, 0);
        this.wPort.setLayoutData((Object)fdPort);
        lastControl = this.wPort;
        this.wMessageVariable = new LabelTextVar((VariableSpace)this.jobMeta, (Composite)this.shell, BaseMessages.getString(PKG, (String)"HL7MLLPInputDialog.MessageVariable.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"HL7MLLPInputDialog.MessageVariable.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wMessageVariable);
        this.wMessageVariable.addModifyListener(lsMod);
        FormData fdMessageVariable = new FormData();
        fdMessageVariable.left = new FormAttachment(0, 0);
        fdMessageVariable.top = new FormAttachment((Control)lastControl, margin);
        fdMessageVariable.right = new FormAttachment(100, 0);
        this.wMessageVariable.setLayoutData((Object)fdMessageVariable);
        lastControl = this.wMessageVariable;
        this.wMessageTypeVariable = new LabelTextVar((VariableSpace)this.jobMeta, (Composite)this.shell, BaseMessages.getString(PKG, (String)"HL7MLLPInputDialog.MessageTypeVariable.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"HL7MLLPInputDialog.MessageTypeVariable.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wMessageTypeVariable);
        this.wMessageTypeVariable.addModifyListener(lsMod);
        FormData fdMessageTypeVariable = new FormData();
        fdMessageTypeVariable.left = new FormAttachment(0, 0);
        fdMessageTypeVariable.top = new FormAttachment((Control)lastControl, margin);
        fdMessageTypeVariable.right = new FormAttachment(100, 0);
        this.wMessageTypeVariable.setLayoutData((Object)fdMessageTypeVariable);
        lastControl = this.wMessageTypeVariable;
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        BaseStepDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{this.wOK, this.wCancel}, (int)margin, (Control)lastControl);
        this.wCancel.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                HL7MLLPInputDialog.this.cancel();
            }
        });
        this.wOK.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                HL7MLLPInputDialog.this.ok();
            }
        });
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                HL7MLLPInputDialog.this.ok();
            }
        };
        this.wName.addSelectionListener((SelectionListener)this.lsDef);
        this.wServer.addSelectionListener(this.lsDef);
        this.wPort.addSelectionListener(this.lsDef);
        this.wMessageVariable.addSelectionListener(this.lsDef);
        this.wMessageTypeVariable.addSelectionListener(this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                HL7MLLPInputDialog.this.cancel();
            }
        });
        this.getData();
        BaseStepDialog.setSize((Shell)this.shell);
        this.shell.open();
        this.props.setDialogSize(this.shell, "HL7MLLPInputDialog.DialogSize");
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.jobEntry;
    }

    public void dispose() {
        WindowProperty winprop = new WindowProperty(this.shell);
        this.props.setScreen(winprop);
        this.shell.dispose();
    }

    public void getData() {
        this.wName.setText(Const.NVL((String)this.jobEntry.getName(), (String)""));
        this.wName.getTextWidget().selectAll();
        this.wServer.setText(Const.NVL((String)this.jobEntry.getServer(), (String)""));
        this.wPort.setText(Const.NVL((String)this.jobEntry.getPort(), (String)""));
        this.wMessageVariable.setText(Const.NVL((String)this.jobEntry.getMessageVariableName(), (String)""));
        this.wMessageTypeVariable.setText(Const.NVL((String)this.jobEntry.getMessageTypeVariableName(), (String)""));
    }

    private void cancel() {
        this.jobEntry.setChanged(this.changed);
        this.jobEntry = null;
        this.dispose();
    }

    private void ok() {
        this.jobEntry.setName(this.wName.getText());
        this.getInfo(this.jobEntry);
        this.dispose();
    }

    private void getInfo(HL7MLLPInput entry) {
        entry.setServer(this.wServer.getText());
        entry.setPort(this.wPort.getText());
        entry.setMessageVariableName(this.wMessageVariable.getText());
        entry.setMessageTypeVariableName(this.wMessageTypeVariable.getText());
    }
}

