/*
 * Decompiled with CFR 0.152.
 */
package parquet.hadoop.example;

import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import parquet.Preconditions;
import parquet.example.data.Group;
import parquet.example.data.GroupWriter;
import parquet.hadoop.api.WriteSupport;
import parquet.io.api.RecordConsumer;
import parquet.schema.MessageType;
import parquet.schema.MessageTypeParser;

public class GroupWriteSupport
extends WriteSupport<Group> {
    public static final String PARQUET_EXAMPLE_SCHEMA = "parquet.example.schema";
    private MessageType schema = null;
    private GroupWriter groupWriter;

    public static void setSchema(MessageType schema, Configuration configuration) {
        configuration.set(PARQUET_EXAMPLE_SCHEMA, schema.toString());
    }

    public static MessageType getSchema(Configuration configuration) {
        return MessageTypeParser.parseMessageType(Preconditions.checkNotNull(configuration.get(PARQUET_EXAMPLE_SCHEMA), PARQUET_EXAMPLE_SCHEMA));
    }

    public GroupWriteSupport() {
    }

    GroupWriteSupport(MessageType schema) {
        this.schema = schema;
    }

    @Override
    public WriteSupport.WriteContext init(Configuration configuration) {
        if (this.schema == null) {
            this.schema = GroupWriteSupport.getSchema(configuration);
        }
        return new WriteSupport.WriteContext(this.schema, new HashMap<String, String>());
    }

    @Override
    public void prepareForWrite(RecordConsumer recordConsumer) {
        this.groupWriter = new GroupWriter(recordConsumer, this.schema);
    }

    @Override
    public void write(Group record) {
        this.groupWriter.write(record);
    }
}

