/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.xbaseinput;

import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.fileinput.FileInputList;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.xbaseinput.XBase;
import org.pentaho.di.trans.steps.xbaseinput.XBaseInput;
import org.pentaho.di.trans.steps.xbaseinput.XBaseInputData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class XBaseInputMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = XBaseInputMeta.class;
    private String dbfFileName;
    private int rowLimit;
    private boolean rowNrAdded;
    private String rowNrField;
    private boolean acceptingFilenames;
    private String acceptingField;
    private String acceptingStepName;
    private StepMeta acceptingStep;
    private boolean includeFilename;
    private String filenameField;
    private String charactersetName;

    public String getDbfFileName() {
        return this.dbfFileName;
    }

    public void setDbfFileName(String dbfFileName) {
        this.dbfFileName = dbfFileName;
    }

    public int getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(int rowLimit) {
        this.rowLimit = rowLimit;
    }

    public String getRowNrField() {
        return this.rowNrField;
    }

    public void setRowNrField(String rowNrField) {
        this.rowNrField = rowNrField;
    }

    public boolean isRowNrAdded() {
        return this.rowNrAdded;
    }

    public void setRowNrAdded(boolean rowNrAdded) {
        this.rowNrAdded = rowNrAdded;
    }

    public String getAcceptingField() {
        return this.acceptingField;
    }

    public void setAcceptingField(String acceptingField) {
        this.acceptingField = acceptingField;
    }

    public boolean isAcceptingFilenames() {
        return this.acceptingFilenames;
    }

    public void setAcceptingFilenames(boolean acceptingFilenames) {
        this.acceptingFilenames = acceptingFilenames;
    }

    public StepMeta getAcceptingStep() {
        return this.acceptingStep;
    }

    public void setAcceptingStep(StepMeta acceptingStep) {
        this.acceptingStep = acceptingStep;
    }

    public String getAcceptingStepName() {
        return this.acceptingStepName;
    }

    public void setAcceptingStepName(String acceptingStepName) {
        this.acceptingStepName = acceptingStepName;
    }

    public String getFilenameField() {
        return this.filenameField;
    }

    public void setFilenameField(String filenameField) {
        this.filenameField = filenameField;
    }

    public boolean includeFilename() {
        return this.includeFilename;
    }

    public void setIncludeFilename(boolean includeFilename) {
        this.includeFilename = includeFilename;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        XBaseInputMeta retval = (XBaseInputMeta)super.clone();
        return retval;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.dbfFileName = XMLHandler.getTagValue((Node)stepnode, (String)"file_dbf");
            this.rowLimit = Const.toInt((String)XMLHandler.getTagValue((Node)stepnode, (String)"limit"), (int)0);
            this.rowNrAdded = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"add_rownr"));
            this.rowNrField = XMLHandler.getTagValue((Node)stepnode, (String)"field_rownr");
            this.includeFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"include"));
            this.filenameField = XMLHandler.getTagValue((Node)stepnode, (String)"include_field");
            this.charactersetName = XMLHandler.getTagValue((Node)stepnode, (String)"charset_name");
            this.acceptingFilenames = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"accept_filenames"));
            this.acceptingField = XMLHandler.getTagValue((Node)stepnode, (String)"accept_field");
            this.acceptingStepName = XMLHandler.getTagValue((Node)stepnode, (String)"accept_stepname");
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"XBaseInputMeta.Exception.UnableToReadStepInformationFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.dbfFileName = null;
        this.rowLimit = 0;
        this.rowNrAdded = false;
        this.rowNrField = null;
    }

    public String getLookupStepname() {
        if (this.acceptingFilenames && this.acceptingStep != null && !Utils.isEmpty((CharSequence)this.acceptingStep.getName())) {
            return this.acceptingStep.getName();
        }
        return null;
    }

    @Override
    public void searchInfoAndTargetSteps(List<StepMeta> steps) {
        this.acceptingStep = StepMeta.findStep(steps, this.acceptingStepName);
    }

    public String[] getInfoSteps() {
        if (this.acceptingFilenames && this.acceptingStep != null) {
            return new String[]{this.acceptingStep.getName()};
        }
        return null;
    }

    public RowMetaInterface getOutputFields(FileInputList files, String name) throws KettleStepException {
        RowMeta rowMeta = new RowMeta();
        try (XBase xbi = null;){
            xbi = new XBase(this.getLog(), KettleVFS.getInputStream((FileObject)files.getFile(0)));
            xbi.setDbfFile(files.getFile(0).getName().getURI());
            xbi.open();
            RowMetaInterface add = xbi.getFields();
            for (int i = 0; i < add.size(); ++i) {
                ValueMetaInterface v = add.getValueMeta(i);
                v.setOrigin(name);
            }
            rowMeta.addRowMeta(add);
        }
        if (this.rowNrAdded && this.rowNrField != null && this.rowNrField.length() > 0) {
            ValueMetaInteger rnr = new ValueMetaInteger(this.rowNrField);
            rnr.setOrigin(name);
            rowMeta.addValueMeta((ValueMetaInterface)rnr);
        }
        if (this.includeFilename) {
            ValueMetaString v = new ValueMetaString(this.filenameField);
            v.setLength(100, -1);
            v.setOrigin(name);
            rowMeta.addValueMeta((ValueMetaInterface)v);
        }
        return rowMeta;
    }

    @Override
    public void getFields(RowMetaInterface row, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        FileInputList fileList = this.getTextFileList(space);
        if (fileList.nrOfFiles() == 0) {
            throw new KettleStepException(BaseMessages.getString(PKG, (String)"XBaseInputMeta.Exception.NoFilesFoundToProcess", (String[])new String[0]));
        }
        row.addRowMeta(this.getOutputFields(fileList, name));
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder();
        retval.append("    " + XMLHandler.addTagValue((String)"file_dbf", (String)this.dbfFileName));
        retval.append("    " + XMLHandler.addTagValue((String)"limit", (int)this.rowLimit));
        retval.append("    " + XMLHandler.addTagValue((String)"add_rownr", (boolean)this.rowNrAdded));
        retval.append("    " + XMLHandler.addTagValue((String)"field_rownr", (String)this.rowNrField));
        retval.append("    " + XMLHandler.addTagValue((String)"include", (boolean)this.includeFilename));
        retval.append("    " + XMLHandler.addTagValue((String)"include_field", (String)this.filenameField));
        retval.append("    " + XMLHandler.addTagValue((String)"charset_name", (String)this.charactersetName));
        retval.append("    " + XMLHandler.addTagValue((String)"accept_filenames", (boolean)this.acceptingFilenames));
        retval.append("    " + XMLHandler.addTagValue((String)"accept_field", (String)this.acceptingField));
        if (this.acceptingStepName == null && this.acceptingStep != null) {
            this.acceptingStepName = this.acceptingStep.getName();
        }
        retval.append("    " + XMLHandler.addTagValue((String)"accept_stepname", (String)this.acceptingStepName));
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.dbfFileName = rep.getStepAttributeString(id_step, "file_dbf");
            this.rowLimit = (int)rep.getStepAttributeInteger(id_step, "limit");
            this.rowNrAdded = rep.getStepAttributeBoolean(id_step, "add_rownr");
            this.rowNrField = rep.getStepAttributeString(id_step, "field_rownr");
            this.includeFilename = rep.getStepAttributeBoolean(id_step, "include");
            this.filenameField = rep.getStepAttributeString(id_step, "include_field");
            this.charactersetName = rep.getStepAttributeString(id_step, "charset_name");
            this.acceptingFilenames = rep.getStepAttributeBoolean(id_step, "accept_filenames");
            this.acceptingField = rep.getStepAttributeString(id_step, "accept_field");
            this.acceptingStepName = rep.getStepAttributeString(id_step, "accept_stepname");
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"XBaseInputMeta.Exception.UnexpectedErrorReadingMetaDataFromRepository", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "file_dbf", this.dbfFileName);
            rep.saveStepAttribute(id_transformation, id_step, "limit", this.rowLimit);
            rep.saveStepAttribute(id_transformation, id_step, "add_rownr", this.rowNrAdded);
            rep.saveStepAttribute(id_transformation, id_step, "field_rownr", this.rowNrField);
            rep.saveStepAttribute(id_transformation, id_step, "include", this.includeFilename);
            rep.saveStepAttribute(id_transformation, id_step, "include_field", this.filenameField);
            rep.saveStepAttribute(id_transformation, id_step, "charset_name", this.charactersetName);
            rep.saveStepAttribute(id_transformation, id_step, "accept_filenames", this.acceptingFilenames);
            rep.saveStepAttribute(id_transformation, id_step, "accept_field", this.acceptingField);
            if (this.acceptingStepName == null && this.acceptingStep != null) {
                this.acceptingStepName = this.acceptingStep.getName();
            }
            rep.saveStepAttribute(id_transformation, id_step, "accept_stepname", this.acceptingStepName);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"XBaseInputMeta.Exception.UnableToSaveMetaDataToRepository", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        if (this.dbfFileName == null) {
            if (this.isAcceptingFilenames()) {
                CheckResult cr;
                if (Utils.isEmpty((CharSequence)this.getAcceptingStepName())) {
                    cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"XBaseInput.Log.Error.InvalidAcceptingStepName", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                }
                if (Utils.isEmpty((CharSequence)this.getAcceptingField())) {
                    cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"XBaseInput.Log.Error.InvalidAcceptingFieldName", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                }
            } else {
                CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"XBaseInputMeta.Remark.PleaseSelectFileToUse", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        } else {
            CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"XBaseInputMeta.Remark.FileToUseIsSpecified", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            try (XBase xbi = new XBase(this.getLog(), transMeta.environmentSubstitute(this.dbfFileName));){
                xbi.open();
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"XBaseInputMeta.Remark.FileExistsAndCanBeOpened", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
                RowMetaInterface r = xbi.getFields();
                cr = new CheckResult(1, r.size() + BaseMessages.getString(PKG, (String)"XBaseInputMeta.Remark.OutputFieldsCouldBeDetermined", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new XBaseInput(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new XBaseInputData();
    }

    public String[] getFilePaths(VariableSpace space) {
        return FileInputList.createFilePathList((VariableSpace)space, (String[])new String[]{this.dbfFileName}, (String[])new String[]{null}, (String[])new String[]{null}, (String[])new String[]{"N"});
    }

    public FileInputList getTextFileList(VariableSpace space) {
        return FileInputList.createFileList((VariableSpace)space, (String[])new String[]{this.dbfFileName}, (String[])new String[]{null}, (String[])new String[]{null}, (String[])new String[]{"N"});
    }

    @Override
    public String[] getUsedLibraries() {
        return new String[]{"javadbf.jar"};
    }

    public String getCharactersetName() {
        return this.charactersetName;
    }

    public void setCharactersetName(String charactersetName) {
        this.charactersetName = charactersetName;
    }

    @Override
    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface resourceNamingInterface, Repository repository, IMetaStore metaStore) throws KettleException {
        try {
            FileObject fileObject;
            if (!this.acceptingFilenames && (fileObject = KettleVFS.getFileObject((String)space.environmentSubstitute(this.dbfFileName), (VariableSpace)space)).exists()) {
                this.dbfFileName = resourceNamingInterface.nameResource(fileObject, space, true);
                return this.dbfFileName;
            }
            return null;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }
}

