/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mondrianinput;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.sql.DataSource;
import mondrian.olap.Axis;
import mondrian.olap.Cell;
import mondrian.olap.Connection;
import mondrian.olap.DriverManager;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.Position;
import mondrian.olap.Query;
import mondrian.olap.Result;
import mondrian.olap.Util;
import org.pentaho.di.core.DBCache;
import org.pentaho.di.core.DBCacheEntry;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.database.util.DatabaseUtil;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBigNumber;
import org.pentaho.di.core.row.value.ValueMetaBoolean;
import org.pentaho.di.core.row.value.ValueMetaDate;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaNumber;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.steps.mondrianinput.MondrianInputMeta;

public class MondrianHelper {
    private DatabaseMeta databaseMeta;
    private String catalog;
    private String queryString;
    private RowMetaInterface outputRowMeta;
    private Result result;
    private Query query;
    private VariableSpace space;
    private String role;
    private List<List<Object>> rows;
    private List<String> headings;
    private LogChannelInterface log;
    private Connection connection;
    private static Class<?> PKG = MondrianInputMeta.class;

    public MondrianHelper(DatabaseMeta databaseMeta, String catalog, String queryString, VariableSpace space) {
        this.databaseMeta = databaseMeta;
        this.catalog = catalog;
        this.queryString = queryString;
        this.space = space;
        if (space instanceof StepInterface) {
            this.log = ((StepInterface)space).getLogChannel();
        }
    }

    public void openQuery() throws KettleDatabaseException {
        this.connection = null;
        String realRole = this.space.environmentSubstitute(this.role);
        if (this.databaseMeta.getAccessType() == 4) {
            DataSource dataSource = new DatabaseUtil().getNamedDataSource(this.databaseMeta.getDatabaseName());
            Util.PropertyList propList = new Util.PropertyList();
            propList.put("Provider", "mondrian");
            propList.put("Catalog", this.space.environmentSubstitute(this.catalog));
            if (!Utils.isEmpty((CharSequence)realRole)) {
                propList.put("Role", realRole);
            }
            this.connection = DriverManager.getConnection((Util.PropertyList)propList, null, (DataSource)dataSource);
        } else {
            String password;
            String connectString = "Provider=mondrian;Jdbc='" + this.space.environmentSubstitute(this.databaseMeta.getURL()) + "';Catalog='" + this.space.environmentSubstitute(this.catalog) + "';JdbcDrivers=" + this.space.environmentSubstitute(this.databaseMeta.getDriverClass()) + ";";
            if (!Utils.isEmpty((CharSequence)this.databaseMeta.getUsername())) {
                connectString = connectString + "JdbcUser=" + this.space.environmentSubstitute(this.databaseMeta.getUsername()) + ";";
            }
            if (!Utils.isEmpty((CharSequence)(password = this.databaseMeta.getPassword()))) {
                String realPassword = Utils.resolvePassword((VariableSpace)this.space, (String)password);
                connectString = connectString + "JdbcPassword=" + this.space.environmentSubstitute(realPassword) + ";";
            }
            if (!Utils.isEmpty((CharSequence)realRole)) {
                connectString = connectString + "Role=" + realRole + ";";
            }
            this.connection = DriverManager.getConnection((String)connectString, null);
        }
        this.query = this.connection.parseQuery(this.queryString);
        this.result = this.connection.execute(this.query);
    }

    public void close() {
        if (this.result != null) {
            block9: {
                try {
                    this.result.close();
                }
                catch (Exception ignored) {
                    if (this.log == null || !this.log.isDebug()) break block9;
                    this.log.logDebug(ignored.getMessage());
                }
            }
            this.result = null;
        }
        if (this.query != null) {
            block10: {
                try {
                    this.query.close();
                }
                catch (Exception ignored) {
                    if (this.log == null || !this.log.isDebug()) break block10;
                    this.log.logDebug(ignored.getMessage());
                }
            }
            this.query = null;
        }
        if (this.connection != null) {
            block11: {
                try {
                    this.connection.close();
                }
                catch (Exception ignored) {
                    if (this.log == null || !this.log.isDebug()) break block11;
                    this.log.logDebug(ignored.getMessage());
                }
            }
            this.connection = null;
        }
    }

    public void createRectangularOutput() throws KettleDatabaseException {
        Axis[] axes = this.result.getAxes();
        if (axes.length != 2) {
            throw new KettleDatabaseException(BaseMessages.getString(PKG, (String)"MondrianInputErrorOnlyTabular", (String[])new String[0]));
        }
        this.headings = new ArrayList<String>();
        this.rows = new ArrayList<List<Object>>();
        Axis rowsAxis = axes[1];
        Axis columnsAxis = axes[0];
        int rowOrdinal = -1;
        int[] coords = new int[]{0, 0};
        for (Position rowPos : rowsAxis.getPositions()) {
            Iterator columnPos2;
            coords[1] = ++rowOrdinal;
            if (rowOrdinal == 0) {
                for (Member rowMember : rowPos) {
                    this.headings.add(rowMember.getHierarchy().getUniqueName());
                }
                for (Iterator columnPos2 : columnsAxis.getPositions()) {
                    String heading = "";
                    Iterator iterator = columnPos2.iterator();
                    while (iterator.hasNext()) {
                        Member columnMember = (Member)iterator.next();
                        if (!heading.equals("")) {
                            heading = heading + ", ";
                        }
                        heading = heading + columnMember.getUniqueName();
                    }
                    this.headings.add(heading);
                }
            }
            ArrayList<Object> rowValues = new ArrayList<Object>();
            columnPos2 = rowPos.iterator();
            while (columnPos2.hasNext()) {
                Member rowMember = (Member)columnPos2.next();
                rowValues.add(rowMember.getUniqueName());
            }
            int columnOrdinal = 0;
            while (columnOrdinal < columnsAxis.getPositions().size()) {
                coords[0] = columnOrdinal++;
                Cell cell = this.result.getCell(coords);
                rowValues.add(cell.getValue());
            }
            this.rows.add(rowValues);
        }
        this.outputRowMeta = new RowMeta();
        if (this.rows.size() > 0) {
            int columnCount = this.rows.get(0).size();
            HashMap<Integer, ValueMetaString> valueMetaHash = new HashMap<Integer, ValueMetaString>();
            for (int i = 0; i < this.rows.size(); ++i) {
                List<Object> rowValues = this.rows.get(i);
                for (int c = 0; c < rowValues.size(); ++c) {
                    ValueMetaString valueMeta;
                    Object valueData;
                    if (valueMetaHash.containsKey(new Integer(c)) || (valueData = rowValues.get(c)) == null) continue;
                    String valueName = this.headings.get(c);
                    if (valueData instanceof String) {
                        valueMeta = new ValueMetaString(valueName);
                    } else if (valueData instanceof Date) {
                        valueMeta = new ValueMetaDate(valueName);
                    } else if (valueData instanceof Boolean) {
                        valueMeta = new ValueMetaBoolean(valueName);
                    } else if (valueData instanceof Integer) {
                        valueMeta = new ValueMetaInteger(valueName);
                        valueData = ((Integer)valueData).longValue();
                    } else if (valueData instanceof Short) {
                        valueMeta = new ValueMetaInteger(valueName);
                        valueData = ((Short)valueData).longValue();
                    } else if (valueData instanceof Byte) {
                        valueMeta = new ValueMetaInteger(valueName);
                        valueData = ((Byte)valueData).longValue();
                    } else if (valueData instanceof Long) {
                        valueMeta = new ValueMetaInteger(valueName);
                    } else if (valueData instanceof Double) {
                        valueMeta = new ValueMetaNumber(valueName);
                    } else if (valueData instanceof Float) {
                        valueMeta = new ValueMetaNumber(valueName);
                        valueData = ((Float)valueData).doubleValue();
                    } else if (valueData instanceof BigDecimal) {
                        valueMeta = new ValueMetaBigNumber(valueName);
                    } else {
                        throw new KettleDatabaseException(BaseMessages.getString(PKG, (String)"MondrianInputErrorUnhandledType", (String[])new String[]{valueData.getClass().toString()}));
                    }
                    valueMetaHash.put(c, valueMeta);
                }
                if (valueMetaHash.size() == columnCount) break;
            }
            ArrayList<Object> valueMetaList = new ArrayList<Object>();
            for (int c = 0; c < columnCount; ++c) {
                if (valueMetaHash.containsKey(new Integer(c))) {
                    valueMetaList.add(valueMetaHash.get(new Integer(c)));
                    continue;
                }
                ValueMetaString valueMeta = new ValueMetaString(this.headings.get(c));
                valueMetaList.add(valueMeta);
            }
            this.outputRowMeta.setValueMetaList(valueMetaList);
        }
        DBCacheEntry cacheEntry = new DBCacheEntry(this.databaseMeta.getName(), this.queryString);
        DBCache.getInstance().put(cacheEntry, this.outputRowMeta);
    }

    public void createFlattenedOutput() throws KettleDatabaseException {
        Axis[] axes = this.result.getAxes();
        this.rows = new ArrayList<List<Object>>();
        this.headings = new ArrayList<String>();
        for (Axis axis : axes) {
            List positions = axis.getPositions();
            if (positions.isEmpty()) {
                return;
            }
            for (Member member : (Position)positions.get(0)) {
                Hierarchy hierarchy = member.getHierarchy();
                this.headings.add(hierarchy.getUniqueName());
            }
        }
        int[] coords = new int[axes.length];
        MondrianHelper.outputFlattenedRecurse(this.result, this.rows, new ArrayList<Object>(), coords, 0);
        this.outputRowMeta = new RowMeta();
        for (int i = 0; i < this.rows.size() && i < 1; ++i) {
            List<Object> rowValues = this.rows.get(i);
            for (int c = 0; c < rowValues.size(); ++c) {
                int valueType;
                Object valueData = rowValues.get(c);
                if (valueData instanceof String) {
                    valueType = 2;
                } else if (valueData instanceof Date) {
                    valueType = 3;
                } else if (valueData instanceof Boolean) {
                    valueType = 4;
                } else if (valueData instanceof Integer) {
                    valueType = 5;
                    valueData = ((Integer)valueData).longValue();
                } else if (valueData instanceof Short) {
                    valueType = 5;
                    valueData = ((Short)valueData).longValue();
                } else if (valueData instanceof Byte) {
                    valueType = 5;
                    valueData = ((Byte)valueData).longValue();
                } else if (valueData instanceof Long) {
                    valueType = 5;
                } else if (valueData instanceof Double) {
                    valueType = 1;
                } else if (valueData instanceof Float) {
                    valueType = 1;
                    valueData = ((Float)valueData).doubleValue();
                } else if (valueData instanceof BigDecimal) {
                    valueType = 6;
                } else {
                    throw new KettleDatabaseException(BaseMessages.getString(PKG, (String)"MondrianInputErrorUnhandledType", (String[])new String[]{valueData.getClass().toString()}));
                }
                try {
                    ValueMetaInterface valueMeta = ValueMetaFactory.createValueMeta((String)this.headings.get(c), (int)valueType);
                    this.outputRowMeta.addValueMeta(valueMeta);
                    rowValues.set(i, valueData);
                    continue;
                }
                catch (Exception e) {
                    throw new KettleDatabaseException((Throwable)e);
                }
            }
        }
        DBCacheEntry cacheEntry = new DBCacheEntry(this.databaseMeta.getName(), this.queryString);
        DBCache.getInstance().put(cacheEntry, this.outputRowMeta);
    }

    public RowMetaInterface getCachedRowMeta() {
        DBCacheEntry cacheEntry = new DBCacheEntry(this.databaseMeta.getName(), this.queryString);
        return DBCache.getInstance().get(cacheEntry);
    }

    private static void outputFlattenedRecurse(Result result, List<List<Object>> rows, List<Object> rowValues, int[] coords, int axisOrdinal) {
        Axis[] axes = result.getAxes();
        if (axisOrdinal == axes.length) {
            Cell cell = result.getCell(coords);
            rowValues.add(cell.getValue());
            rows.add(new ArrayList<Object>(rowValues));
        } else {
            Axis axis = axes[axisOrdinal];
            int k = -1;
            int saveLength = rowValues.size();
            for (Position position : axis.getPositions()) {
                coords[axisOrdinal] = ++k;
                for (Member member : position) {
                    rowValues.add(member.getUniqueName());
                }
                MondrianHelper.outputFlattenedRecurse(result, rows, rowValues, coords, axisOrdinal + 1);
                while (rowValues.size() > saveLength) {
                    rowValues.remove(rowValues.size() - 1);
                }
            }
        }
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta databaseMeta) {
        this.databaseMeta = databaseMeta;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public RowMetaInterface getOutputRowMeta() {
        return this.outputRowMeta;
    }

    public Result getResult() {
        return this.result;
    }

    public Query getQuery() {
        return this.query;
    }

    public List<List<Object>> getRows() {
        return this.rows;
    }

    public List<String> getHeadings() {
        return this.headings;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }
}

