/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.fixedinput;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.trans.step.StepInjectionMetaEntry;
import org.pentaho.di.trans.step.StepMetaInjectionInterface;
import org.pentaho.di.trans.steps.fixedinput.FixedFileInputField;
import org.pentaho.di.trans.steps.fixedinput.FixedInputMeta;

public class FixedInputMetaInjection
implements StepMetaInjectionInterface {
    private FixedInputMeta meta;

    public FixedInputMetaInjection(FixedInputMeta meta) {
        this.meta = meta;
    }

    @Override
    public List<StepInjectionMetaEntry> getStepInjectionMetadataEntries() throws KettleException {
        ArrayList<StepInjectionMetaEntry> all = new ArrayList<StepInjectionMetaEntry>();
        StepInjectionMetaEntry fieldsEntry = new StepInjectionMetaEntry(Entry.FIELDS.name(), Entry.FIELDS.getValueType(), Entry.FIELDS.getDescription());
        all.add(fieldsEntry);
        StepInjectionMetaEntry fieldEntry = new StepInjectionMetaEntry(Entry.FIELD.name(), Entry.FIELD.getValueType(), Entry.FIELD.getDescription());
        fieldsEntry.getDetails().add(fieldEntry);
        for (Entry entry : Entry.values()) {
            StepInjectionMetaEntry metaEntry;
            if (entry.getParent() == Entry.FIELD) {
                metaEntry = new StepInjectionMetaEntry(entry.name(), entry.getValueType(), entry.getDescription());
                fieldEntry.getDetails().add(metaEntry);
                continue;
            }
            if (entry.getParent() != null || entry == Entry.FIELDS || entry == Entry.FIELD) continue;
            metaEntry = new StepInjectionMetaEntry(entry.name(), entry.getValueType(), entry.getDescription());
            all.add(metaEntry);
        }
        return all;
    }

    @Override
    public void injectStepMetadataEntries(List<StepInjectionMetaEntry> all) throws KettleException {
        ArrayList<FixedFileInputField> fixedInputFields = new ArrayList<FixedFileInputField>();
        block24: for (StepInjectionMetaEntry lookFields : all) {
            String lookValue = (String)lookFields.getValue();
            Entry fieldsEntry = Entry.findEntry(lookFields.getKey());
            if (fieldsEntry == null) continue;
            switch (fieldsEntry) {
                case FIELDS: {
                    for (StepInjectionMetaEntry lookField : lookFields.getDetails()) {
                        Entry fieldEntry = Entry.findEntry(lookField.getKey());
                        if (fieldEntry == null || fieldEntry != Entry.FIELD) continue;
                        FixedFileInputField inputField = new FixedFileInputField();
                        List<StepInjectionMetaEntry> entries = lookField.getDetails();
                        for (StepInjectionMetaEntry entry : entries) {
                            Entry metaEntry = Entry.findEntry(entry.getKey());
                            if (metaEntry == null) continue;
                            String value = (String)entry.getValue();
                            switch (metaEntry) {
                                case NAME: {
                                    inputField.setName(value);
                                    break;
                                }
                                case TYPE: {
                                    inputField.setType(ValueMetaFactory.getIdForValueMeta((String)value));
                                    break;
                                }
                                case WIDTH: {
                                    inputField.setWidth(Const.toInt((String)value, (int)-1));
                                    break;
                                }
                                case LENGTH: {
                                    inputField.setLength(Const.toInt((String)value, (int)-1));
                                    break;
                                }
                                case PRECISION: {
                                    inputField.setPrecision(Const.toInt((String)value, (int)-1));
                                    break;
                                }
                                case CURRENCY: {
                                    inputField.setCurrency(value);
                                    break;
                                }
                                case GROUP: {
                                    inputField.setGrouping(value);
                                    break;
                                }
                                case DECIMAL: {
                                    inputField.setDecimal(value);
                                    break;
                                }
                                case FORMAT: {
                                    inputField.setFormat(value);
                                    break;
                                }
                                case TRIM_TYPE: {
                                    inputField.setTrimType(ValueMetaString.getTrimTypeByCode((String)value));
                                    break;
                                }
                            }
                        }
                        fixedInputFields.add(inputField);
                    }
                    continue block24;
                }
                case FILENAME: {
                    this.meta.setFilename(lookValue);
                    break;
                }
                case HEADER_PRESENT: {
                    this.meta.setHeaderPresent("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case LINE_WIDTH: {
                    this.meta.setLineWidth(lookValue);
                    break;
                }
                case BUFFER_SIZE: {
                    this.meta.setBufferSize(lookValue);
                    break;
                }
                case LAZY_CONVERSION_ACTIVE: {
                    this.meta.setLazyConversionActive("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case LINE_FEED_PRESENT: {
                    this.meta.setLineFeedPresent("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case RUNNING_IN_PARALLEL: {
                    this.meta.setRunningInParallel("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case FILE_TYPE_CODE: {
                    this.meta.setFileType(FixedInputMeta.getFileType(lookValue));
                    break;
                }
                case ADD_TO_RESULT: {
                    this.meta.setAddResultFile("Y".equalsIgnoreCase(lookValue));
                    break;
                }
            }
        }
        this.meta.setFieldDefinition(fixedInputFields.toArray(new FixedFileInputField[fixedInputFields.size()]));
    }

    @Override
    public List<StepInjectionMetaEntry> extractStepMetadataEntries() throws KettleException {
        return null;
    }

    public FixedInputMeta getMeta() {
        return this.meta;
    }

    private static enum Entry {
        FIELDS(0, "All the data fields in the fixed width file"),
        FIELD(0, "One data field"),
        NAME(FIELD, 2, "Field name"),
        TYPE(FIELD, 2, "Field data type"),
        WIDTH(FIELD, 2, "Field width"),
        LENGTH(FIELD, 2, "Field length"),
        PRECISION(FIELD, 2, "Field precision"),
        FORMAT(FIELD, 2, "Field conversion format"),
        TRIM_TYPE(FIELD, 2, "Field trim type (none, left, right, both)"),
        CURRENCY(FIELD, 2, "Field currency symbol"),
        DECIMAL(FIELD, 2, "Field decimal symbol"),
        GROUP(FIELD, 2, "Field group symbol"),
        FILENAME(2, "Filename"),
        HEADER_PRESENT(2, "Header present? (Y/N)"),
        LINE_WIDTH(2, "The line width"),
        BUFFER_SIZE(2, "The buffer size"),
        LAZY_CONVERSION_ACTIVE(2, "Lazy conversion active? (Y/N)"),
        LINE_FEED_PRESENT(2, "Line feed present? (Y/N)"),
        RUNNING_IN_PARALLEL(2, "Running in parallel? (Y/N)"),
        FILE_TYPE_CODE(2, "File type code (NONE, UNIX, DOS)"),
        ADD_TO_RESULT(2, "Add filename to result? (Y/N)");

        private int valueType;
        private String description;
        private Entry parent;

        private Entry(int valueType, String description) {
            this.valueType = valueType;
            this.description = description;
        }

        private Entry(Entry parent, int valueType, String description) {
            this.parent = parent;
            this.valueType = valueType;
            this.description = description;
        }

        public int getValueType() {
            return this.valueType;
        }

        public String getDescription() {
            return this.description;
        }

        public static Entry findEntry(String key) {
            return Entry.valueOf(key);
        }

        public Entry getParent() {
            return this.parent;
        }
    }
}

