/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.step;

import java.util.List;
import org.apache.commons.lang.BooleanUtils;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.step.StepMeta;

public class StepOption {
    private static Class<?> PKG = StepOption.class;
    private final String key;
    private final String text;
    private String value;

    public StepOption(String key, String text, String value) {
        this.key = key;
        this.text = text;
        this.value = value;
    }

    public String getKey() {
        return this.key;
    }

    public String getText() {
        return this.text;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public static void checkInteger(List<CheckResultInterface> remarks, StepMeta stepMeta, VariableSpace space, String identifier, String value) {
        try {
            if (!StringUtil.isEmpty((String)space.environmentSubstitute(value))) {
                Integer.parseInt(space.environmentSubstitute(value));
            }
        }
        catch (NumberFormatException e) {
            remarks.add((CheckResultInterface)new CheckResult(4, BaseMessages.getString(PKG, (String)"StepOption.CheckResult.NotAInteger", (String[])new String[]{identifier}), (CheckResultSourceInterface)stepMeta));
        }
    }

    public static void checkLong(List<CheckResultInterface> remarks, StepMeta stepMeta, VariableSpace space, String identifier, String value) {
        try {
            if (!StringUtil.isEmpty((String)space.environmentSubstitute(value))) {
                Long.parseLong(space.environmentSubstitute(value));
            }
        }
        catch (NumberFormatException e) {
            remarks.add((CheckResultInterface)new CheckResult(4, BaseMessages.getString(PKG, (String)"StepOption.CheckResult.NotAInteger", (String[])new String[]{identifier}), (CheckResultSourceInterface)stepMeta));
        }
    }

    public static void checkBoolean(List<CheckResultInterface> remarks, StepMeta stepMeta, VariableSpace space, String identifier, String value) {
        if (!StringUtil.isEmpty((String)space.environmentSubstitute(value)) && null == BooleanUtils.toBooleanObject((String)space.environmentSubstitute(value))) {
            remarks.add((CheckResultInterface)new CheckResult(4, BaseMessages.getString(PKG, (String)"StepOption.CheckResult.NotABoolean", (String[])new String[]{identifier}), (CheckResultSourceInterface)stepMeta));
        }
    }
}

