/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.filerep;

import java.util.List;
import java.util.Map;
import org.json.simple.JSONObject;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.BaseRepositoryMeta;
import org.pentaho.di.repository.RepositoriesMeta;
import org.pentaho.di.repository.RepositoryCapabilities;
import org.pentaho.di.repository.RepositoryMeta;
import org.w3c.dom.Node;

public class KettleFileRepositoryMeta
extends BaseRepositoryMeta
implements RepositoryMeta {
    public static final String SHOW_HIDDEN_FOLDERS = "showHiddenFolders";
    public static final String LOCATION = "location";
    public static final String DO_NOT_MODIFY = "doNotModify";
    public static String REPOSITORY_TYPE_ID = "KettleFileRepository";
    private String baseDirectory;
    private boolean readOnly;
    private boolean hidingHiddenFiles;

    public KettleFileRepositoryMeta() {
        super(REPOSITORY_TYPE_ID);
    }

    public KettleFileRepositoryMeta(String id, String name, String description, String baseDirectory) {
        super(id, name, description);
        this.baseDirectory = baseDirectory;
    }

    @Override
    public RepositoryCapabilities getRepositoryCapabilities() {
        return new RepositoryCapabilities(){

            @Override
            public boolean supportsUsers() {
                return false;
            }

            @Override
            public boolean managesUsers() {
                return false;
            }

            @Override
            public boolean isReadOnly() {
                return KettleFileRepositoryMeta.this.readOnly;
            }

            @Override
            public boolean supportsRevisions() {
                return false;
            }

            @Override
            public boolean supportsMetadata() {
                return false;
            }

            @Override
            public boolean supportsLocking() {
                return false;
            }

            @Override
            public boolean hasVersionRegistry() {
                return false;
            }

            @Override
            public boolean supportsAcls() {
                return false;
            }

            @Override
            public boolean supportsReferences() {
                return false;
            }
        };
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder(100);
        retval.append("  ").append(XMLHandler.openTag((String)"repository"));
        retval.append(super.getXML());
        retval.append("    ").append(XMLHandler.addTagValue((String)"base_directory", (String)this.baseDirectory));
        retval.append("    ").append(XMLHandler.addTagValue((String)"read_only", (boolean)this.readOnly));
        retval.append("    ").append(XMLHandler.addTagValue((String)"hides_hidden_files", (boolean)this.hidingHiddenFiles));
        retval.append("  ").append(XMLHandler.closeTag((String)"repository"));
        return retval.toString();
    }

    @Override
    public void loadXML(Node repnode, List<DatabaseMeta> databases) throws KettleException {
        super.loadXML(repnode, databases);
        try {
            this.baseDirectory = XMLHandler.getTagValue((Node)repnode, (String)"base_directory");
            this.readOnly = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)repnode, (String)"read_only"));
            this.hidingHiddenFiles = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)repnode, (String)"hides_hidden_files"));
        }
        catch (Exception e) {
            throw new KettleException("Unable to load Kettle file repository meta object", (Throwable)e);
        }
    }

    public String getBaseDirectory() {
        return this.baseDirectory;
    }

    public void setBaseDirectory(String baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public RepositoryMeta clone() {
        return new KettleFileRepositoryMeta(REPOSITORY_TYPE_ID, this.getName(), this.getDescription(), this.getBaseDirectory());
    }

    @Override
    public void populate(Map<String, Object> properties, RepositoriesMeta repositoriesMeta) {
        super.populate(properties, repositoriesMeta);
        Boolean showHiddenFolders = (Boolean)properties.get(SHOW_HIDDEN_FOLDERS);
        String location = (String)properties.get(LOCATION);
        Boolean doNotModify = (Boolean)properties.get(DO_NOT_MODIFY);
        this.setHidingHiddenFiles(showHiddenFolders);
        this.setBaseDirectory(location);
        this.setReadOnly(doNotModify);
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject object = super.toJSONObject();
        object.put((Object)SHOW_HIDDEN_FOLDERS, (Object)this.isHidingHiddenFiles());
        object.put((Object)LOCATION, (Object)this.getBaseDirectory());
        object.put((Object)DO_NOT_MODIFY, (Object)this.isReadOnly());
        return object;
    }

    public boolean isHidingHiddenFiles() {
        return this.hidingHiddenFiles;
    }

    public void setHidingHiddenFiles(boolean hidingHiddenFiles) {
        this.hidingHiddenFiles = hidingHiddenFiles;
    }
}

