/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleRepositoryNotSupportedException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.RepositoryPluginType;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.core.xml.XMLParserFactoryProducer;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.repository.kdr.KettleDatabaseRepositoryMeta;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class RepositoriesMeta {
    private static Class<?> PKG = RepositoriesMeta.class;
    private List<DatabaseMeta> databases;
    private List<RepositoryMeta> repositories;
    private LogChannel log;
    private String errorMessage;

    public RepositoriesMeta() {
        this.clear();
    }

    public void clear() {
        this.errorMessage = null;
        this.databases = new ArrayList<DatabaseMeta>();
        this.repositories = new ArrayList<RepositoryMeta>();
        LogLevel level = null;
        if (this.log != null) {
            level = this.log.getLogLevel();
        }
        this.setLog(this.newLogChannel());
        if (level != null) {
            this.log.setLogLevel(level);
        }
    }

    LogChannel newLogChannel() {
        return new LogChannel((Object)"RepositoriesMeta");
    }

    public void addDatabase(DatabaseMeta ci) {
        this.databases.add(ci);
    }

    public void addRepository(RepositoryMeta ri) {
        this.repositories.add(ri);
    }

    void setLog(LogChannel log) {
        this.log = log;
    }

    public void addDatabase(int p, DatabaseMeta ci) {
        this.databases.add(p, ci);
    }

    public void addRepository(int p, RepositoryMeta ri) {
        this.repositories.add(p, ri);
    }

    public DatabaseMeta getDatabase(int i) {
        return this.databases.get(i);
    }

    public RepositoryMeta getRepository(int i) {
        return this.repositories.get(i);
    }

    public void removeDatabase(int i) {
        if (i < 0 || i >= this.databases.size()) {
            return;
        }
        this.databases.remove(i);
    }

    public void removeRepository(int i) {
        if (i < 0 || i >= this.repositories.size()) {
            return;
        }
        this.repositories.remove(i);
    }

    public int nrDatabases() {
        return this.databases.size();
    }

    public int nrRepositories() {
        return this.repositories.size();
    }

    public DatabaseMeta searchDatabase(String name) {
        for (int i = 0; i < this.nrDatabases(); ++i) {
            if (!this.getDatabase(i).getName().equalsIgnoreCase(name)) continue;
            return this.getDatabase(i);
        }
        return null;
    }

    public RepositoryMeta searchRepository(String name) {
        for (int i = 0; i < this.nrRepositories(); ++i) {
            String repName = this.getRepository(i).getName();
            if (repName == null || !repName.equalsIgnoreCase(name)) continue;
            return this.getRepository(i);
        }
        return null;
    }

    public int indexOfDatabase(DatabaseMeta di) {
        return this.databases.indexOf(di);
    }

    public int indexOfRepository(RepositoryMeta ri) {
        return this.repositories.indexOf(ri);
    }

    public RepositoryMeta findRepository(String name) {
        for (int i = 0; i < this.nrRepositories(); ++i) {
            RepositoryMeta ri = this.getRepository(i);
            if (!ri.getName().equalsIgnoreCase(name)) continue;
            return ri;
        }
        return null;
    }

    public RepositoryMeta findRepositoryById(String id) {
        for (int i = 0; i < this.nrRepositories(); ++i) {
            RepositoryMeta ri = this.getRepository(i);
            if (!ri.getId().equalsIgnoreCase(id)) continue;
            return ri;
        }
        return null;
    }

    public boolean readData() throws KettleException {
        this.clear();
        File file = new File(this.getKettleLocalRepositoriesFile());
        if (!file.exists() || !file.isFile()) {
            if (this.log.isDetailed()) {
                this.log.logDetailed(BaseMessages.getString(PKG, (String)"RepositoryMeta.Log.NoRepositoryFileInLocalDirectory", (String[])new String[]{file.getAbsolutePath()}));
            }
            if (!(file = new File(this.getKettleUserRepositoriesFile())).exists() || !file.isFile()) {
                return true;
            }
        }
        if (this.log.isBasic()) {
            this.log.logBasic(BaseMessages.getString(PKG, (String)"RepositoryMeta.Log.ReadingXMLFile", (Object[])new Object[]{file.getAbsoluteFile()}));
        }
        try {
            Document doc;
            DocumentBuilderFactory dbf = XMLParserFactoryProducer.createSecureDocBuilderFactory();
            DocumentBuilder db = dbf.newDocumentBuilder();
            try {
                doc = db.parse(file);
            }
            catch (FileNotFoundException ef) {
                try (InputStream is = this.getClass().getResourceAsStream("/org/pentaho/di/repository/repositories.xml");){
                    if (is != null) {
                        doc = db.parse(is);
                    }
                    throw new KettleException(BaseMessages.getString(PKG, (String)"RepositoryMeta.Error.OpeningFile", (Object[])new Object[]{file.getAbsoluteFile()}), (Throwable)ef);
                }
            }
            this.parseRepositoriesDoc(doc);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"RepositoryMeta.Error.ReadingInfo", (String[])new String[0]), (Throwable)e);
        }
        return true;
    }

    public String getKettleUserRepositoriesFile() {
        return Const.getKettleUserRepositoriesFile();
    }

    String getKettleLocalRepositoriesFile() {
        return Const.getKettleLocalRepositoriesFile();
    }

    public void readDataFromInputStream(InputStream is) throws KettleException {
        this.clear();
        if (this.log.isBasic()) {
            this.log.logBasic(BaseMessages.getString(PKG, (String)"RepositoryMeta.Log.ReadingXMLFile", (String[])new String[]{"FromInputStream"}));
        }
        try {
            DocumentBuilderFactory dbf = XMLParserFactoryProducer.createSecureDocBuilderFactory();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(is);
            this.parseRepositoriesDoc(doc);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"RepositoryMeta.Error.ReadingInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    protected void parseRepositoriesDoc(Document doc) throws Exception {
        Node repsnode = XMLHandler.getSubNode((Node)doc, (String)"repositories");
        int nrconn = XMLHandler.countNodes((Node)repsnode, (String)"connection");
        if (this.log.isDebug()) {
            this.log.logDebug(BaseMessages.getString(PKG, (String)"RepositoryMeta.Log.ConnectionNumber", (Object[])new Object[]{nrconn}));
        }
        for (int i = 0; i < nrconn; ++i) {
            if (this.log.isDebug()) {
                this.log.logDebug(BaseMessages.getString(PKG, (String)"RepositoryMeta.Log.LookingConnection", (Object[])new Object[]{i}));
            }
            Node dbnode = XMLHandler.getSubNodeByNr((Node)repsnode, (String)"connection", (int)i);
            DatabaseMeta dbcon = null;
            try {
                dbcon = new DatabaseMeta(dbnode);
                this.addDatabase(dbcon);
                if (!this.log.isDebug()) continue;
                this.log.logDebug(BaseMessages.getString(PKG, (String)"RepositoryMeta.Log.ReadConnection", (String[])new String[]{dbcon.getName()}));
                continue;
            }
            catch (Exception kpe) {
                this.log.logError(BaseMessages.getString(PKG, (String)"RepositoryMeta.Error.CreatingDatabaseMeta", (String[])new String[]{dbcon.getName()}));
            }
        }
        int nrreps = XMLHandler.countNodes((Node)repsnode, (String)"repository");
        if (this.log.isDebug()) {
            this.log.logDebug(BaseMessages.getString(PKG, (String)"RepositoryMeta.Log.RepositoryNumber", (Object[])new Object[]{nrreps}));
        }
        StringBuilder unableToReadIds = new StringBuilder();
        KettleException kettleException = null;
        for (int i = 0; i < nrreps; ++i) {
            String id;
            Node repnode = XMLHandler.getSubNodeByNr((Node)repsnode, (String)"repository", (int)i);
            if (this.log.isDebug()) {
                this.log.logDebug(BaseMessages.getString(PKG, (String)"RepositoryMeta.Log.LookingRepository", (Object[])new Object[]{i}));
            }
            if (Utils.isEmpty((CharSequence)(id = XMLHandler.getTagValue((Node)repnode, (String)"id")))) {
                id = KettleDatabaseRepositoryMeta.REPOSITORY_TYPE_ID;
            }
            try {
                RepositoryMeta repositoryMeta = (RepositoryMeta)PluginRegistry.getInstance().loadClass(RepositoryPluginType.class, id, RepositoryMeta.class);
                if (repositoryMeta != null) {
                    repositoryMeta.loadXML(repnode, this.databases);
                    if (repositoryMeta.getDescription() == null || repositoryMeta.getDescription().equals("")) {
                        repositoryMeta.setDescription(repositoryMeta.getName());
                    }
                    this.addRepository(repositoryMeta);
                    if (!this.log.isDebug()) continue;
                    this.log.logDebug(BaseMessages.getString(PKG, (String)"RepositoryMeta.Log.ReadRepository", (String[])new String[]{repositoryMeta.getName()}));
                    continue;
                }
                unableToReadIds.append(id);
                unableToReadIds.append(",");
                if (!this.log.isDebug()) continue;
                this.log.logDebug(BaseMessages.getString(PKG, (String)"RepositoryMeta.Error.ReadRepositoryId", (String[])new String[]{id}));
                continue;
            }
            catch (KettleException ex) {
                Throwable cause = ex;
                kettleException = ex;
                while (cause.getCause() != null) {
                    cause = cause.getCause();
                }
                if (!(cause instanceof KettleRepositoryNotSupportedException) || !this.log.isDebug()) continue;
                this.log.logDebug(BaseMessages.getString(PKG, (String)"RepositoryMeta.Error.UnrecognizedRepositoryType", (String[])new String[]{id}));
            }
        }
        if (unableToReadIds != null && unableToReadIds.length() > 0) {
            this.errorMessage = BaseMessages.getString(PKG, (String)"RepositoryMeta.Error.ReadRepositoryIdNotAvailable", (String[])new String[]{unableToReadIds.substring(0, unableToReadIds.lastIndexOf(","))});
        }
        if (kettleException != null) {
            throw kettleException;
        }
    }

    public String getXML() {
        int i;
        String retval = "";
        retval = retval + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + Const.CR;
        retval = retval + "<repositories>" + Const.CR;
        for (i = 0; i < this.nrDatabases(); ++i) {
            DatabaseMeta conn = this.getDatabase(i);
            retval = retval + conn.getXML();
        }
        for (i = 0; i < this.nrRepositories(); ++i) {
            RepositoryMeta ri = this.getRepository(i);
            retval = retval + ri.getXML();
        }
        retval = retval + "  </repositories>" + Const.CR;
        return retval;
    }

    public void writeData() throws KettleException {
        try {
            FileOutputStream fos = new FileOutputStream(new File(this.getKettleUserRepositoriesFile()));
            fos.write(this.getXML().getBytes());
            fos.close();
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"RepositoryMeta.Error.WritingMetadata", (String[])new String[0]), (Throwable)e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public RepositoriesMeta clone() {
        RepositoriesMeta meta = new RepositoriesMeta();
        meta.clear();
        for (DatabaseMeta dbMeta : this.databases) {
            meta.addDatabase(dbMeta);
        }
        for (RepositoryMeta repMeta : this.repositories) {
            meta.addRepository(repMeta.clone());
        }
        return meta;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public LogChannelInterface getLog() {
        return this.log;
    }
}

