/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.util.serialization;

import java.util.Objects;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.util.serialization.MetaXmlSerializer;
import org.pentaho.di.core.util.serialization.StepMetaProps;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.step.StepMetaInterface;

public class RepoSerializer {
    private final StepMetaInterface stepMetaInterface;
    private final Repository rep;
    private final ObjectId idTrans;
    private final ObjectId idStep;
    private static final String REPO_TAG = "step-xml";

    private RepoSerializer(StepMetaInterface stepMetaInterface, Repository rep, ObjectId idTrans, ObjectId idStep) {
        this.stepMetaInterface = stepMetaInterface;
        this.rep = rep;
        this.idTrans = idTrans;
        this.idStep = idStep;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void serialize() throws KettleException {
        String xml = MetaXmlSerializer.serialize(StepMetaProps.from(this.stepMetaInterface));
        this.rep.saveStepAttribute(this.idTrans, this.idStep, REPO_TAG, xml);
    }

    public void deserialize() throws KettleException {
        String xml = this.rep.getStepAttributeString(this.idStep, REPO_TAG);
        Objects.requireNonNull(MetaXmlSerializer.deserialize(xml)).to(this.stepMetaInterface);
    }

    public static class Builder {
        private Repository repo;
        private StepMetaInterface stepMetaInterface;
        private ObjectId idTrans;
        private ObjectId idStep;

        public Builder repo(Repository repo) {
            this.repo = repo;
            return this;
        }

        public Builder stepMeta(StepMetaInterface stepMetaInterface) {
            this.stepMetaInterface = stepMetaInterface;
            return this;
        }

        public Builder transId(ObjectId idTrans) {
            this.idTrans = idTrans;
            return this;
        }

        public Builder stepId(ObjectId idStep) {
            this.idStep = idStep;
            return this;
        }

        public void serialize() throws KettleException {
            new RepoSerializer(Objects.requireNonNull(this.stepMetaInterface), Objects.requireNonNull(this.repo), this.idTrans, this.idStep).serialize();
        }

        public void deserialize() throws KettleException {
            new RepoSerializer(Objects.requireNonNull(this.stepMetaInterface), Objects.requireNonNull(this.repo), null, this.idStep).deserialize();
        }
    }
}

