/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.accessoutput;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.Cursor;
import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.Table;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.step.BaseStepData;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.steps.accessoutput.AccessOutputMeta;

public class AccessOutputData
extends BaseStepData
implements StepDataInterface {
    public Database db;
    public Table table;
    public List<Object[]> rows = new ArrayList<Object[]>();
    public RowMetaInterface outputRowMeta;
    public boolean oneFileOpened = false;

    void createDatabase(File databaseFile) throws IOException {
        this.db = Database.create((File)databaseFile);
    }

    void openDatabase(File databaseFile) throws IOException {
        this.db = Database.open((File)databaseFile);
    }

    void closeDatabase() throws IOException {
        this.db.close();
    }

    void createTable(String tableName, RowMetaInterface rowMeta) throws IOException {
        List<Column> columns = AccessOutputMeta.getColumns(rowMeta);
        this.db.createTable(tableName, columns);
        this.table = this.db.getTable(tableName);
    }

    void addRowToTable(Object ... row) throws IOException {
        this.table.addRow(row);
    }

    void addRowsToTable(List<Object[]> rows) throws IOException {
        this.table.addRows(rows);
    }

    void truncateTable() throws IOException {
        if (this.table == null) {
            return;
        }
        Cursor tableRows = Cursor.createCursor((Table)this.table);
        while (tableRows.moveToNextRow()) {
            tableRows.deleteCurrentRow();
        }
    }
}

