/*
 * Decompiled with CFR 0.152.
 */
package org.productivity.java.syslog4j.impl;

import java.util.ArrayList;
import java.util.List;
import org.productivity.java.syslog4j.SyslogBackLogHandlerIF;
import org.productivity.java.syslog4j.SyslogConfigIF;
import org.productivity.java.syslog4j.SyslogIF;
import org.productivity.java.syslog4j.SyslogMessageIF;
import org.productivity.java.syslog4j.SyslogMessageModifierIF;
import org.productivity.java.syslog4j.SyslogMessageProcessorIF;
import org.productivity.java.syslog4j.SyslogRuntimeException;
import org.productivity.java.syslog4j.impl.AbstractSyslogConfigIF;
import org.productivity.java.syslog4j.impl.AbstractSyslogWriter;
import org.productivity.java.syslog4j.impl.message.processor.SyslogMessageProcessor;
import org.productivity.java.syslog4j.impl.message.processor.structured.StructuredSyslogMessageProcessor;
import org.productivity.java.syslog4j.impl.message.structured.StructuredSyslogMessage;
import org.productivity.java.syslog4j.impl.message.structured.StructuredSyslogMessageIF;
import org.productivity.java.syslog4j.util.SyslogUtility;

public abstract class AbstractSyslog
implements SyslogIF {
    private static final long serialVersionUID = 2632017043774808264L;
    protected String syslogProtocol = null;
    protected AbstractSyslogConfigIF syslogConfig = null;
    protected SyslogMessageProcessorIF syslogMessageProcessor = null;
    protected SyslogMessageProcessorIF structuredSyslogMessageProcessor = null;
    protected Object backLogStatusSyncObject = new Object();
    protected boolean backLogStatus = false;
    protected List notifiedBackLogHandlers = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean getBackLogStatus() {
        Object object = this.backLogStatusSyncObject;
        synchronized (object) {
            return this.backLogStatus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBackLogStatus(boolean bl) {
        if (this.backLogStatus != bl) {
            Object object = this.backLogStatusSyncObject;
            synchronized (object) {
                if (!bl) {
                    for (int i = 0; i < this.notifiedBackLogHandlers.size(); ++i) {
                        SyslogBackLogHandlerIF syslogBackLogHandlerIF = (SyslogBackLogHandlerIF)this.notifiedBackLogHandlers.get(i);
                        syslogBackLogHandlerIF.up(this);
                    }
                    this.notifiedBackLogHandlers.clear();
                }
                this.backLogStatus = bl;
            }
        }
    }

    public void initialize(String string, SyslogConfigIF syslogConfigIF) throws SyslogRuntimeException {
        this.syslogProtocol = string;
        try {
            this.syslogConfig = (AbstractSyslogConfigIF)syslogConfigIF;
        }
        catch (ClassCastException classCastException) {
            throw new SyslogRuntimeException("provided config must implement AbstractSyslogConfigIF");
        }
        this.initialize();
    }

    public SyslogMessageProcessorIF getMessageProcessor() {
        if (this.syslogMessageProcessor == null) {
            this.syslogMessageProcessor = SyslogMessageProcessor.getDefault();
        }
        return this.syslogMessageProcessor;
    }

    public SyslogMessageProcessorIF getStructuredMessageProcessor() {
        if (this.structuredSyslogMessageProcessor == null) {
            this.structuredSyslogMessageProcessor = StructuredSyslogMessageProcessor.getDefault();
        }
        return this.structuredSyslogMessageProcessor;
    }

    public void setMessageProcessor(SyslogMessageProcessorIF syslogMessageProcessorIF) {
        this.syslogMessageProcessor = syslogMessageProcessorIF;
    }

    public void setStructuredMessageProcessor(SyslogMessageProcessorIF syslogMessageProcessorIF) {
        this.structuredSyslogMessageProcessor = syslogMessageProcessorIF;
    }

    public String getProtocol() {
        return this.syslogProtocol;
    }

    public SyslogConfigIF getConfig() {
        return this.syslogConfig;
    }

    public void log(int n, String string) {
        if (this.syslogConfig.isUseStructuredData()) {
            StructuredSyslogMessage structuredSyslogMessage = new StructuredSyslogMessage(null, null, string);
            this.log(this.getStructuredMessageProcessor(), n, structuredSyslogMessage.createMessage());
        } else {
            this.log(this.getMessageProcessor(), n, string);
        }
    }

    public void log(int n, SyslogMessageIF syslogMessageIF) {
        if (syslogMessageIF instanceof StructuredSyslogMessageIF) {
            if (this.getMessageProcessor() instanceof StructuredSyslogMessageProcessor) {
                this.log(this.getMessageProcessor(), n, syslogMessageIF.createMessage());
            } else {
                this.log(this.getStructuredMessageProcessor(), n, syslogMessageIF.createMessage());
            }
        } else {
            this.log(this.getMessageProcessor(), n, syslogMessageIF.createMessage());
        }
    }

    public void debug(String string) {
        this.log(7, string);
    }

    public void notice(String string) {
        this.log(5, string);
    }

    public void info(String string) {
        this.log(6, string);
    }

    public void warn(String string) {
        this.log(4, string);
    }

    public void error(String string) {
        this.log(3, string);
    }

    public void critical(String string) {
        this.log(2, string);
    }

    public void alert(String string) {
        this.log(1, string);
    }

    public void emergency(String string) {
        this.log(0, string);
    }

    public void debug(SyslogMessageIF syslogMessageIF) {
        this.log(7, syslogMessageIF);
    }

    public void notice(SyslogMessageIF syslogMessageIF) {
        this.log(5, syslogMessageIF);
    }

    public void info(SyslogMessageIF syslogMessageIF) {
        this.log(6, syslogMessageIF);
    }

    public void warn(SyslogMessageIF syslogMessageIF) {
        this.log(4, syslogMessageIF);
    }

    public void error(SyslogMessageIF syslogMessageIF) {
        this.log(3, syslogMessageIF);
    }

    public void critical(SyslogMessageIF syslogMessageIF) {
        this.log(2, syslogMessageIF);
    }

    public void alert(SyslogMessageIF syslogMessageIF) {
        this.log(1, syslogMessageIF);
    }

    public void emergency(SyslogMessageIF syslogMessageIF) {
        this.log(0, syslogMessageIF);
    }

    protected String prefixMessage(String string, String string2) {
        String string3 = this.syslogConfig.getIdent();
        String string4 = (string3 == null || "".equals(string3.trim()) ? "" : string3 + string2) + string;
        return string4;
    }

    public void log(SyslogMessageProcessorIF syslogMessageProcessorIF, int n, String string) {
        block6: {
            String string2 = null;
            if (this.syslogConfig.isIncludeIdentInMessageModifier()) {
                string2 = this.prefixMessage(string, ": ");
                string2 = this.modifyMessage(n, string2);
            } else {
                string2 = this.modifyMessage(n, string);
                string2 = this.prefixMessage(string2, ": ");
            }
            try {
                this.write(syslogMessageProcessorIF, n, string2);
            }
            catch (SyslogRuntimeException syslogRuntimeException) {
                if (syslogRuntimeException.getCause() != null) {
                    this.backLog(n, string2, syslogRuntimeException.getCause());
                } else {
                    this.backLog(n, string2, syslogRuntimeException);
                }
                if (!this.syslogConfig.isThrowExceptionOnWrite()) break block6;
                throw syslogRuntimeException;
            }
        }
    }

    protected void write(SyslogMessageProcessorIF syslogMessageProcessorIF, int n, String string) throws SyslogRuntimeException {
        String string2 = syslogMessageProcessorIF.createSyslogHeader(this.syslogConfig.getFacility(), n, this.syslogConfig.getLocalName(), this.syslogConfig.isSendLocalTimestamp(), this.syslogConfig.isSendLocalName());
        byte[] byArray = SyslogUtility.getBytes(this.syslogConfig, string2);
        byte[] byArray2 = SyslogUtility.getBytes(this.syslogConfig, string);
        int n2 = byArray2.length;
        int n3 = this.syslogConfig.getMaxMessageLength() - byArray.length;
        if (this.syslogConfig.isTruncateMessage() && n3 > 0 && n2 > n3) {
            n2 = n3;
        }
        if (n2 <= n3) {
            byte[] byArray3 = syslogMessageProcessorIF.createPacketData(byArray, byArray2, 0, n2);
            this.write(n, byArray3);
        } else {
            int n4;
            byte[] byArray4 = this.syslogConfig.getSplitMessageBeginText();
            byte[] byArray5 = this.syslogConfig.getSplitMessageEndText();
            int n5 = 0;
            for (int i = n2; i > 0; i -= n4) {
                boolean bl = n5 == 0;
                boolean bl2 = byArray4 != null && !bl;
                boolean bl3 = byArray4 != null && (bl || i > n3 - byArray4.length);
                n4 = n3;
                n4 -= byArray4 != null && bl2 ? byArray4.length : 0;
                if ((n4 -= byArray5 != null && bl3 ? byArray5.length : 0) > i) {
                    n4 = i;
                }
                if (n4 < 0) {
                    throw new SyslogRuntimeException("Message length < 0; recommendation: increase the size of maxMessageLength");
                }
                byte[] byArray6 = syslogMessageProcessorIF.createPacketData(byArray, byArray2, n5, n4, (byte[])(bl2 ? byArray4 : null), (byte[])(bl3 ? byArray5 : null));
                this.write(n, byArray6);
                n5 += n4;
            }
        }
    }

    protected abstract void initialize() throws SyslogRuntimeException;

    protected abstract void write(int var1, byte[] var2) throws SyslogRuntimeException;

    protected String modifyMessage(int n, String string) {
        List list = this.syslogConfig.getMessageModifiers();
        if (list == null || list.size() < 1) {
            return string;
        }
        String string2 = string;
        int n2 = this.syslogConfig.getFacility();
        for (int i = 0; i < list.size(); ++i) {
            SyslogMessageModifierIF syslogMessageModifierIF = (SyslogMessageModifierIF)list.get(i);
            string2 = syslogMessageModifierIF.modify(this, n2, n, string2);
        }
        return string2;
    }

    public void backLog(int n, String string, Throwable throwable) {
        this.backLog(n, string, throwable != null ? throwable.toString() : "UNKNOWN");
    }

    public void backLog(int n, String string, String string2) {
        boolean bl = this.getBackLogStatus();
        if (!bl) {
            this.setBackLogStatus(true);
        }
        List list = this.syslogConfig.getBackLogHandlers();
        for (int i = 0; i < list.size(); ++i) {
            SyslogBackLogHandlerIF syslogBackLogHandlerIF = (SyslogBackLogHandlerIF)list.get(i);
            try {
                if (!bl) {
                    syslogBackLogHandlerIF.down(this, string2);
                    this.notifiedBackLogHandlers.add(syslogBackLogHandlerIF);
                }
                syslogBackLogHandlerIF.log(this, n, string, string2);
                break;
            }
            catch (Exception exception) {
                continue;
            }
        }
    }

    public abstract AbstractSyslogWriter getWriter();

    public abstract void returnWriter(AbstractSyslogWriter var1);

    public Thread createWriterThread(AbstractSyslogWriter abstractSyslogWriter) {
        Thread thread = new Thread(abstractSyslogWriter);
        thread.setName("SyslogWriter: " + this.getProtocol());
        thread.setDaemon(this.syslogConfig.isUseDaemonThread());
        if (this.syslogConfig.getThreadPriority() > -1) {
            thread.setPriority(this.syslogConfig.getThreadPriority());
        }
        abstractSyslogWriter.setThread(thread);
        thread.start();
        return thread;
    }

    public AbstractSyslogWriter createWriter() {
        AbstractSyslogWriter abstractSyslogWriter;
        block4: {
            Class clazz = this.syslogConfig.getSyslogWriterClass();
            abstractSyslogWriter = null;
            try {
                abstractSyslogWriter = (AbstractSyslogWriter)clazz.newInstance();
                abstractSyslogWriter.initialize(this);
            }
            catch (InstantiationException instantiationException) {
                if (this.syslogConfig.isThrowExceptionOnInitialize()) {
                    throw new SyslogRuntimeException(instantiationException);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                if (!this.syslogConfig.isThrowExceptionOnInitialize()) break block4;
                throw new SyslogRuntimeException(illegalAccessException);
            }
        }
        return abstractSyslogWriter;
    }
}

