/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.json.JSONArray;
import org.json.JSONException;
import org.xml.sax.EntityResolver;
import pt.webdetails.cdf.dd.CdeEngine;
import pt.webdetails.cdf.dd.ICdeEnvironment;
import pt.webdetails.cdf.dd.structure.DashboardWcdfDescriptor;
import pt.webdetails.cdf.dd.util.CdeEnvironment;
import pt.webdetails.cpf.Util;
import pt.webdetails.cpf.repository.api.FileAccess;
import pt.webdetails.cpf.repository.api.IBasicFile;
import pt.webdetails.cpf.repository.api.IContentAccessFactory;
import pt.webdetails.cpf.repository.api.IRWAccess;
import pt.webdetails.cpf.repository.api.IReadAccess;
import pt.webdetails.cpf.repository.api.IUserContentAccess;
import pt.webdetails.cpf.utils.CharsetHelper;
import pt.webdetails.cpf.utils.XmlParserFactoryProducer;

public class Utils {
    private static final Log logger = LogFactory.getLog(Utils.class);
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final DecimalFormat defaultNbrFormat = new DecimalFormat("0.00");

    public static String composeErrorMessage(String message, Exception cause) {
        String msg = "";
        if (StringUtils.isNotEmpty((String)message)) {
            msg = msg + message;
        }
        if (cause != null) {
            if (msg.length() > 0) {
                msg = msg + NEWLINE;
            }
            msg = msg + cause.getMessage();
        }
        return msg;
    }

    public static void main(String[] args) {
        try {
            URI uri = new URI("http://127.0.0.1:8080/pentaho/");
            System.out.println(uri.getPath());
            uri = new URI("/pentaho/");
            System.out.println(uri.getPath());
            uri = new URI("http://127.0.0.1:8080/pentaho");
            System.out.println(uri.getPath());
            uri = new URI("/pentaho");
            System.out.println(uri.getPath());
        }
        catch (URISyntaxException ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public static String joinPath(String ... paths) {
        return StringUtils.defaultString((String)StringUtils.join((Object[])paths, (String)"/")).replaceAll("/+", "/");
    }

    public static String toFirstLowerCase(String text) {
        if (text == null) {
            return null;
        }
        return text.length() > 1 ? text.substring(0, 1).toLowerCase() + text.substring(1) : text.toLowerCase();
    }

    public static String toFirstUpperCase(String text) {
        if (text == null) {
            return null;
        }
        return text.length() > 1 ? text.substring(0, 1).toUpperCase() + text.substring(1) : text.toUpperCase();
    }

    public static String ellapsedSeconds(long start) {
        return defaultNbrFormat.format((double)(System.currentTimeMillis() - start) / 1000.0);
    }

    public static String sanitizeSlashesInPath(String path) {
        if (StringUtils.isEmpty((String)path)) {
            return "";
        }
        return ("/" + path).replaceAll("\\\\+", "/").replaceAll("/+", "/");
    }

    public static String getNodeText(String xpath, Node node) {
        return Utils.getNodeText(xpath, node, null);
    }

    public static String getNodeText(String xpath, Node node, String defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        Node n = node.selectSingleNode(xpath);
        if (n == null) {
            return defaultValue;
        }
        return n.getText();
    }

    public static Document getDocFromFile(IBasicFile file, EntityResolver resolver) throws DocumentException, IOException {
        SAXReader reader = XmlParserFactoryProducer.getSAXReader((EntityResolver)resolver);
        return reader.read(file.getContents());
    }

    public static Document getDocument(InputStream input) throws DocumentException {
        SAXReader reader = XmlParserFactoryProducer.getSAXReader(null);
        return reader.read(input);
    }

    @Deprecated
    public static List<Node> selectNodes(Element elem, String xpath) {
        return elem.selectNodes(xpath);
    }

    @Deprecated
    public static List<Node> selectNodes(Document doc, String xpath) {
        return doc.selectNodes(xpath);
    }

    public static List<Element> selectElements(Element elem, String xpath) {
        return Utils.selectNodes(elem, xpath);
    }

    public static List<Element> selectElements(Document doc, String xpath) {
        return Utils.selectNodes(doc, xpath);
    }

    public static Document getDocFromFile(IReadAccess access, String filePath, EntityResolver resolver) throws DocumentException, IOException {
        return access != null && filePath != null ? Utils.getDocFromFile(access.fetchFile(filePath), resolver) : null;
    }

    public static IReadAccess getAppropriateReadAccess(String resource) {
        return Utils.getAppropriateReadAccess(resource, null);
    }

    public static IReadAccess getAppropriateReadAccess(String resource, String basePath) {
        return Utils.getAppropriateReadAccess(resource, basePath, Utils.getCdeEnvironment());
    }

    public static IReadAccess getAppropriateReadAccess(String resource, String basePath, ICdeEnvironment environment) {
        if (StringUtils.isEmpty((String)resource)) {
            return null;
        }
        IContentAccessFactory factory = environment.getContentAccessFactory();
        String systemDir = environment.getSystemDir() + "/";
        String repoDir = environment.getPluginRepositoryDir() + "/";
        if ((resource = StringUtils.strip((String)resource, (String)"/")).regionMatches(true, 0, systemDir, 0, systemDir.length())) {
            String pluginId;
            if ((resource = resource.replaceFirst(systemDir, "")).regionMatches(true, 0, pluginId = environment.getPluginId() + "/", 0, pluginId.length())) {
                return factory.getPluginSystemReader(basePath);
            }
            pluginId = resource.substring(0, resource.indexOf("/"));
            return factory.getOtherPluginSystemReader(pluginId, basePath);
        }
        if (resource.regionMatches(true, 0, repoDir, 0, repoDir.length())) {
            return factory.getPluginRepositoryReader(basePath);
        }
        if (factory.getPluginSystemReader(basePath).fileExists(resource)) {
            return factory.getPluginSystemReader(basePath);
        }
        return factory.getUserContentAccess(basePath);
    }

    public static IReadAccess getSystemReadAccess(String pluginId, String basePath) {
        return Utils.getSystemReadAccess(pluginId, basePath, Utils.getCdeEnvironment());
    }

    public static IReadAccess getSystemReadAccess(String pluginId, String basePath, ICdeEnvironment environment) {
        IContentAccessFactory factory = environment.getContentAccessFactory();
        if (StringUtils.isEmpty((String)pluginId)) {
            return factory.getPluginSystemReader(basePath);
        }
        return factory.getOtherPluginSystemReader(pluginId, basePath);
    }

    public static IRWAccess getSystemRWAccess(String pluginId, String basePath) {
        return Utils.getSystemRWAccess(pluginId, basePath, Utils.getCdeEnvironment());
    }

    public static IRWAccess getSystemRWAccess(String pluginId, String basePath, ICdeEnvironment environment) {
        IContentAccessFactory factory = environment.getContentAccessFactory();
        if (StringUtils.isEmpty((String)pluginId)) {
            return factory.getPluginSystemWriter(basePath);
        }
        return factory.getOtherPluginSystemWriter(pluginId, basePath);
    }

    public static IRWAccess getAppropriateWriteAccess(String resource) {
        return Utils.getAppropriateWriteAccess(resource, null);
    }

    public static IRWAccess getAppropriateWriteAccess(String resource, String basePath) {
        return Utils.getAppropriateWriteAccess(resource, basePath, Utils.getCdeEnvironment());
    }

    public static IRWAccess getAppropriateWriteAccess(String resource, String basePath, ICdeEnvironment environment) {
        if (StringUtils.isEmpty((String)resource)) {
            return null;
        }
        IContentAccessFactory factory = environment.getContentAccessFactory();
        String systemDir = environment.getSystemDir() + "/";
        String repoDir = environment.getPluginRepositoryDir() + "/";
        if ((resource = StringUtils.strip((String)resource, (String)"/")).regionMatches(true, 0, systemDir, 0, systemDir.length())) {
            String pluginId;
            if ((resource = resource.replaceFirst(systemDir, "")).regionMatches(true, 0, pluginId = environment.getPluginId() + "/", 0, pluginId.length())) {
                return factory.getPluginSystemWriter(basePath);
            }
            pluginId = resource.substring(0, resource.indexOf("/"));
            return factory.getOtherPluginSystemWriter(pluginId, basePath);
        }
        if (resource.regionMatches(true, 0, repoDir, 0, repoDir.length())) {
            return factory.getPluginRepositoryWriter(basePath);
        }
        if (factory.getPluginSystemReader(basePath).fileExists(resource)) {
            return factory.getPluginSystemWriter(basePath);
        }
        return factory.getUserContentAccess(basePath);
    }

    public static IBasicFile getFileViaAppropriateReadAccess(String resource) {
        return Utils.getFileViaAppropriateReadAccess(resource, null);
    }

    public static IBasicFile getFileViaAppropriateReadAccess(String resource, String basePath) {
        return Utils.getFileViaAppropriateReadAccess(resource, basePath, Utils.getCdeEnvironment());
    }

    public static IBasicFile getFileViaAppropriateReadAccess(String resource, String basePath, ICdeEnvironment environment) {
        if (StringUtils.isEmpty((String)resource)) {
            return null;
        }
        IContentAccessFactory factory = environment.getContentAccessFactory();
        String systemDir = environment.getSystemDir() + "/";
        String repoDir = environment.getPluginRepositoryDir() + "/";
        if ((resource = StringUtils.strip((String)resource, (String)"/")).regionMatches(true, 0, systemDir, 0, systemDir.length())) {
            String pluginId;
            if ((resource = resource.replaceFirst(systemDir, "")).regionMatches(true, 0, pluginId = environment.getPluginId() + "/", 0, pluginId.length())) {
                resource = resource.replaceFirst(pluginId, "");
                return factory.getPluginSystemReader(basePath).fetchFile(resource);
            }
            pluginId = resource.substring(0, resource.indexOf("/"));
            resource = resource.replaceFirst(pluginId, "");
            return factory.getOtherPluginSystemReader(pluginId, basePath).fetchFile(resource);
        }
        if (resource.regionMatches(true, 0, repoDir, 0, repoDir.length())) {
            resource = resource.replaceFirst(repoDir, "");
            return factory.getPluginRepositoryReader(basePath).fetchFile(resource);
        }
        if (factory.getPluginSystemReader(basePath).fileExists(resource)) {
            return factory.getPluginSystemReader(basePath).fetchFile(resource);
        }
        if (factory.getUserContentAccess(basePath).fileExists(resource)) {
            return factory.getUserContentAccess(basePath).fetchFile(resource);
        }
        return null;
    }

    public static IReadAccess getSystemOrUserReadAccess(String filePath) {
        IUserContentAccess readAccess = null;
        if (Utils.isSystemDashboard(filePath)) {
            readAccess = Utils.getSystemReadAccess(filePath.split("/")[2], null);
        } else if (CdeEnvironment.getUserContentAccess().hasAccess(filePath, FileAccess.EXECUTE)) {
            readAccess = CdeEnvironment.getUserContentAccess();
        }
        return readAccess;
    }

    public static IRWAccess getSystemOrUserRWAccess(String filePath) {
        if (CdeEnvironment.isAdministrator() && Utils.isSystemDashboard(filePath)) {
            return Utils.getSystemRWAccess(filePath.split("/")[2], null);
        }
        return Utils.getUserRWAccess(filePath);
    }

    public static IRWAccess getUserRWAccess(String filePath) {
        if (CdeEnvironment.getUserContentAccess().fileExists(filePath)) {
            if (CdeEnvironment.canCreateContent() && CdeEnvironment.getUserContentAccess().hasAccess(filePath, FileAccess.WRITE)) {
                return CdeEnvironment.getUserContentAccess();
            }
            return null;
        }
        if (CdeEnvironment.canCreateContent() && CdeEnvironment.getUserContentAccess().hasAccess("/" + FilenameUtils.getPath((String)filePath), FileAccess.WRITE)) {
            return CdeEnvironment.getUserContentAccess();
        }
        return null;
    }

    public static boolean isValidJsonArray(String jsonString) {
        try {
            new JSONArray(jsonString);
            return true;
        }
        catch (JSONException e) {
            return false;
        }
    }

    public static String getComponentClassName(String componentType) {
        if (!StringUtils.isNotEmpty((String)componentType)) {
            return componentType;
        }
        StringBuilder sb = new StringBuilder();
        if (!Character.isUpperCase(componentType.charAt(0))) {
            sb.append(Character.toUpperCase(componentType.charAt(0))).append(componentType.substring(1));
        } else {
            sb.append(componentType);
        }
        if (!componentType.endsWith("Component")) {
            sb.append("Component");
        }
        return sb.toString();
    }

    public static ICdeEnvironment getCdeEnvironment() {
        return CdeEngine.getInstance().getEnvironment();
    }

    public static String getURLDecoded(String s) {
        return Utils.getURLDecoded(s, CharsetHelper.getEncoding());
    }

    public static String getURLDecoded(String s, String enc) {
        if (s != null) {
            try {
                return URLDecoder.decode(s, enc != null ? enc : CharsetHelper.getEncoding());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return s;
    }

    public static String readTemplate(DashboardWcdfDescriptor wcdf) throws IOException {
        return Utils.readStyleTemplateOrDefault(wcdf.getStyle());
    }

    public static String readStyleTemplateOrDefault(String styleName) throws IOException {
        if (StringUtils.isNotEmpty((String)styleName)) {
            try {
                return Utils.readStyleTemplate(styleName);
            }
            catch (IOException ex) {
                logger.debug((Object)ex.getMessage());
            }
        }
        return Utils.readStyleTemplate("Clean");
    }

    public static String readStyleTemplate(String styleName) throws IOException {
        String location = CdeEnvironment.getPluginResourceLocationManager().getStyleResourceLocation(styleName);
        if (StringUtils.isEmpty((String)location)) {
            logger.error((Object)MessageFormat.format("Couldn''t find style template file ''{0}'', will fallback to ''{1}''", styleName, "Clean"));
            location = CdeEnvironment.getPluginResourceLocationManager().getStyleResourceLocation("Clean");
        }
        return Utils.readTemplateFile(location);
    }

    public static String readTemplateFile(String templateFile) throws IOException {
        try {
            if (CdeEnvironment.getPluginRepositoryReader().fileExists(templateFile)) {
                return Util.toString((InputStream)CdeEnvironment.getPluginRepositoryReader().getFileInputStream(templateFile));
            }
            if (CdeEnvironment.getPluginSystemReader().fileExists(templateFile)) {
                return Util.toString((InputStream)CdeEnvironment.getPluginSystemReader().getFileInputStream(templateFile));
            }
            if (Utils.getAppropriateReadAccess(templateFile).fileExists(templateFile)) {
                return Util.toString((InputStream)Utils.getAppropriateReadAccess(templateFile).getFileInputStream(templateFile));
            }
            return Util.toString((InputStream)CdeEnvironment.getUserContentAccess().getFileInputStream(templateFile));
        }
        catch (IOException ex) {
            logger.error((Object)MessageFormat.format("Couldn't open template file '{0}'.", templateFile), (Throwable)ex);
            throw ex;
        }
    }

    public static boolean isSystemDashboard(String path) {
        return path.startsWith("/" + CdeEnvironment.getSystemDir() + "/") && (path.endsWith(".wcdf") || path.endsWith(".cdfde"));
    }

    public static String getWcdfReposPath(String path) {
        return CdeEngine.getEnv().getApplicationReposUrl() + Utils.toRepositoryPath(path);
    }

    public static String toRepositoryPath(String path) {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return path.replaceAll("/", ":");
    }

    public static class PathResolutionException
    extends RuntimeException {
        private static final long serialVersionUID = 1838386876452885975L;

        PathResolutionException(String msg) {
            super(msg);
        }
    }
}

