/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.util;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyBag {
    private Hashtable<String, Object> properties = new Hashtable();
    protected static final Log logger = LogFactory.getLog(PropertyBag.class);
    private static final String ID_KEY = "id";
    private static final String CLASSES_KEY = "classes";
    private static final String STYLES_KEY = "styles";

    public void addId(String id) {
        if (id.length() > 0) {
            this.properties.put(ID_KEY, id.replace(' ', '_'));
        }
    }

    public String getId() {
        if (this.properties.containsKey(ID_KEY)) {
            return this.properties.get(ID_KEY).toString();
        }
        return null;
    }

    public void addClass(String _class) {
        if (_class.length() > 0) {
            if (!this.properties.containsKey(CLASSES_KEY)) {
                this.properties.put(CLASSES_KEY, new Vector());
            }
            ((Vector)this.properties.get(CLASSES_KEY)).add(_class);
        }
    }

    public void addStyle(String style, String value) {
        if (value.length() > 0) {
            if (!this.properties.containsKey(STYLES_KEY)) {
                this.properties.put(STYLES_KEY, new Vector());
            }
            ((Vector)this.properties.get(STYLES_KEY)).add(style + ":" + value + ";");
        }
    }

    public void addColClass(String _class, String v) {
        if (v.length() > 0) {
            this.addClass(_class + v);
        }
    }

    public void addColClass(String _class, Boolean v) {
        if (v.booleanValue()) {
            this.addClass(_class);
        }
    }

    public String getPropertiesString() {
        Iterator nodeIterator;
        String str;
        String string = str = this.properties.containsKey(ID_KEY) ? "id='" + (String)this.properties.get(ID_KEY) + "' " : "";
        if (this.properties.containsKey(CLASSES_KEY)) {
            str = str + " class='";
            nodeIterator = ((Vector)this.properties.get(CLASSES_KEY)).iterator();
            while (nodeIterator.hasNext()) {
                str = str + (String)nodeIterator.next() + " ";
            }
            str = str + "' ";
        }
        if (this.properties.containsKey(STYLES_KEY)) {
            str = str + " style='";
            nodeIterator = ((Vector)this.properties.get(STYLES_KEY)).iterator();
            while (nodeIterator.hasNext()) {
                str = str + (String)nodeIterator.next();
            }
            str = str + "' ";
        }
        return str;
    }
}

