/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.util;

import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import pt.webdetails.cpf.repository.api.IBasicFile;
import pt.webdetails.cpf.repository.api.IBasicFileFilter;

public class GenericBasicFileFilter
implements IBasicFileFilter {
    private String fileName;
    private String[] fileExtensions;
    private boolean acceptDirectories;

    public GenericBasicFileFilter(String fileName, String fileExtension) {
        this(fileName, fileExtension, false);
    }

    public GenericBasicFileFilter(String fileName, String fileExtension, boolean acceptDirectories) {
        String[] stringArray;
        if (!StringUtils.isEmpty((String)fileExtension)) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = GenericBasicFileFilter.cleanDot(fileExtension);
        } else {
            stringArray = null;
        }
        this(fileName, stringArray, acceptDirectories);
    }

    public GenericBasicFileFilter(String fileName, String[] fileExtensions) {
        this(fileName, fileExtensions, false);
    }

    public GenericBasicFileFilter(String fileName, String[] fileExtensions, boolean acceptDirectories) {
        this.fileName = fileName;
        this.fileExtensions = fileExtensions;
        this.acceptDirectories = acceptDirectories;
    }

    public boolean accept(IBasicFile file) {
        boolean fileNameOK = false;
        boolean fileExtensionOK = false;
        if (file != null && file.getName() != null) {
            String fileBaseName;
            if (this.acceptDirectories && file.isDirectory()) {
                return true;
            }
            fileNameOK = !StringUtils.isEmpty((String)this.fileName) ? this.fileName.equalsIgnoreCase(fileBaseName = FilenameUtils.getBaseName((String)file.getName())) || !fileBaseName.startsWith(".") && fileBaseName.endsWith("." + this.fileName) : true;
            if (this.fileExtensions != null && this.fileExtensions.length > 0) {
                for (String fileExtension : this.fileExtensions) {
                    if (!StringUtils.isEmpty((String)fileExtension) && (fileExtensionOK = GenericBasicFileFilter.cleanDot(fileExtension).equalsIgnoreCase(GenericBasicFileFilter.cleanDot(file.getExtension())))) break;
                }
            } else {
                fileExtensionOK = true;
            }
        }
        return fileNameOK && fileExtensionOK;
    }

    private static String cleanDot(String extension) {
        return !StringUtils.isEmpty((String)extension) && extension.startsWith(".") ? extension.substring(1) : extension;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String[] getFileExtensions() {
        return this.fileExtensions;
    }

    public void setFileExtensions(String[] fileExtensions) {
        this.fileExtensions = fileExtensions;
    }

    public boolean isAcceptDirectories() {
        return this.acceptDirectories;
    }

    public void setAcceptDirectories(boolean acceptDirectories) {
        this.acceptDirectories = acceptDirectories;
    }
}

