/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.structure;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.json.JSONObject;
import pt.webdetails.cdf.dd.DashboardManager;
import pt.webdetails.cdf.dd.Messages;
import pt.webdetails.cdf.dd.MetaModelManager;
import pt.webdetails.cdf.dd.model.core.UnsupportedThingException;
import pt.webdetails.cdf.dd.model.core.reader.ThingReadException;
import pt.webdetails.cdf.dd.model.core.validation.ValidationException;
import pt.webdetails.cdf.dd.model.core.writer.DefaultThingWriteContext;
import pt.webdetails.cdf.dd.model.core.writer.IThingWriter;
import pt.webdetails.cdf.dd.model.core.writer.IThingWriterFactory;
import pt.webdetails.cdf.dd.model.core.writer.ThingWriteException;
import pt.webdetails.cdf.dd.model.inst.Dashboard;
import pt.webdetails.cdf.dd.model.inst.writer.cggrunjs.CggRunJsDashboardWriteContext;
import pt.webdetails.cdf.dd.model.inst.writer.cggrunjs.CggRunJsThingWriterFactory;
import pt.webdetails.cdf.dd.model.meta.IPropertyTypeSource;
import pt.webdetails.cdf.dd.model.meta.MetaModel;
import pt.webdetails.cdf.dd.model.meta.PropertyType;
import pt.webdetails.cdf.dd.model.meta.WidgetComponentType;
import pt.webdetails.cdf.dd.model.meta.writer.cdexml.XmlThingWriterFactory;
import pt.webdetails.cdf.dd.render.CdaRenderer;
import pt.webdetails.cdf.dd.structure.DashboardStructureException;
import pt.webdetails.cdf.dd.structure.DashboardWcdfDescriptor;
import pt.webdetails.cdf.dd.structure.IDashboardStructure;
import pt.webdetails.cdf.dd.util.CdeEnvironment;
import pt.webdetails.cdf.dd.util.JsonUtils;
import pt.webdetails.cdf.dd.util.Utils;
import pt.webdetails.cpf.repository.api.IRWAccess;
import pt.webdetails.cpf.repository.api.IReadAccess;
import pt.webdetails.cpf.utils.CharsetHelper;

public class DashboardStructure
implements IDashboardStructure {
    private static Log logger = LogFactory.getLog(DashboardStructure.class);
    public static String SYSTEM_PLUGIN_EMPTY_STRUCTURE_FILE_PATH = "resources/empty-structure.json";
    public static String SYSTEM_PLUGIN_EMPTY_WCDF_FILE_PATH = "/system/pentaho-cdf-dd/resources/empty.wcdf";

    @Override
    public void delete(HashMap<String, Object> parameters) throws DashboardStructureException {
        String filePath = (String)parameters.get("file");
        logger.info((Object)("Deleting File:" + filePath));
        if (!Utils.getSystemOrUserRWAccess(filePath).deleteFile(filePath)) {
            throw new DashboardStructureException(Messages.getString("DashboardStructure.ERROR_007_DELETE_FILE_EXCEPTION"));
        }
        logger.info((Object)("Deleted file " + filePath));
    }

    public void deletePreviewFiles(String cdeFilePath) throws DashboardStructureException {
        IRWAccess access = Utils.getSystemOrUserRWAccess(cdeFilePath);
        if (access == null) {
            throw new DashboardStructureException(Messages.getString("XmlStructure.ERROR_011_READ_WRITE_ACCESS_EXCEPTION"));
        }
        access.deleteFile(cdeFilePath.replace(".cdfde", "_tmp.cdfde"));
        access.deleteFile(cdeFilePath.replace(".cdfde", "_tmp.wcdf"));
        access.deleteFile(cdeFilePath.replace(".cdfde", "_tmp.cda"));
    }

    @Override
    public String load(String cdeFilePath) throws Exception {
        String string;
        String wcdfFilePath;
        InputStream cdeFileInput;
        block7: {
            cdeFileInput = null;
            logger.info((Object)("Loading File:" + cdeFilePath));
            wcdfFilePath = null;
            if (StringUtils.isEmpty((String)cdeFilePath)) {
                cdeFileInput = CdeEnvironment.getPluginSystemReader().getFileInputStream(SYSTEM_PLUGIN_EMPTY_STRUCTURE_FILE_PATH);
                wcdfFilePath = SYSTEM_PLUGIN_EMPTY_WCDF_FILE_PATH;
                break block7;
            }
            IReadAccess access = Utils.getSystemOrUserReadAccess(cdeFilePath);
            if (access.fileExists(cdeFilePath)) {
                cdeFileInput = access.getFileInputStream(cdeFilePath);
                wcdfFilePath = cdeFilePath.replace(".cdfde", ".wcdf");
                break block7;
            }
            String msg = "File not found " + cdeFilePath + " in " + access;
            logger.error((Object)msg);
            String string2 = JsonUtils.getJsonResult(false, msg);
            IOUtils.closeQuietly((InputStream)cdeFileInput);
            return string2;
        }
        try {
            JSONObject cdeData = JsonUtils.readJsonFromInputStream(cdeFileInput);
            JSONObject wcdfData = this.loadWcdfDescriptor(wcdfFilePath).toJSON();
            JSONObject result = new JSONObject();
            result.put("wcdf", (Object)wcdfData);
            result.put("data", (Object)cdeData);
            string = JsonUtils.getJsonResult(true, result);
        }
        catch (Exception t) {
            try {
                throw new DashboardStructureException(Messages.getString("DashboardStructure.ERROR_003_LOAD_READING_FILE_EXCEPTION"));
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(cdeFileInput);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)cdeFileInput);
        return string;
    }

    public DashboardWcdfDescriptor loadWcdfDescriptor(String wcdfFilePath) throws IOException {
        DashboardWcdfDescriptor wcdf = DashboardWcdfDescriptor.load(wcdfFilePath);
        return wcdf != null ? wcdf : new DashboardWcdfDescriptor();
    }

    public DashboardWcdfDescriptor loadWcdfDescriptor(Document wcdfDoc) {
        return DashboardWcdfDescriptor.fromXml(wcdfDoc);
    }

    @Override
    public HashMap<String, String> save(HashMap<String, Object> parameters) throws Exception {
        String cdeFilePath = (String)parameters.get("file");
        String cdfdeJsText = (String)parameters.get("cdfstructure");
        return this.save(cdeFilePath, cdfdeJsText);
    }

    public HashMap<String, String> save(String cdeFilePath, String cdfdeJsText) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        logger.info((Object)("Saving File:" + cdeFilePath));
        IRWAccess access = Utils.getSystemOrUserRWAccess(cdeFilePath);
        boolean isPreview = cdeFilePath.contains("_tmp.cdfde");
        if (!access.saveFile(cdeFilePath, (InputStream)new ByteArrayInputStream(DashboardStructure.safeGetEncodedBytes(cdfdeJsText)))) {
            throw new DashboardStructureException(Messages.getString("DashboardStructure.ERROR_006_SAVE_FILE_ADD_FAIL_EXCEPTION"));
        }
        CdaRenderer cdaRenderer = new CdaRenderer(cdfdeJsText);
        String cdaFileName = cdeFilePath.replace(".cdfde", ".cda");
        if (cdaRenderer.isEmpty()) {
            access.deleteFile(cdaFileName);
        } else {
            String cdaText = cdaRenderer.render();
            if (!access.saveFile(cdaFileName, (InputStream)new ByteArrayInputStream(DashboardStructure.safeGetEncodedBytes(cdaText)))) {
                throw new DashboardStructureException(Messages.getString("DashboardStructure.ERROR_006_SAVE_FILE_ADD_FAIL_EXCEPTION"));
            }
        }
        if (!isPreview) {
            String wcdfFilePath = cdeFilePath.replace(".cdfde", ".wcdf");
            DashboardManager.getInstance().invalidateDashboard(wcdfFilePath);
            this.saveCgg(access, wcdfFilePath);
        }
        result.put("cdfde", "true");
        result.put("cda", "true");
        result.put("cgg", "true");
        return result;
    }

    private void saveCgg(IRWAccess access, String cdeRelFilePath) throws ThingReadException, UnsupportedThingException, ThingWriteException {
        String wcdfFilePath = cdeRelFilePath.replace(".cdfde", ".wcdf");
        DashboardManager dashMgr = DashboardManager.getInstance();
        Dashboard dash = dashMgr.getDashboard(wcdfFilePath, false);
        CggRunJsThingWriterFactory cggWriteFactory = new CggRunJsThingWriterFactory();
        IThingWriter cggDashWriter = cggWriteFactory.getWriter(dash);
        CggRunJsDashboardWriteContext cggDashContext = new CggRunJsDashboardWriteContext((IThingWriterFactory)cggWriteFactory, dash);
        cggDashWriter.write(access, cggDashContext, dash);
    }

    public void saveas(HashMap<String, Object> parameters) throws Exception {
        String filePath = (String)parameters.get("file");
        String title = StringUtils.defaultIfEmpty((String)((String)parameters.get("title")), (String)"Dashboard");
        String description = StringUtils.defaultIfEmpty((String)((String)parameters.get("description")), (String)"");
        String cdfdeJsText = (String)parameters.get("cdfstructure");
        this.saveAs(filePath, title, description, cdfdeJsText, false);
    }

    public HashMap<String, String> saveAs(String filePath, String title, String description, String cdfdeJsText) throws Exception {
        return this.saveAs(filePath, title, description, cdfdeJsText, false);
    }

    public HashMap<String, String> saveAs(String filePath, String title, String description, String cdfdeJsText, boolean isPreview) throws Exception {
        if (!CdeEnvironment.getFileHandler().saveDashboardAs(filePath, title, description, cdfdeJsText, isPreview)) {
            throw new DashboardStructureException(Messages.getString("DashboardStructure.ERROR_005_SAVE_PUBLISH_FILE_EXCEPTION"));
        }
        return this.save(filePath.replace(".wcdf", ".cdfde"), cdfdeJsText);
    }

    public void newfile(HashMap<String, Object> parameters) throws Exception {
        InputStream cdfstructure = null;
        try {
            cdfstructure = CdeEnvironment.getPluginSystemReader().getFileInputStream(SYSTEM_PLUGIN_EMPTY_STRUCTURE_FILE_PATH);
            parameters.put("cdfstructure", JsonUtils.readJsonFromInputStream(cdfstructure).toString());
            this.saveas(parameters);
        }
        finally {
            IOUtils.closeQuietly((InputStream)cdfstructure);
        }
    }

    public JSONObject saveSettingsToWcdf(HashMap<String, Object> parameters) throws Exception {
        this.savesettings(parameters);
        JSONObject wcdfData = this.loadWcdfDescriptor((String)parameters.get("file")).toJSON();
        JSONObject result = new JSONObject();
        result.put("wcdf", (Object)wcdfData);
        return result;
    }

    public void savesettings(HashMap<String, Object> parameters) throws DashboardStructureException {
        String wcdfFilePath = (String)parameters.get("file");
        logger.info((Object)("Saving settings file:" + wcdfFilePath));
        DashboardWcdfDescriptor wcdf = null;
        try {
            wcdf = DashboardWcdfDescriptor.load(wcdfFilePath);
        }
        catch (IOException ex) {
            throw new DashboardStructureException(Messages.getString("DashboardStructure.ERROR_009_SAVE_SETTINGS_FILENOTFOUND_EXCEPTION"));
        }
        if (wcdf == null) {
            throw new DashboardStructureException(Messages.getString("DashboardStructure.ERROR_009_SAVE_SETTINGS_FILENOTFOUND_EXCEPTION"));
        }
        wcdf.update(parameters);
        String wcdfText = wcdf.toXml().asXML();
        if (!Utils.getSystemOrUserRWAccess(wcdfFilePath).saveFile(wcdfFilePath, (InputStream)new ByteArrayInputStream(DashboardStructure.safeGetEncodedBytes(wcdfText)))) {
            throw new DashboardStructureException(Messages.getString("DashboardStructure.ERROR_010_SAVE_SETTINGS_FAIL_EXCEPTION"));
        }
        DashboardManager.getInstance().invalidateDashboard(wcdfFilePath);
        if (wcdf.isWidget()) {
            this.publishWidgetComponentXml(wcdf);
        }
    }

    private void publishWidgetComponentXml(DashboardWcdfDescriptor wcdf) {
        String widgetPath = wcdf.getPath().replaceAll(".wcdf$", ".component.xml");
        logger.info((Object)("Saving widget component file:" + widgetPath));
        Document doc = DashboardStructure.createAndWriteWidgetComponentTypeXml(wcdf);
        if (doc == null) {
            return;
        }
        Utils.getSystemOrUserRWAccess(widgetPath).saveFile(widgetPath, (InputStream)new ByteArrayInputStream(DashboardStructure.safeGetEncodedBytes(doc.asXML())));
        try {
            DashboardManager.getInstance().refreshAll(false);
        }
        catch (Exception ex) {
            logger.error((Object)"Error while refreshing the meta data cache", (Throwable)ex);
        }
    }

    private static Document createAndWriteWidgetComponentTypeXml(DashboardWcdfDescriptor wcdf) {
        IThingWriter writer;
        WidgetComponentType widget = DashboardStructure.createWidgetComponentType(wcdf);
        if (widget == null) {
            return null;
        }
        XmlThingWriterFactory factory = new XmlThingWriterFactory();
        DefaultThingWriteContext context = new DefaultThingWriteContext(factory, true);
        try {
            writer = factory.getWriter(widget);
        }
        catch (UnsupportedThingException ex) {
            logger.error((Object)"No writer to write widget component type to XML", (Throwable)ex);
            return null;
        }
        Document doc = DocumentHelper.createDocument();
        try {
            writer.write(doc, context, widget);
        }
        catch (ThingWriteException ex) {
            logger.error((Object)"Failed writing widget component type to XML", (Throwable)ex);
            return null;
        }
        return doc;
    }

    private static WidgetComponentType createWidgetComponentType(DashboardWcdfDescriptor wcdf) {
        WidgetComponentType.Builder builder = new WidgetComponentType.Builder();
        String name = wcdf.getWidgetName();
        builder.setName("widget" + name).setLabel(name).setTooltip(name + " Widget").setCategory("WIDGETS").setCategoryLabel("Widgets").addAttribute("widget", "true").addAttribute("wcdf", wcdf.getPath());
        builder.useProperty(null, "htmlObject");
        for (String paramName : wcdf.getWidgetParameters()) {
            PropertyType.Builder prop = new PropertyType.Builder();
            prop.setName(paramName).setLabel("Parameter " + paramName).setTooltip("What dashboard parameter should map to widget parameter '" + paramName + "'?");
            prop.setInputType("Parameter");
            builder.addProperty(prop);
            builder.useProperty(null, paramName);
        }
        MetaModel model = MetaModelManager.getInstance().getModel();
        IPropertyTypeSource propSource = model.getPropertyTypeSource();
        try {
            return builder.build(propSource);
        }
        catch (ValidationException ex) {
            logger.error((Object)ex);
            return null;
        }
    }

    private static byte[] safeGetEncodedBytes(String text) {
        try {
            return text.getBytes(CharsetHelper.getEncoding());
        }
        catch (UnsupportedEncodingException ex) {
            return null;
        }
    }
}

