/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.render;

import java.util.LinkedList;
import java.util.List;

public class ResourceMap {
    private List<Resource> javascriptResources = new LinkedList<Resource>();
    private List<Resource> cssResources = new LinkedList<Resource>();

    public List<Resource> getJavascriptResources() {
        return this.javascriptResources;
    }

    public List<Resource> getCssResources() {
        return this.cssResources;
    }

    public void add(ResourceKind resourceKind, ResourceType resourceType, String resourceName, String resourcePath, String processedResource) {
        Resource res = new Resource(resourceType, resourceName, resourcePath, processedResource);
        if (resourceKind.equals((Object)ResourceKind.JAVASCRIPT)) {
            this.javascriptResources.add(res);
        } else if (resourceKind.equals((Object)ResourceKind.CSS)) {
            this.cssResources.add(res);
        }
    }

    public class Resource {
        private ResourceType resourceType;
        private String resourceName;
        private String resourcePath;
        private String processedResource;

        public Resource(ResourceType resourceType, String resourceName, String resourcePath, String processedResource) {
            this.setResourceType(resourceType);
            this.setResourceName(resourceName);
            this.setResourcePath(resourcePath);
            this.setProcessedResource(processedResource);
        }

        public ResourceType getResourceType() {
            return this.resourceType;
        }

        public void setResourceType(ResourceType resourceType) {
            this.resourceType = resourceType;
        }

        public String getResourceName() {
            return this.resourceName;
        }

        public void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        public String getResourcePath() {
            return this.resourcePath;
        }

        public void setResourcePath(String resourcePath) {
            this.resourcePath = resourcePath;
        }

        public String getProcessedResource() {
            return this.processedResource;
        }

        public void setProcessedResource(String processedResource) {
            this.processedResource = processedResource;
        }
    }

    public static enum ResourceType {
        FILE("LayoutResourceFile"),
        CODE("LayoutResourceCode");

        private String value;

        private ResourceType(String value) {
            this.value = value;
        }
    }

    public static enum ResourceKind {
        CSS("Css"),
        JAVASCRIPT("Javascript");

        private String value;

        private ResourceKind(String value) {
            this.value = value;
        }
    }
}

