/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.model.meta;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pt.webdetails.cdf.dd.model.core.validation.ValidationException;
import pt.webdetails.cdf.dd.model.meta.ComponentType;
import pt.webdetails.cdf.dd.model.meta.IPropertyTypeSource;
import pt.webdetails.cdf.dd.model.meta.MetaObject;
import pt.webdetails.cdf.dd.model.meta.PropertyType;
import pt.webdetails.cdf.dd.model.meta.validation.DuplicatePropertyTypeError;

public class MetaModel
extends MetaObject {
    private static final Log _logger = LogFactory.getLog(MetaModel.class);
    private final Map<String, ComponentType> _componentTypesByName = new LinkedHashMap<String, ComponentType>();
    private final Map<String, ComponentType> _componentTypesByLegacyName = new HashMap<String, ComponentType>();
    private final Map<String, PropertyType> _propertyTypesByLowerName = new LinkedHashMap<String, PropertyType>();

    protected MetaModel(Builder builder) throws ValidationException {
        super(builder);
        for (PropertyType.Builder propBuilder : builder._propertyTypes) {
            PropertyType prop;
            try {
                prop = propBuilder.build();
            }
            catch (ValidationException ex) {
                _logger.warn((Object)ex.getError());
                continue;
            }
            String key = prop.getName().toLowerCase();
            if (!this._propertyTypesByLowerName.containsKey(key)) {
                this._propertyTypesByLowerName.put(key, prop);
                continue;
            }
            _logger.warn((Object)new DuplicatePropertyTypeError(prop));
        }
        IPropertyTypeSource propSource = this.getPropertyTypeSource();
        for (ComponentType.Builder compBuilder : builder._componentTypes) {
            ComponentType comp;
            try {
                comp = compBuilder.build(propSource);
            }
            catch (ValidationException ex) {
                _logger.warn((Object)ex.getError());
                continue;
            }
            String key = comp.getName();
            ComponentType oldComp = this._componentTypesByName.get(key);
            this._componentTypesByName.put(key, comp);
            for (String legacyName : comp.getLegacyNames()) {
                this._componentTypesByLegacyName.put(legacyName, comp);
            }
            if (oldComp == null) continue;
            _logger.info((Object)("ComponentType '" + oldComp.getLabel() + "' was overriden."));
            ArrayList<String> alternateNames = null;
            for (Map.Entry<String, ComponentType> entry : this._componentTypesByLegacyName.entrySet()) {
                if (entry.getValue() != oldComp) continue;
                if (alternateNames == null) {
                    alternateNames = new ArrayList<String>();
                }
                alternateNames.add(entry.getKey());
            }
            if (alternateNames == null) continue;
            for (String altName : alternateNames) {
                this._componentTypesByLegacyName.put(altName, comp);
            }
        }
    }

    public final IPropertyTypeSource getPropertyTypeSource() {
        final MetaModel me = this;
        return new IPropertyTypeSource(){

            @Override
            public PropertyType getProperty(String name) {
                String lkey = name != null ? name.toLowerCase() : "";
                return (PropertyType)me._propertyTypesByLowerName.get(lkey);
            }
        };
    }

    @Override
    public String getKind() {
        return "ModelType";
    }

    public ComponentType getComponentType(String name) {
        ComponentType comp = this.tryGetComponentType(name);
        if (comp == null) {
            throw new IllegalArgumentException("There is no component type with name '" + name + "'.");
        }
        return comp;
    }

    public ComponentType tryGetComponentType(String name) {
        if (StringUtils.isEmpty((String)name)) {
            throw new IllegalArgumentException("name");
        }
        ComponentType compType = this._componentTypesByName.get(name);
        return compType != null ? compType : this._componentTypesByLegacyName.get(name);
    }

    public PropertyType getPropertyType(String name) {
        PropertyType prop = this.tryGetPropertyType(name);
        if (prop == null) {
            throw new IllegalArgumentException("There is no property type with name '" + name + "'.");
        }
        return prop;
    }

    public PropertyType tryGetPropertyType(String name) {
        if (StringUtils.isEmpty((String)name)) {
            throw new IllegalArgumentException("name");
        }
        return this._propertyTypesByLowerName.get(name.toLowerCase());
    }

    public Iterable<ComponentType> getComponentTypes() {
        return this._componentTypesByName.values();
    }

    public int getComponentTypeCount() {
        return this._componentTypesByName.size();
    }

    public Iterable<PropertyType> getPropertyTypes() {
        return this._propertyTypesByLowerName.values();
    }

    public int getPropertyTypeCount() {
        return this._propertyTypesByLowerName.size();
    }

    public static class Builder
    extends MetaObject.Builder {
        private final List<ComponentType.Builder> _componentTypes = new ArrayList<ComponentType.Builder>();
        private final List<PropertyType.Builder> _propertyTypes = new ArrayList<PropertyType.Builder>();

        public Builder addComponent(ComponentType.Builder comp) {
            if (comp == null) {
                throw new IllegalArgumentException("comp");
            }
            this._componentTypes.add(comp);
            return this;
        }

        public Builder addProperty(PropertyType.Builder prop) {
            if (prop == null) {
                throw new IllegalArgumentException("prop");
            }
            this._propertyTypes.add(prop);
            return this;
        }

        public MetaModel build() throws ValidationException {
            return new MetaModel(this);
        }
    }
}

