/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.model.inst.writer.cggrunjs;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pt.webdetails.cdf.dd.CdeConstants;
import pt.webdetails.cdf.dd.CdeEngine;
import pt.webdetails.cdf.dd.model.core.Thing;
import pt.webdetails.cdf.dd.model.core.UnsupportedThingException;
import pt.webdetails.cdf.dd.model.core.writer.IThingWriteContext;
import pt.webdetails.cdf.dd.model.core.writer.IThingWriter;
import pt.webdetails.cdf.dd.model.core.writer.IThingWriterFactory;
import pt.webdetails.cdf.dd.model.core.writer.ThingWriteException;
import pt.webdetails.cdf.dd.model.core.writer.js.JsWriterAbstract;
import pt.webdetails.cdf.dd.model.inst.Dashboard;
import pt.webdetails.cdf.dd.model.inst.DataSourceComponent;
import pt.webdetails.cdf.dd.model.inst.GenericComponent;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.CdfRunJsDashboardWriteContext;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.CdfRunJsDashboardWriteOptions;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.legacy.CdfRunJsThingWriterFactory;
import pt.webdetails.cdf.dd.model.inst.writer.cggrunjs.CggRunJsComponentWriteContext;
import pt.webdetails.cdf.dd.model.inst.writer.cggrunjs.CggRunJsDashboardWriteContext;
import pt.webdetails.cdf.dd.model.meta.Resource;
import pt.webdetails.cdf.dd.model.meta.VisualComponentType;
import pt.webdetails.cdf.dd.util.Utils;
import pt.webdetails.cpf.repository.api.IUserContentAccess;
import pt.webdetails.cpf.utils.CharsetHelper;

public class CggRunJsGenericComponentWriter
extends JsWriterAbstract
implements IThingWriter {
    private static final Log _logger = LogFactory.getLog(CggRunJsGenericComponentWriter.class);
    private static final String CGG_EXTENSION = ".js";
    private boolean writeScript = true;

    public CggRunJsGenericComponentWriter(boolean canWrite) {
        this.writeScript = canWrite;
    }

    @Override
    public void write(Object output, IThingWriteContext context, Thing t) throws ThingWriteException {
        this.write((IUserContentAccess)output, (CggRunJsDashboardWriteContext)context, (GenericComponent)t);
    }

    public void write(IUserContentAccess access, CggRunJsDashboardWriteContext context, GenericComponent comp) throws ThingWriteException {
        if (!this.canWrite()) {
            return;
        }
        String dashboardFilePath = context.getDashboard().getSourcePath();
        String dashboardFileDir = FilenameUtils.getFullPath((String)dashboardFilePath);
        String dashboardFileName = FilenameUtils.getName((String)dashboardFilePath);
        StringBuilder out = new StringBuilder();
        out.append("lib('cdf-env.js');").append(CdeConstants.Writer.NEWLINE).append(CdeConstants.Writer.NEWLINE);
        this.renderChart(out, context, comp, dashboardFileDir);
        out.append(CdeConstants.Writer.NEWLINE);
        this.renderDatasource(out, context, comp);
        out.append(CdeConstants.Writer.NEWLINE).append(CdeConstants.Writer.NEWLINE);
        String chartName = comp.getName();
        String compVarName = "render_" + chartName;
        out.append("cgg.render(").append(compVarName).append(");").append(CdeConstants.Writer.NEWLINE);
        String chartScript = out.toString();
        this.writeFile(access, chartScript, dashboardFileDir, chartName, dashboardFileName);
        this.writeFile(access, chartScript, dashboardFileDir, chartName, null);
    }

    private void writeFile(IUserContentAccess access, String chartScript, String dashboardFileDir, String chartName, String dashboadFilName) {
        try {
            String prefix = dashboadFilName == null ? "" : dashboadFilName.substring(0, dashboadFilName.lastIndexOf(46)) + '_';
            String fileName = prefix + chartName + CGG_EXTENSION;
            byte[] content = chartScript.getBytes(CharsetHelper.getEncoding());
            if (!access.saveFile(Utils.joinPath(dashboardFileDir, fileName), (InputStream)new ByteArrayInputStream(content))) {
                _logger.error((Object)("Failed to write CGG script file for chart '" + chartName + "'."));
            }
        }
        catch (Exception ex) {
            _logger.error((Object)("Failed to write script file for '" + chartName + "': " + ex.getCause().getMessage()));
        }
    }

    private void renderChart(StringBuilder out, CggRunJsDashboardWriteContext context, GenericComponent comp, String dashDir) throws ThingWriteException {
        IThingWriter compWriter;
        VisualComponentType compType = comp.getMeta();
        for (Resource resource : compType.getResources()) {
            Resource.Type resType = resource.getType();
            switch (resType) {
                case RAW: {
                    out.append(CdeConstants.Writer.NEWLINE).append(resource.getSource()).append(CdeConstants.Writer.NEWLINE);
                    break;
                }
                case SCRIPT: {
                    out.append(CdeConstants.Writer.NEWLINE).append("load('").append(CggRunJsGenericComponentWriter.makeDashRelative(resource.getSource(), dashDir)).append("');").append(CdeConstants.Writer.NEWLINE);
                }
            }
        }
        String srcImpl = compType.getImplementationPath();
        if (StringUtils.isNotEmpty((String)srcImpl)) {
            out.append(CdeConstants.Writer.NEWLINE).append("load('").append(CggRunJsGenericComponentWriter.makeDashRelative(srcImpl, dashDir)).append("');").append(CdeConstants.Writer.NEWLINE);
        }
        CdfRunJsThingWriterFactory writerFactory = new CdfRunJsThingWriterFactory();
        try {
            compWriter = writerFactory.getWriter(comp);
        }
        catch (UnsupportedThingException ex) {
            throw new ThingWriteException("Error while obtaining a writer for rendering the generic component.", ex);
        }
        CdfRunJsDashboardWriteOptions options = new CdfRunJsDashboardWriteOptions(false, false, "", "");
        CdfRunJsDashboardWriteContext writeContext = CdeEngine.getInstance().getEnvironment().getCdfRunJsDashboardWriteContext(writerFactory, "", true, context.getDashboard(), options);
        compWriter.write(out, writeContext, comp);
    }

    private static String makeDashRelative(String path, String dashDir) {
        if (!(dashDir = dashDir.replaceAll("^[/\\\\]*(.*?)[/\\\\]*$", "$1")).isEmpty()) {
            int count = dashDir.split("[/\\\\]").length;
            for (int i = 0; i < count; ++i) {
                path = "../" + path;
            }
        }
        return path;
    }

    private void renderDatasource(StringBuilder out, CggRunJsDashboardWriteContext context, GenericComponent comp) throws ThingWriteException {
        Dashboard dash = context.getDashboard();
        String dataSourceName = comp.tryGetPropertyValue("dataSource", null);
        if (StringUtils.isNotEmpty((String)dataSourceName)) {
            IThingWriter dsWriter;
            DataSourceComponent dsComp = dash.getDataSource(dataSourceName);
            IThingWriterFactory factory = context.getFactory();
            try {
                dsWriter = factory.getWriter(dsComp);
            }
            catch (UnsupportedThingException ex) {
                throw new ThingWriteException(ex);
            }
            CggRunJsComponentWriteContext compContext = new CggRunJsComponentWriteContext(factory, dash, comp);
            dsWriter.write(out, compContext, dsComp);
        }
    }

    public boolean canWrite() {
        return this.writeScript;
    }
}

