/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard;

import java.io.Serializable;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class CdfRunJsDashboardWriteOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final boolean _absolute;
    private final boolean _debug;
    private final boolean _amdModule;
    private final String _absRoot;
    private final String _scheme;
    private final String _aliasPrefix;
    private static final String SPECIAL_CHARACTERS = "\u2014[~!@#$%^&*(){}|,]=+|;'\"?<>`.: ";
    private static final Pattern SPECIAL_CHARACTERS_PATTERN = Pattern.compile("[\\Q\u2014[~!@#$%^&*(){}|,]=+|;'\"?<>`.: \\E]");

    public CdfRunJsDashboardWriteOptions(boolean absolute, boolean debug, String absRoot, String scheme) {
        this("", false, absolute, debug, absRoot, scheme);
    }

    public CdfRunJsDashboardWriteOptions(boolean amdModule, boolean absolute, boolean debug, String absRoot, String scheme) {
        this("", amdModule, absolute, debug, absRoot, scheme);
    }

    public CdfRunJsDashboardWriteOptions(String aliasPrefix, boolean amdModule, boolean absolute, boolean debug, String absRoot, String scheme) {
        this._aliasPrefix = this.escapeAlias(aliasPrefix);
        this._amdModule = amdModule;
        this._absolute = absolute;
        this._debug = debug;
        this._absRoot = absRoot;
        this._scheme = scheme;
    }

    public CdfRunJsDashboardWriteOptions addAliasPrefix(String aliasPrefix) {
        if (StringUtils.isEmpty((String)aliasPrefix)) {
            throw new IllegalArgumentException("aliasPrefix");
        }
        aliasPrefix = (StringUtils.isEmpty((String)this._aliasPrefix) ? "" : this._aliasPrefix) + this.escapeAlias(aliasPrefix);
        return new CdfRunJsDashboardWriteOptions(aliasPrefix, this._amdModule, this._absolute, this._debug, this._absRoot, this._scheme);
    }

    public String getAliasPrefix() {
        return this._aliasPrefix;
    }

    public String getAbsRoot() {
        return this._absRoot;
    }

    public String getSchemedRoot() {
        return (StringUtils.isEmpty((String)this._scheme) ? "" : this._scheme + "://") + this._absRoot;
    }

    public String getScheme() {
        return this._scheme;
    }

    public boolean isAbsolute() {
        return this._absolute;
    }

    public boolean isDebug() {
        return this._debug;
    }

    public boolean isAmdModule() {
        return this._amdModule;
    }

    protected String escapeAlias(String alias) {
        if (alias.contains("@ALIAS@")) {
            String left = alias.substring(0, alias.indexOf("@ALIAS@"));
            String right = alias.substring(alias.indexOf("@ALIAS@") + "@ALIAS@".length(), alias.length());
            return this.toJavaIdentifier(left) + "@ALIAS@" + this.toJavaIdentifier(right);
        }
        return this.toJavaIdentifier(alias);
    }

    protected String toJavaIdentifier(String str) {
        if (StringUtils.isNotEmpty((String)str) && SPECIAL_CHARACTERS_PATTERN.matcher(str).find()) {
            StringBuilder sb = new StringBuilder("id_");
            for (int i = 0; i < str.length(); ++i) {
                if (SPECIAL_CHARACTERS.indexOf(str.charAt(i)) >= 0) {
                    sb.append((int)str.charAt(i));
                    continue;
                }
                sb.append(str.charAt(i));
            }
            return sb.toString();
        }
        return str;
    }
}

