/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.components.amd;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pt.webdetails.cdf.dd.CdeConstants;
import pt.webdetails.cdf.dd.model.core.Thing;
import pt.webdetails.cdf.dd.model.core.writer.IThingWriteContext;
import pt.webdetails.cdf.dd.model.core.writer.IThingWriter;
import pt.webdetails.cdf.dd.model.core.writer.ThingWriteException;
import pt.webdetails.cdf.dd.model.core.writer.js.JsWriterAbstract;
import pt.webdetails.cdf.dd.model.inst.DataSourceComponent;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.CdfRunJsDashboardWriteContext;
import pt.webdetails.cdf.dd.model.meta.DataSourceComponentType;
import pt.webdetails.cdf.dd.model.meta.PropertyType;
import pt.webdetails.cdf.dd.util.JsonUtils;
import pt.webdetails.cpf.Util;
import pt.webdetails.cpf.repository.util.RepositoryHelper;

public class CdfRunJsDataSourceComponentWriter
extends JsWriterAbstract
implements IThingWriter {
    protected static final Log logger = LogFactory.getLog(CdfRunJsDataSourceComponentWriter.class);
    private static final Pattern _replaceParametersPattern = Pattern.compile("\\$\\{[^}]*\\}");
    private static final Pattern _maybeWrappedFunctionValue = Pattern.compile("(\\\"|\\s)*function\\s*\\u0028.*\\u0029{1}\\s*\\u007b.*(\\u007d(\\\"|\\s)*)?|(\\\"|\\s)*function\\s*[a-zA-Z0-9\\u002d\\u005f]+\\u0028.*\\u0029{1}\\s*\\u007b.*(\\u007d(\\\"|\\s)*)?");

    @Override
    public void write(Object output, IThingWriteContext context, Thing t) throws ThingWriteException {
        this.write((StringBuilder)output, (CdfRunJsDashboardWriteContext)context, (DataSourceComponent)t);
    }

    public void write(StringBuilder out, CdfRunJsDashboardWriteContext context, DataSourceComponent comp) throws ThingWriteException {
        out.append("{").append(CdeConstants.Writer.NEWLINE);
        String dataAccessId = comp.tryGetPropertyValue("dataAccessId", null);
        if (dataAccessId != null) {
            this.renderCdaDatasource(out, context, comp, dataAccessId);
        } else {
            String metaType = comp.getMeta().tryGetAttributeValue("", "");
            if (StringUtils.isEmpty((String)metaType)) {
                this.renderDatasource(out, comp);
            } else if (metaType.equals("CDA")) {
                this.renderBuiltinCdaDatasource(out, context, comp);
            } else if (metaType.equals("CPK")) {
                this.renderCpkDatasource(out, comp);
            } else if (metaType.equals("SOLR")) {
                this.renderSolrDataSource(out, comp);
            } else {
                throw new ThingWriteException("Cannot render a data source property of meta type '" + metaType + "'.");
            }
        }
        out.append(CdeConstants.Writer.NEWLINE).append("  ").append("}");
    }

    private static String buildJsStringValue(String value) {
        return JsonUtils.toJsString(CdfRunJsDataSourceComponentWriter.replaceParameters(value == null ? "" : value));
    }

    private static String replaceParameters(String value) {
        if (value != null) {
            Matcher matcher = _replaceParametersPattern.matcher(value);
            while (matcher.find()) {
                String parameter = matcher.group();
                value = value.replace(matcher.group(), "Utils.ev(" + parameter.substring(2, parameter.length() - 1) + ")");
            }
        }
        return value;
    }

    private void renderSolrDataSource(StringBuilder out, DataSourceComponent dataSourceComp) {
        String queryType = "solr";
        CdfRunJsDataSourceComponentWriter.addFirstJsProperty(out, "queryType", JsonUtils.toJsString(queryType), "    ");
        dataSourceComp.getPropertyBindings().forEach(binding -> {
            String name = binding.getAlias();
            String value = binding.getValue();
            PropertyType.ValueType valueType = binding.getProperty().getValueType();
            if (PropertyType.ValueType.STRING.equals((Object)valueType)) {
                value = JsonUtils.toJsString(value);
            }
            CdfRunJsDataSourceComponentWriter.addJsProperty(out, name, value, "    ");
        });
    }

    private void renderCdaDatasource(StringBuilder out, CdfRunJsDashboardWriteContext context, DataSourceComponent dataSourceComp, String dataAccessId) {
        this.renderCdaDatasource(out, dataSourceComp, dataAccessId, context.getDashboard().getSourcePath());
    }

    private void renderCdaDatasource(StringBuilder out, DataSourceComponent dataSourceComp, String dataAccessId, String dashPath) {
        String cdaPath;
        CdfRunJsDataSourceComponentWriter.addFirstJsProperty(out, "dataAccessId", CdfRunJsDataSourceComponentWriter.buildJsStringValue(dataAccessId), "    ");
        String dataSourceType = dataSourceComp.tryGetAttributeValue("datype", null);
        CdfRunJsDataSourceComponentWriter.addJsProperty(out, "pushEnabled", String.valueOf("streaming".equals(dataSourceType)), "    ");
        String outputIndexId = dataSourceComp.tryGetPropertyValue("outputIndexId", null);
        if (outputIndexId != null) {
            CdfRunJsDataSourceComponentWriter.addJsProperty(out, "outputIndexId", CdfRunJsDataSourceComponentWriter.buildJsStringValue(outputIndexId), "    ");
        }
        if ((cdaPath = dataSourceComp.tryGetPropertyValue("cdaPath", null)) != null) {
            if (!cdaPath.startsWith("/")) {
                dashPath = FilenameUtils.getPath((String)dashPath);
                cdaPath = RepositoryHelper.normalize((String)Util.joinPath((String[])new String[]{dashPath, cdaPath}));
            }
            CdfRunJsDataSourceComponentWriter.addJsProperty(out, "path", CdfRunJsDataSourceComponentWriter.buildJsStringValue(cdaPath), "    ");
        } else {
            String solution = dataSourceComp.tryGetPropertyValue("solution", "");
            CdfRunJsDataSourceComponentWriter.addJsProperty(out, "solution", CdfRunJsDataSourceComponentWriter.buildJsStringValue(solution), "    ");
            String path = dataSourceComp.tryGetPropertyValue("path", "");
            CdfRunJsDataSourceComponentWriter.addJsProperty(out, "path", CdfRunJsDataSourceComponentWriter.buildJsStringValue(path), "    ");
            String file = dataSourceComp.tryGetPropertyValue("file", "");
            CdfRunJsDataSourceComponentWriter.addJsProperty(out, "file", CdfRunJsDataSourceComponentWriter.buildJsStringValue(file), "    ");
        }
    }

    private void renderBuiltinCdaDatasource(StringBuilder out, CdfRunJsDashboardWriteContext context, DataSourceComponent dataSourceComp) {
        String dsName = dataSourceComp.getName();
        CdfRunJsDataSourceComponentWriter.addFirstJsProperty(out, "dataAccessId", CdfRunJsDataSourceComponentWriter.buildJsStringValue(dsName), "    ");
        String dataSourceType = dataSourceComp.tryGetAttributeValue("datype", null);
        CdfRunJsDataSourceComponentWriter.addJsProperty(out, "pushEnabled", String.valueOf("streaming".equals(dataSourceType)), "    ");
        String cdeFilePath = context.getDashboard().getSourcePath();
        if (cdeFilePath != null) {
            if (cdeFilePath.contains(".wcdf")) {
                logger.error((Object)"renderBuiltinCdaDatasource: [fileName] receiving a .wcdf when a .cdfde was expected!");
                cdeFilePath = cdeFilePath.replace(".wcdf", ".cda");
            } else {
                cdeFilePath = cdeFilePath.replace(".cdfde", ".cda");
            }
        } else {
            logger.warn((Object)"Error reading dashboard source path");
        }
        CdfRunJsDataSourceComponentWriter.addJsProperty(out, "path", CdfRunJsDataSourceComponentWriter.buildJsStringValue(cdeFilePath), "    ");
    }

    private void renderCpkDatasource(StringBuilder out, DataSourceComponent dataSourceComp) {
        DataSourceComponentType compType = dataSourceComp.getMeta();
        String endpoint = compType.tryGetAttributeValue("endpoint", "");
        CdfRunJsDataSourceComponentWriter.addFirstJsProperty(out, "endpoint", CdfRunJsDataSourceComponentWriter.buildJsStringValue(endpoint), "    ");
        String pluginID = compType.tryGetAttributeValue("pluginId", "");
        CdfRunJsDataSourceComponentWriter.addJsProperty(out, "pluginId", CdfRunJsDataSourceComponentWriter.buildJsStringValue(pluginID), "    ");
        String outputStepName = dataSourceComp.tryGetPropertyValue("stepName", "OUTPUT");
        CdfRunJsDataSourceComponentWriter.addJsProperty(out, "stepName", CdfRunJsDataSourceComponentWriter.buildJsStringValue(outputStepName), "    ");
        String outputFormat = dataSourceComp.tryGetPropertyValue("kettleOutput", "Infered");
        CdfRunJsDataSourceComponentWriter.addJsProperty(out, "kettleOutput", CdfRunJsDataSourceComponentWriter.buildJsStringValue(outputFormat), "    ");
        String queryType = "cpk";
        CdfRunJsDataSourceComponentWriter.addJsProperty(out, "queryType", CdfRunJsDataSourceComponentWriter.buildJsStringValue(queryType), "    ");
    }

    private void renderDatasource(StringBuilder out, DataSourceComponent dataSourceComp) {
        String queryType;
        String jndi = dataSourceComp.tryGetPropertyValue("jndi", "");
        CdfRunJsDataSourceComponentWriter.addFirstJsProperty(out, "jndi", CdfRunJsDataSourceComponentWriter.buildJsStringValue(jndi), "    ");
        String catalog = dataSourceComp.tryGetPropertyValue("catalog", "");
        CdfRunJsDataSourceComponentWriter.addJsProperty(out, "catalog", CdfRunJsDataSourceComponentWriter.buildJsStringValue(catalog), "    ");
        String cube = dataSourceComp.tryGetPropertyValue("cube", "");
        CdfRunJsDataSourceComponentWriter.addJsProperty(out, "cube", CdfRunJsDataSourceComponentWriter.buildJsStringValue(cube), "    ");
        String query = dataSourceComp.tryGetPropertyValue("mdxquery", null);
        if (query != null) {
            queryType = "mdx";
            query = CdfRunJsDataSourceComponentWriter.replaceParameters(this.writeFunction(query));
        } else {
            queryType = "sql";
            query = CdfRunJsDataSourceComponentWriter.buildJsStringValue(dataSourceComp.tryGetPropertyValue("sqlquery", null));
        }
        CdfRunJsDataSourceComponentWriter.addJsProperty(out, "query", query, "    ");
        CdfRunJsDataSourceComponentWriter.addJsProperty(out, "queryType", CdfRunJsDataSourceComponentWriter.buildJsStringValue(queryType), "    ");
    }

    private String writeFunction(String canonicalValue) {
        Matcher matcher = _maybeWrappedFunctionValue.matcher(canonicalValue);
        if (matcher.find()) {
            return canonicalValue;
        }
        canonicalValue = canonicalValue.replace("\n", " ").replace("\r", " ");
        canonicalValue = canonicalValue.replace("\"", "\\\"");
        canonicalValue = canonicalValue.replaceAll("(\\$\\{[^}]*\\})", "\"+ $1 + \"");
        return "function() { return \"" + canonicalValue + "\"; }";
    }
}

