/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.model.inst.reader.cdfdejs;

import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pt.webdetails.cdf.dd.model.core.UnsupportedThingException;
import pt.webdetails.cdf.dd.model.core.reader.IThingReader;
import pt.webdetails.cdf.dd.model.core.reader.IThingReaderFactory;
import pt.webdetails.cdf.dd.model.core.validation.ValidationException;
import pt.webdetails.cdf.dd.model.inst.CodeComponent;
import pt.webdetails.cdf.dd.model.inst.CustomComponent;
import pt.webdetails.cdf.dd.model.inst.DataSourceComponent;
import pt.webdetails.cdf.dd.model.inst.LayoutComponent;
import pt.webdetails.cdf.dd.model.inst.ParameterComponent;
import pt.webdetails.cdf.dd.model.inst.PrimitiveComponent;
import pt.webdetails.cdf.dd.model.inst.WidgetComponent;
import pt.webdetails.cdf.dd.model.inst.reader.cdfdejs.CdfdeJsAdhocComponentReader;
import pt.webdetails.cdf.dd.model.inst.reader.cdfdejs.CdfdeJsDashboardReader;
import pt.webdetails.cdf.dd.model.inst.reader.cdfdejs.CdfdeJsLayoutComponentReader;
import pt.webdetails.cdf.dd.model.meta.CodeComponentType;
import pt.webdetails.cdf.dd.model.meta.ComponentType;
import pt.webdetails.cdf.dd.model.meta.CustomComponentType;
import pt.webdetails.cdf.dd.model.meta.DataSourceComponentType;
import pt.webdetails.cdf.dd.model.meta.GenericComponentType;
import pt.webdetails.cdf.dd.model.meta.LayoutComponentType;
import pt.webdetails.cdf.dd.model.meta.MetaModel;
import pt.webdetails.cdf.dd.model.meta.ParameterComponentType;
import pt.webdetails.cdf.dd.model.meta.PrimitiveComponentType;
import pt.webdetails.cdf.dd.model.meta.VisualComponentType;
import pt.webdetails.cdf.dd.model.meta.WidgetComponentType;

public class CdfdeJsThingReaderFactory
implements IThingReaderFactory {
    private static final Log logger = LogFactory.getLog(CdfdeJsThingReaderFactory.class);
    private static final Pattern _modelIdToNamePattern = Pattern.compile("^(?:Components|Layout|Datasources)?(.*?)(?:Model)?$");
    private final MetaModel _metaModel;

    public CdfdeJsThingReaderFactory(MetaModel metaModel) {
        if (metaModel == null) {
            throw new IllegalArgumentException("metaModel");
        }
        this._metaModel = metaModel;
    }

    @Override
    public IThingReader getReader(String kind, String className, String name) throws UnsupportedThingException {
        if ("Dashboard".equals(kind)) {
            return new CdfdeJsDashboardReader();
        }
        if ("Component".equals(kind)) {
            ComponentType compType;
            if (StringUtils.isEmpty((String)className)) {
                throw new IllegalArgumentException("className");
            }
            if (className.equals("layout")) {
                try {
                    return new CdfdeJsLayoutComponentReader(new LayoutComponentType.Builder().build(this._metaModel.getPropertyTypeSource()));
                }
                catch (ValidationException ex) {
                    logger.error((Object)"Error building dashboard layout.", (Throwable)ex);
                    return null;
                }
            }
            String compTypeName = _modelIdToNamePattern.matcher(className).replaceFirst("$1");
            try {
                compType = this._metaModel.getComponentType(compTypeName);
                assert (compType != null);
            }
            catch (IllegalArgumentException ex) {
                throw new UnsupportedThingException(kind, className);
            }
            Class<?> compTypeClass = compType.getClass();
            Class compBuilderClass = null;
            if (VisualComponentType.class.isAssignableFrom(compTypeClass)) {
                if (GenericComponentType.class.isAssignableFrom(compTypeClass)) {
                    if (PrimitiveComponentType.class.isAssignableFrom(compTypeClass)) {
                        compBuilderClass = PrimitiveComponent.Builder.class;
                    } else if (CustomComponentType.class.isAssignableFrom(compTypeClass)) {
                        compBuilderClass = CustomComponent.Builder.class;
                    } else if (WidgetComponentType.class.isAssignableFrom(compTypeClass)) {
                        compBuilderClass = WidgetComponent.Builder.class;
                    }
                } else if (LayoutComponentType.class.isAssignableFrom(compTypeClass)) {
                    compBuilderClass = LayoutComponent.Builder.class;
                }
            } else if (DataSourceComponentType.class.isAssignableFrom(compTypeClass)) {
                compBuilderClass = DataSourceComponent.Builder.class;
            } else if (ParameterComponentType.class.isAssignableFrom(compTypeClass)) {
                compBuilderClass = ParameterComponent.Builder.class;
            } else if (CodeComponentType.class.isAssignableFrom(compTypeClass)) {
                compBuilderClass = CodeComponent.Builder.class;
            }
            if (compBuilderClass == null) {
                throw new UnsupportedThingException(kind, className);
            }
            return new CdfdeJsAdhocComponentReader<DataSourceComponent.Builder>(compBuilderClass, compType);
        }
        throw new UnsupportedThingException(kind, className);
    }
}

