/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.model.core.writer.js;

import org.apache.commons.lang.StringUtils;
import pt.webdetails.cdf.dd.CdeConstants;

public abstract class JsWriterAbstract {
    protected static void addCommaAndLineSep(StringBuilder out) {
        out.append(",").append(CdeConstants.Writer.NEWLINE);
    }

    protected static void addVar(StringBuilder out, String name, String value) {
        out.append("var ");
        JsWriterAbstract.addAssignmentWithOr(out, name, value);
    }

    protected static void addAssignmentWithOr(StringBuilder out, String name, String value) {
        out.append(name).append(" = ").append(name).append(" || ").append(value).append(";").append(CdeConstants.Writer.NEWLINE);
    }

    protected static void addAssignment(StringBuilder out, String name, String value) {
        out.append(name).append(" = ").append(value).append(";").append(CdeConstants.Writer.NEWLINE);
    }

    protected static void addFirstJsProperty(StringBuilder out, String name, String jsValue, String indent) {
        JsWriterAbstract.addJsProperty(out, name, jsValue, indent, true);
    }

    protected static void addJsProperty(StringBuilder out, String name, String jsValue, String indent) {
        JsWriterAbstract.addJsProperty(out, name, jsValue, indent, false);
    }

    protected static void addJsProperty(StringBuilder out, String name, String jsValue, String indent, boolean isFirst) {
        if (!isFirst) {
            JsWriterAbstract.addCommaAndLineSep(out);
        }
        if (StringUtils.isNotEmpty((String)indent)) {
            out.append(indent);
        }
        out.append(name).append(": ").append(jsValue);
    }

    protected static String wrapJsScriptTags(String code) {
        StringBuilder out = new StringBuilder();
        JsWriterAbstract.wrapJsScriptTags(out, code);
        return out.toString();
    }

    protected static void wrapJsScriptTags(StringBuilder out, String code) {
        out.append(CdeConstants.Writer.NEWLINE).append("<script language=\"javascript\" type=\"text/javascript\">").append(CdeConstants.Writer.NEWLINE).append(code).append(CdeConstants.Writer.NEWLINE).append("</script>").append(CdeConstants.Writer.NEWLINE);
    }
}

