/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import pt.webdetails.cdf.dd.datasources.IDataSourceManager;
import pt.webdetails.cdf.dd.datasources.IDataSourceProvider;
import pt.webdetails.cdf.dd.model.core.UnsupportedThingException;
import pt.webdetails.cdf.dd.model.core.reader.ThingReadException;
import pt.webdetails.cdf.dd.model.core.validation.ValidationException;
import pt.webdetails.cdf.dd.model.core.writer.DefaultThingWriteContext;
import pt.webdetails.cdf.dd.model.core.writer.IThingWriter;
import pt.webdetails.cdf.dd.model.core.writer.ThingWriteException;
import pt.webdetails.cdf.dd.model.meta.MetaModel;
import pt.webdetails.cdf.dd.model.meta.reader.cdexml.fs.XmlFsPluginModelReader;
import pt.webdetails.cdf.dd.model.meta.reader.cdexml.fs.XmlFsPluginThingReaderFactory;
import pt.webdetails.cdf.dd.model.meta.reader.datasources.DataSourcesModelReader;
import pt.webdetails.cdf.dd.model.meta.reader.datasources.DataSourcesObjectReaderFactory;
import pt.webdetails.cdf.dd.model.meta.writer.cderunjs.legacy.CdeRunJsThingWriterFactory;
import pt.webdetails.cdf.dd.util.CdeEnvironment;
import pt.webdetails.cdf.dd.util.Utils;

public final class MetaModelManager {
    protected static final Log logger = LogFactory.getLog(MetaModelManager.class);
    private static MetaModelManager instance;
    private final Object lock = new Object();
    private MetaModel model;
    private String jsDefinition;
    private String amdJsDefinition;

    public static synchronized MetaModelManager getInstance() {
        if (instance == null) {
            instance = new MetaModelManager();
        }
        return instance;
    }

    private MetaModelManager() {
        long start = System.currentTimeMillis();
        logger.info((Object)"CDE Starting Load MetaModelManager");
        this.model = this.readModel();
        logger.info((Object)("CDE Finished Load MetaModelManager: " + Utils.ellapsedSeconds(start) + "s"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetaModel getModel() {
        Object object = this.lock;
        synchronized (object) {
            return this.model;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJsDefinition() {
        Object object = this.lock;
        synchronized (object) {
            if (this.jsDefinition == null && this.model != null) {
                this.jsDefinition = this.writeJsDefinition(this.model);
            }
            return this.jsDefinition;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAmdJsDefinition() {
        Object object = this.lock;
        synchronized (object) {
            if (this.amdJsDefinition == null && this.model != null) {
                this.amdJsDefinition = this.writeAmdJsDefinition(this.model);
            }
            return this.amdJsDefinition;
        }
    }

    public void refresh() {
        this.refresh(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(boolean refreshDatasources) {
        MetaModel model;
        long start = System.currentTimeMillis();
        logger.info((Object)"CDE Starting Reload MetaModelManager");
        if (refreshDatasources) {
            CdeEnvironment.getDataSourceManager().refresh();
        }
        if ((model = this.readModel()) != null) {
            Object object = this.lock;
            synchronized (object) {
                this.model = model;
                this.jsDefinition = null;
                this.amdJsDefinition = null;
            }
        }
        logger.info((Object)("CDE Finished Reload MetaModelManager: " + Utils.ellapsedSeconds(start) + "s"));
    }

    private MetaModel readModel() {
        XmlFsPluginThingReaderFactory factory = new XmlFsPluginThingReaderFactory(CdeEnvironment.getContentAccessFactory());
        XmlFsPluginModelReader metaModelReader = factory.getMetaModelReader();
        try {
            MetaModel.Builder builder = metaModelReader.read(factory);
            this.readDataSourceComponents(builder);
            return builder.build();
        }
        catch (ThingReadException ex) {
            logger.error((Object)"Error while reading model from file system.", (Throwable)ex);
        }
        catch (ValidationException ex) {
            logger.error((Object)"Error while building model.", (Throwable)ex);
        }
        return null;
    }

    private void readDataSourceComponents(MetaModel.Builder builder) {
        DataSourcesObjectReaderFactory dsFactory = new DataSourcesObjectReaderFactory();
        DataSourcesModelReader dsModelReader = dsFactory.getModelReader();
        IDataSourceManager dataSourceManager = CdeEnvironment.getDataSourceManager();
        for (IDataSourceProvider dsProvider : dataSourceManager.getProviders()) {
            String providerId = dsProvider.getId();
            JSONObject jsDef = dataSourceManager.getProviderJsDefinition(providerId);
            try {
                dsModelReader.read(builder, jsDef, providerId);
            }
            catch (ThingReadException ex) {
                logger.error((Object)("Error while reading model from data source definitions in '" + providerId + "'."), (Throwable)ex);
            }
        }
    }

    private String writeJsDefinition(MetaModel model) {
        IThingWriter writer;
        CdeRunJsThingWriterFactory factory = new CdeRunJsThingWriterFactory();
        try {
            writer = factory.getWriter(model);
        }
        catch (UnsupportedThingException ex) {
            logger.error((Object)"Error while obtaining the model writer from the factory.", (Throwable)ex);
            return null;
        }
        StringBuilder out = new StringBuilder();
        DefaultThingWriteContext context = new DefaultThingWriteContext(factory, false);
        try {
            writer.write(out, context, model);
        }
        catch (ThingWriteException ex) {
            logger.error((Object)"Error while writing the model to JS.", (Throwable)ex);
            return null;
        }
        return out.toString();
    }

    private String writeAmdJsDefinition(MetaModel model) {
        IThingWriter writer;
        pt.webdetails.cdf.dd.model.meta.writer.cderunjs.amd.CdeRunJsThingWriterFactory factory = new pt.webdetails.cdf.dd.model.meta.writer.cderunjs.amd.CdeRunJsThingWriterFactory();
        try {
            writer = factory.getWriter(model);
        }
        catch (UnsupportedThingException ex) {
            logger.error((Object)"Error while obtaining the model writer from the factory.", (Throwable)ex);
            return null;
        }
        StringBuilder out = new StringBuilder();
        DefaultThingWriteContext context = new DefaultThingWriteContext(factory, false);
        try {
            writer.write(out, context, model);
        }
        catch (ThingWriteException ex) {
            logger.error((Object)"Error while writing the model to JS.", (Throwable)ex);
            return null;
        }
        return out.toString();
    }
}

