/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.lib.FieldMapProcessor;
import com.cloudera.sqoop.lib.SqoopRecord;
import com.cloudera.sqoop.manager.ConnManager;
import com.cloudera.sqoop.manager.ImportJobContext;
import com.cloudera.sqoop.mapreduce.DataDrivenImportJob;
import com.cloudera.sqoop.util.ImportException;
import java.io.IOException;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.sqoop.accumulo.AccumuloMutationProcessor;
import org.apache.sqoop.accumulo.AccumuloUtil;
import org.apache.sqoop.mapreduce.AccumuloImportMapper;
import org.apache.sqoop.mapreduce.DelegatingOutputFormat;

public class AccumuloImportJob
extends DataDrivenImportJob {
    public static final Log LOG = LogFactory.getLog((String)AccumuloImportJob.class.getName());
    protected static SqoopOptions opts;

    public AccumuloImportJob(SqoopOptions opts, ImportJobContext importContext) {
        super(opts, importContext.getInputFormat(), importContext);
        AccumuloImportJob.opts = opts;
    }

    @Override
    protected void configureMapper(Job job, String tableName, String tableClassName) throws IOException {
        job.setOutputKeyClass(SqoopRecord.class);
        job.setOutputValueClass(NullWritable.class);
        job.setMapperClass(this.getMapperClass());
    }

    @Override
    protected Class<? extends Mapper> getMapperClass() {
        return AccumuloImportMapper.class;
    }

    @Override
    protected Class<? extends OutputFormat> getOutputFormatClass() throws ClassNotFoundException {
        return DelegatingOutputFormat.class;
    }

    @Override
    protected void configureOutputFormat(Job job, String tableName, String tableClassName) throws ClassNotFoundException, IOException {
        job.setOutputFormatClass(this.getOutputFormatClass());
        Configuration conf = job.getConfiguration();
        conf.setClass("sqoop.output.delegate.field.map.processor.class", AccumuloMutationProcessor.class, FieldMapProcessor.class);
        conf.set("sqoop.accumulo.zookeeper.hostnames", this.options.getAccumuloZookeepers());
        conf.set("sqoop.accumulo.instance.name", this.options.getAccumuloInstance());
        conf.set("sqoop.accumulo.user.name", this.options.getAccumuloUser());
        String pw = this.options.getAccumuloPassword();
        if (null == pw) {
            pw = "";
        }
        conf.set("sqoop.accumulo.password", pw);
        conf.set("sqoop.accumulo.insert.table", this.options.getAccumuloTable());
        conf.set("sqoop.accumulo.insert.column.family", this.options.getAccumuloColFamily());
        conf.setLong("sqoop.accumulo.batch.size", this.options.getAccumuloBatchSize());
        conf.setLong("sqoop.accumulo.max.latency", this.options.getAccumuloMaxLatency());
        String rowKeyCol = this.options.getAccumuloRowKeyColumn();
        if (null == rowKeyCol) {
            rowKeyCol = this.options.getSplitByCol();
        }
        if (null == rowKeyCol) {
            ConnManager manager = this.getContext().getConnManager();
            rowKeyCol = manager.getPrimaryKey(tableName);
        }
        if (null == rowKeyCol) {
            throw new IOException("Could not determine the row-key column. Use --accumulo-row-key to specify the input column that names each row.");
        }
        conf.set("sqoop.accumulo.insert.row.key.column", rowKeyCol);
    }

    @Override
    protected void jobSetup(Job job) throws IOException, ImportException {
        block8: {
            Configuration conf = job.getConfiguration();
            String tableName = conf.get("sqoop.accumulo.insert.table");
            String familyName = conf.get("sqoop.accumulo.insert.column.family");
            String zookeepers = conf.get("sqoop.accumulo.zookeeper.hostnames");
            String instance = conf.get("sqoop.accumulo.instance.name");
            String user = conf.get("sqoop.accumulo.user.name");
            if (null == tableName) {
                throw new ImportException("Import to Accumulo error: Table name not specified");
            }
            if (null == familyName) {
                throw new ImportException("Import to Accumulo error: Column family not specified");
            }
            try {
                AccumuloUtil.addJars(job, opts);
                ZooKeeperInstance inst = new ZooKeeperInstance(instance, zookeepers);
                String password = conf.get("sqoop.accumulo.password");
                Connector conn = inst.getConnector(user, (AuthenticationToken)new PasswordToken((CharSequence)password));
                if (conn.tableOperations().exists(tableName)) break block8;
                if (this.options.getCreateAccumuloTable()) {
                    LOG.info((Object)("Table " + tableName + " doesn't exist, creating."));
                    try {
                        conn.tableOperations().create(tableName);
                    }
                    catch (TableExistsException e) {
                        LOG.info((Object)("Table " + tableName + " created by another process."));
                    }
                    break block8;
                }
                throw new ImportException("Table " + tableName + " does not exist, and --accumulo-create-table not specified.");
            }
            catch (AccumuloException e) {
                throw new ImportException(e);
            }
            catch (AccumuloSecurityException e) {
                throw new ImportException(e);
            }
        }
        super.jobSetup(job);
    }
}

