/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.binding;

import org.pentaho.ui.xul.binding.BindingException;

public class InlineBindingExpression {
    private String xulCompAttr;
    private String modelAttr;
    private static final String USAGE = "Usage: Inline binding expression syntax: \npen:binding=\"modelProperty\" \nor pen:binding=\"xulComponentProperty=modelProperty\"";
    public static final String DEFAULT_XUL_COMP_ATTR = "label";

    public InlineBindingExpression(String exp) {
        String[] attributes = exp.trim().split("=");
        if (attributes.length < 1 || attributes.length > 2) {
            throw new BindingException("Inline binding expression [" + exp + "] contains an invalid number of attributes.\n" + USAGE);
        }
        switch (attributes.length) {
            case 1: {
                this.xulCompAttr = DEFAULT_XUL_COMP_ATTR;
                this.modelAttr = attributes[0].trim();
                break;
            }
            case 2: {
                this.xulCompAttr = attributes[0].trim();
                this.modelAttr = attributes[1].trim();
            }
        }
    }

    public String getXulCompAttr() {
        return this.xulCompAttr;
    }

    public void setXulCompAttr(String xulCompAttr) {
        this.xulCompAttr = xulCompAttr;
    }

    public String getModelAttr() {
        return this.modelAttr;
    }

    public void setModelAttr(String modelAttr) {
        this.modelAttr = modelAttr;
    }
}

