/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.wf.WorkflowXCommand;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.WorkflowActionGetJPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.ParamChecker;

public class WorkflowActionInfoXCommand
extends WorkflowXCommand<WorkflowActionBean> {
    private String id;

    public WorkflowActionInfoXCommand(String id) {
        super("action.info", "action.info", 1);
        this.id = ParamChecker.notEmpty(id, "id");
        this.LOG.debug("Command for workflow action " + id);
    }

    @Override
    protected WorkflowActionBean execute() throws CommandException {
        JPAService jpaService = Services.get().get(JPAService.class);
        if (jpaService != null) {
            WorkflowActionBean action;
            try {
                action = jpaService.execute(new WorkflowActionGetJPAExecutor(this.id));
            }
            catch (JPAExecutorException ex) {
                throw new CommandException(ex);
            }
            return action;
        }
        this.LOG.error((Object)ErrorCode.E0610);
        return null;
    }

    @Override
    protected String getEntityKey() {
        return null;
    }

    @Override
    protected void loadState() {
    }

    @Override
    protected void verifyPrecondition() throws CommandException {
    }

    @Override
    protected boolean isLockRequired() {
        return false;
    }
}

