/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.ActionExecutorException;
import org.apache.oozie.client.SLAEvent;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.wf.ActionCommand;
import org.apache.oozie.command.wf.NotificationCommand;
import org.apache.oozie.service.ActionService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.UUIDService;
import org.apache.oozie.store.StoreException;
import org.apache.oozie.store.WorkflowStore;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.db.SLADbOperations;

public class ActionKillCommand
extends ActionCommand<Void> {
    private String id;
    private String jobId;

    public ActionKillCommand(String id, String type) {
        super("action.kill", type, 0);
        this.id = id;
    }

    @Override
    protected Void call(WorkflowStore store) throws StoreException, CommandException {
        ActionExecutor executor;
        WorkflowJobBean workflow = store.getWorkflow(this.jobId, false);
        this.setLogInfo(workflow);
        WorkflowActionBean action = store.getAction(this.id, false);
        this.setLogInfo(action);
        if (action.isPending() && action.getStatus() == WorkflowAction.Status.KILLED && (executor = Services.get().get(ActionService.class).getExecutor(action.getType())) != null) {
            try {
                boolean isRetry = false;
                ActionCommand.ActionExecutorContext context = new ActionCommand.ActionExecutorContext(workflow, action, isRetry);
                this.incrActionCounter(action.getType(), 1);
                Instrumentation.Cron cron = new Instrumentation.Cron();
                cron.start();
                executor.kill(context, action);
                cron.stop();
                this.addActionCron(action.getType(), cron);
                action.resetPending();
                action.setStatus(WorkflowAction.Status.KILLED);
                store.updateAction(action);
                store.updateWorkflow(workflow);
                SLADbOperations.writeStausEvent(action.getSlaXml(), action.getId(), store, SLAEvent.Status.KILLED, SLAEvent.SlaAppType.WORKFLOW_ACTION);
                this.queueCallable(new NotificationCommand(workflow, action));
            }
            catch (ActionExecutorException ex) {
                action.resetPending();
                action.setStatus(WorkflowAction.Status.FAILED);
                action.setErrorInfo(ex.getErrorCode().toString(), "KILL COMMAND FAILED - exception while executing job kill");
                workflow.setStatus(WorkflowJob.Status.KILLED);
                store.updateAction(action);
                store.updateWorkflow(workflow);
                SLADbOperations.writeStausEvent(action.getSlaXml(), action.getId(), store, SLAEvent.Status.FAILED, SLAEvent.SlaAppType.WORKFLOW_ACTION);
                XLog.getLog(this.getClass()).warn("Exception while executing kill(). Error Code [{0}], Message[{1}]", ex.getErrorCode(), ex.getMessage(), ex);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void execute(WorkflowStore store) throws CommandException, StoreException {
        XLog.getLog(this.getClass()).debug("STARTED ActionKillCommand for action " + this.id);
        try {
            this.jobId = Services.get().get(UUIDService.class).getId(this.id);
            if (this.lock(this.jobId)) {
                this.call(store);
            } else {
                this.queueCallable(new ActionKillCommand(this.id, this.getType()), 30000L);
                XLog.getLog(this.getClass()).warn("ActionKill lock was not acquired - failed {0}", this.id);
            }
        }
        catch (InterruptedException e) {
            this.queueCallable(new ActionKillCommand(this.id, this.getType()), 30000L);
            XLog.getLog(this.getClass()).warn("ActionKill lock was not acquired - interrupted exception failed {0}", this.id);
        }
        finally {
            XLog.getLog(this.getClass()).debug("ENDED ActionKillCommand for action " + this.id);
        }
        return null;
    }
}

