/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.io.IOException;
import java.io.StringReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.DagEngine;
import org.apache.oozie.DagEngineException;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.SLAEvent;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.coord.CoordActionReadyCommand;
import org.apache.oozie.command.coord.CoordinatorCommand;
import org.apache.oozie.service.DagEngineService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.WorkflowStoreService;
import org.apache.oozie.store.CoordinatorStore;
import org.apache.oozie.store.StoreException;
import org.apache.oozie.store.WorkflowStore;
import org.apache.oozie.util.JobUtils;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XmlUtils;
import org.apache.oozie.util.db.SLADbOperations;
import org.jdom.Element;
import org.jdom.JDOMException;

public class CoordActionStartCommand
extends CoordinatorCommand<Void> {
    public static final String EL_ERROR = "EL_ERROR";
    public static final String EL_EVAL_ERROR = "EL_EVAL_ERROR";
    public static final String COULD_NOT_START = "COULD_NOT_START";
    public static final String START_DATA_MISSING = "START_DATA_MISSING";
    public static final String EXEC_DATA_MISSING = "EXEC_DATA_MISSING";
    private final XLog log = XLog.getLog(this.getClass());
    private String actionId = null;
    private String user = null;
    private String authToken = null;
    private CoordinatorActionBean coordAction = null;

    public CoordActionStartCommand(String id, String user, String token) {
        super("coord_action_start", "coord_action_start", 1, 4);
        this.actionId = ParamChecker.notEmpty(id, "id");
        this.user = ParamChecker.notEmpty(user, "user");
        this.authToken = ParamChecker.notEmpty(token, "token");
    }

    private Configuration mergeConfig(CoordinatorActionBean action) throws CommandException {
        String createdConf = action.getCreatedConf();
        String actionXml = action.getActionXml();
        Element workflowProperties = null;
        try {
            workflowProperties = XmlUtils.parseXml(actionXml);
        }
        catch (JDOMException e1) {
            this.log.warn("Configuration parse error in:" + actionXml);
            throw new CommandException(ErrorCode.E1005, new Object[]{e1.getMessage(), e1});
        }
        XConfiguration runConf = null;
        try {
            runConf = new XConfiguration(new StringReader(createdConf));
        }
        catch (IOException e1) {
            this.log.warn("Configuration parse error in:" + createdConf);
            throw new CommandException(ErrorCode.E1005, e1.getMessage(), e1);
        }
        Element configElement = workflowProperties.getChild("action", workflowProperties.getNamespace()).getChild("workflow", workflowProperties.getNamespace()).getChild("configuration", workflowProperties.getNamespace());
        if (configElement != null) {
            XConfiguration localConf;
            String strConfig = XmlUtils.prettyPrint(configElement).toString();
            try {
                localConf = new XConfiguration(new StringReader(strConfig));
            }
            catch (IOException e1) {
                this.log.warn("Configuration parse error in:" + strConfig);
                throw new CommandException(ErrorCode.E1005, e1.getMessage(), e1);
            }
            XConfiguration.copy(localConf, runConf);
        }
        String appPath = workflowProperties.getChild("action", workflowProperties.getNamespace()).getChild("workflow", workflowProperties.getNamespace()).getChild("app-path", workflowProperties.getNamespace()).getValue();
        runConf.set("oozie.wf.application.path", appPath);
        return runConf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void call(CoordinatorStore store) throws StoreException, CommandException {
        boolean makeFail = true;
        String errCode = "";
        String errMsg = "";
        ParamChecker.notEmpty(this.user, "user");
        ParamChecker.notEmpty(this.authToken, "authToken");
        this.log.debug("actionid=" + this.actionId + ", status=" + this.coordAction.getStatus());
        if (this.coordAction.getStatus() == CoordinatorAction.Status.SUBMITTED) {
            Configuration runConf = this.mergeConfig(this.coordAction);
            this.coordAction.setRunConf(XmlUtils.prettyPrint(runConf).toString());
            DagEngine dagEngine = Services.get().get(DagEngineService.class).getDagEngine(this.user, this.authToken);
            try {
                boolean startJob = true;
                XConfiguration conf = new XConfiguration(new StringReader(this.coordAction.getRunConf()));
                SLADbOperations.writeStausEvent(this.coordAction.getSlaXml(), this.coordAction.getId(), store, SLAEvent.Status.STARTED, SLAEvent.SlaAppType.COORDINATOR_ACTION);
                JobUtils.normalizeAppPath(conf.get("user.name"), conf.get("group.name"), conf);
                String wfId = dagEngine.submitJob(conf, startJob);
                this.coordAction.setStatus(CoordinatorAction.Status.RUNNING);
                this.coordAction.setExternalId(wfId);
                store.updateCoordinatorAction(this.coordAction);
                this.log.debug("Updating WF record for WFID :" + wfId + " with parent id: " + this.actionId);
                WorkflowStore wfStore = Services.get().get(WorkflowStoreService.class).create(store);
                WorkflowJobBean wfJob = wfStore.getWorkflow(wfId, false);
                wfJob.setParentId(this.actionId);
                wfStore.updateWorkflow(wfJob);
                makeFail = false;
            }
            catch (StoreException se) {
                makeFail = false;
                throw se;
            }
            catch (DagEngineException dee) {
                errMsg = dee.getMessage();
                errCode = "E1005";
                this.log.warn((Object)"can not create DagEngine for submitting jobs", dee);
            }
            catch (CommandException ce) {
                errMsg = ce.getMessage();
                errCode = ce.getErrorCode().toString();
                this.log.warn((Object)"command exception occured ", ce);
            }
            catch (IOException ioe) {
                errMsg = ioe.getMessage();
                errCode = "E1005";
                this.log.warn((Object)("Configuration parse error. read from DB :" + this.coordAction.getRunConf()), ioe);
            }
            catch (Exception ex) {
                errMsg = ex.getMessage();
                errCode = "E1005";
                this.log.warn((Object)"can not create DagEngine for submitting jobs", ex);
            }
            finally {
                if (makeFail) {
                    this.log.warn("Failing the action " + this.coordAction.getId() + ". Because " + errCode + " : " + errMsg);
                    this.coordAction.setStatus(CoordinatorAction.Status.FAILED);
                    if (errMsg.length() > 254) {
                        errMsg = errMsg.substring(0, 255);
                    }
                    this.coordAction.setErrorMessage(errMsg);
                    this.coordAction.setErrorCode(errCode);
                    store.updateCoordinatorAction(this.coordAction);
                    this.queueCallable(new CoordActionReadyCommand(this.coordAction.getJobId()));
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void execute(CoordinatorStore store) throws StoreException, CommandException {
        this.log.info("STARTED CoordActionStartCommand  actionId=" + this.actionId);
        try {
            this.coordAction = (CoordinatorActionBean)store.getEntityManager().find(CoordinatorActionBean.class, (Object)this.actionId);
            this.setLogInfo(this.coordAction);
            if (this.lock(this.coordAction.getJobId())) {
                this.call(store);
            } else {
                this.queueCallable(new CoordActionStartCommand(this.actionId, this.user, this.authToken), 30000L);
                this.log.warn("CoordActionStartCommand lock was not acquired - failed jobId=" + this.coordAction.getJobId() + ", actionId=" + this.actionId + ". Requeing the same.");
            }
        }
        catch (InterruptedException e) {
            this.queueCallable(new CoordActionStartCommand(this.actionId, this.user, this.authToken), 30000L);
            this.log.warn("CoordActionStartCommand lock acquiring failed with exception " + e.getMessage() + " for jobId=" + this.coordAction.getJobId() + ", actionId=" + this.actionId + " Requeing the same.");
        }
        finally {
            this.log.info("ENDED CoordActionStartCommand  actionId=" + this.actionId);
        }
        return null;
    }
}

