/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.jcr.support;

import java.io.IOException;
import javax.jcr.Session;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.extensions.jcr.SessionFactory;
import org.springframework.extensions.jcr.SessionFactoryUtils;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class OpenSessionInViewFilter
extends OncePerRequestFilter {
    private static final Logger LOG = LoggerFactory.getLogger(OpenSessionInViewFilter.class);
    public static final String DEFAULT_JCR_SESSION_FACTORY_FACTORY_BEAN_NAME = "sessionFactory";
    private String SessionFactoryBeanName = "sessionFactory";

    public void setSessionFactoryBeanName(String SessionFactoryBeanName) {
        this.SessionFactoryBeanName = SessionFactoryBeanName;
    }

    protected String getSessionFactoryBeanName() {
        return this.SessionFactoryBeanName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        SessionFactory sf = this.lookupSessionFactory(request);
        Session session = null;
        boolean participate = false;
        if (TransactionSynchronizationManager.hasResource((Object)sf)) {
            participate = true;
        } else {
            LOG.debug("Opening JCR session in OpenSessionInViewFilter");
            session = SessionFactoryUtils.getSession(sf, true);
            TransactionSynchronizationManager.bindResource((Object)sf, (Object)((Object)sf.getSessionHolder(session)));
        }
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            if (!participate) {
                TransactionSynchronizationManager.unbindResource((Object)sf);
                LOG.debug("Closing JCR session in OpenSessionInViewFilter");
                SessionFactoryUtils.releaseSession(session, sf);
            }
        }
    }

    protected SessionFactory lookupSessionFactory(HttpServletRequest request) {
        return this.lookupSessionFactory();
    }

    protected SessionFactory lookupSessionFactory() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using session factory '" + this.getSessionFactoryBeanName() + "' for OpenSessionInViewFilter");
        }
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        return (SessionFactory)wac.getBean(this.getSessionFactoryBeanName(), SessionFactory.class);
    }
}

