/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.jcr.support;

import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.support.DaoSupport;
import org.springframework.extensions.jcr.JcrTemplate;
import org.springframework.extensions.jcr.SessionFactory;
import org.springframework.extensions.jcr.SessionFactoryUtils;
import org.springframework.util.Assert;

public abstract class JcrDaoSupport
extends DaoSupport {
    private JcrTemplate template;

    public final void setSessionFactory(SessionFactory sessionFactory) {
        this.template = new JcrTemplate(sessionFactory);
    }

    public final SessionFactory getSessionFactory() {
        return this.template != null ? this.template.getSessionFactory() : null;
    }

    public final void setTemplate(JcrTemplate jcrTemplate) {
        this.template = jcrTemplate;
    }

    public final JcrTemplate getTemplate() {
        return this.template;
    }

    protected final void checkDaoConfig() {
        Assert.notNull((Object)this.template, (String)"sessionFactory or jcrTemplate is required");
    }

    protected final Session getSession() {
        return this.getSession(this.template.isAllowCreate());
    }

    protected final Session getSession(boolean allowCreate) throws DataAccessResourceFailureException, IllegalStateException {
        return SessionFactoryUtils.getSession(this.getSessionFactory(), allowCreate);
    }

    protected final DataAccessException convertJcrAccessException(RepositoryException ex) {
        return this.template.convertJcrAccessException(ex);
    }

    protected final void releaseSession(Session session) {
        SessionFactoryUtils.releaseSession(session, this.getSessionFactory());
    }
}

