/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.jcr.jackrabbit;

import javax.jcr.Repository;
import org.apache.jackrabbit.api.JackrabbitRepository;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.xml.sax.InputSource;

public class RepositoryFactoryBean
extends org.springframework.extensions.jcr.RepositoryFactoryBean {
    private static final Logger LOG = LoggerFactory.getLogger(RepositoryFactoryBean.class);
    private static final String DEFAULT_CONF_FILE = "repository.xml";
    private static final String DEFAULT_REP_DIR = ".";
    private Resource homeDir;
    private RepositoryConfig repositoryConfig;

    protected Repository createRepository() throws Exception {
        return RepositoryImpl.create((RepositoryConfig)this.repositoryConfig);
    }

    protected void resolveConfigurationResource() throws Exception {
        if (this.repositoryConfig != null) {
            return;
        }
        if (this.configuration == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("no configuration resource specified, using the default one:repository.xml");
            }
            this.configuration = new ClassPathResource(DEFAULT_CONF_FILE);
        }
        if (this.homeDir == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("no repository home dir specified, using the default one:.");
            }
            this.homeDir = new FileSystemResource(DEFAULT_REP_DIR);
        }
        this.repositoryConfig = RepositoryConfig.create((InputSource)new InputSource(this.configuration.getInputStream()), (String)this.homeDir.getFile().getAbsolutePath());
    }

    public void destroy() throws Exception {
        if (this.repository instanceof JackrabbitRepository) {
            ((JackrabbitRepository)this.repository).shutdown();
        }
    }

    public Resource getHomeDir() {
        return this.homeDir;
    }

    public void setHomeDir(Resource defaultRepDir) {
        this.homeDir = defaultRepDir;
    }

    public RepositoryConfig getRepositoryConfig() {
        return this.repositoryConfig;
    }

    public void setRepositoryConfig(RepositoryConfig repositoryConfig) {
        this.repositoryConfig = repositoryConfig;
    }
}

