/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.jcr;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Repository;
import org.apache.xerces.util.XMLChar;

public abstract class JcrUtils {
    private static ISO9075 escaper = new ISO9075();

    public static boolean supportsLevel2(Repository repository) {
        return "true".equals(repository.getDescriptor("level.2.supported"));
    }

    public static boolean supportsTransactions(Repository repository) {
        return "true".equals(repository.getDescriptor("option.transactions.supported"));
    }

    public static boolean supportsVersioning(Repository repository) {
        return "true".equals(repository.getDescriptor("option.versioning.supported"));
    }

    public static boolean supportsObservation(Repository repository) {
        return "true".equals(repository.getDescriptor("option.observation.supported"));
    }

    public static boolean supportsLocking(Repository repository) {
        return "true".equals(repository.getDescriptor("option.locking.supported"));
    }

    public static boolean supportsSQLQuery(Repository repository) {
        return "true".equals(repository.getDescriptor("option.query.sql.supported"));
    }

    public static boolean supportsXPathPosIndex(Repository repository) {
        return "true".equals(repository.getDescriptor("query.xpath.pos.index"));
    }

    public static boolean supportsXPathDocOrder(Repository repository) {
        return "true".equals(repository.getDescriptor("query.xpath.doc.order"));
    }

    public static String encode(String decoded) {
        return escaper.encode(decoded);
    }

    public static String decode(String encoded) {
        return escaper.decode(encoded);
    }

    protected static class ISO9075 {
        private final Pattern ENCODE_PATTERN = Pattern.compile("_x\\p{XDigit}{4}_");
        private final char[] PADDING = new char[]{'0', '0', '0'};
        private final String HEX_DIGITS = "0123456789abcdefABCDEF";

        protected ISO9075() {
        }

        public String encode(String name) {
            if (name.length() == 0) {
                return name;
            }
            if (XMLChar.isValidName((String)name) && name.indexOf("_x") < 0) {
                return name;
            }
            StringBuffer encoded = new StringBuffer();
            for (int i = 0; i < name.length(); ++i) {
                if (i == 0) {
                    if (XMLChar.isNameStart((int)name.charAt(i))) {
                        if (this.needsEscaping(name, i)) {
                            this.encode('_', encoded);
                            continue;
                        }
                        encoded.append(name.charAt(i));
                        continue;
                    }
                    this.encode(name.charAt(i), encoded);
                    continue;
                }
                if (!XMLChar.isName((int)name.charAt(i))) {
                    this.encode(name.charAt(i), encoded);
                    continue;
                }
                if (this.needsEscaping(name, i)) {
                    this.encode('_', encoded);
                    continue;
                }
                encoded.append(name.charAt(i));
            }
            return encoded.toString();
        }

        public String decode(String name) {
            if (name.indexOf("_x") < 0) {
                return name;
            }
            StringBuffer decoded = new StringBuffer();
            Matcher m = this.ENCODE_PATTERN.matcher(name);
            while (m.find()) {
                m.appendReplacement(decoded, Character.toString((char)Integer.parseInt(m.group().substring(2, 6), 16)));
            }
            m.appendTail(decoded);
            return decoded.toString();
        }

        private void encode(char c, StringBuffer b) {
            b.append("_x");
            String hex = Integer.toHexString(c);
            b.append(this.PADDING, 0, 4 - hex.length());
            b.append(hex);
            b.append("_");
        }

        private boolean needsEscaping(String name, int location) throws ArrayIndexOutOfBoundsException {
            if (name.charAt(location) == '_' && name.length() >= location + 6) {
                return name.charAt(location + 1) == 'x' && "0123456789abcdefABCDEF".indexOf(name.charAt(location + 2)) != -1 && "0123456789abcdefABCDEF".indexOf(name.charAt(location + 3)) != -1 && "0123456789abcdefABCDEF".indexOf(name.charAt(location + 4)) != -1 && "0123456789abcdefABCDEF".indexOf(name.charAt(location + 5)) != -1;
            }
            return false;
        }
    }
}

