/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.MalformedReplyException;

public class FTPReply {
    public static final String cvsId = "@(#)$Id: FTPReply.java,v 1.7 2008-08-26 04:35:40 bruceb Exp $";
    private String replyCode;
    private String replyText;
    private String rawReply;
    private String[] data;

    FTPReply(String replyCode, String replyText) throws MalformedReplyException {
        this.replyCode = replyCode;
        this.replyText = replyText;
        this.rawReply = replyCode + " " + replyText;
        this.validateCode(replyCode);
    }

    FTPReply(String replyCode, String replyText, String[] data) throws MalformedReplyException {
        this.replyCode = replyCode;
        this.replyText = replyText;
        this.data = data;
        this.validateCode(replyCode);
    }

    FTPReply(String reply) throws MalformedReplyException {
        this.rawReply = reply.trim();
        this.replyCode = this.rawReply.substring(0, 3);
        this.replyText = this.rawReply.length() > 3 ? this.rawReply.substring(4) : "";
        this.validateCode(this.replyCode);
    }

    public String getRawReply() {
        return this.rawReply;
    }

    public String getReplyCode() {
        return this.replyCode;
    }

    public String getReplyText() {
        return this.replyText;
    }

    public String[] getReplyData() {
        return this.data;
    }

    private void validateCode(String code) throws MalformedReplyException {
        try {
            Integer.parseInt(code);
        }
        catch (NumberFormatException ex) {
            throw new MalformedReplyException("Invalid reply code '" + code + "'");
        }
    }
}

