/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Impl;
import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.ConverterImpl;
import com.ibm.as400.access.ExecutionEnvironment;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;

class Converter
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2004 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    transient ConverterImpl impl;
    private String encoding_ = null;
    private int ccsid_ = -1;
    private AS400 system_ = null;

    Converter() {
        this.ccsid_ = ExecutionEnvironment.getBestGuessAS400Ccsid();
        try {
            this.chooseImpl();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Trace.log(2, "Unexpected CCSID returned from getBestGuessAS400Ccsid: " + this.ccsid_, (Throwable)unsupportedEncodingException);
            throw new InternalErrorException(10);
        }
    }

    Converter(String string) throws UnsupportedEncodingException {
        this.encoding_ = string;
        this.chooseImpl();
    }

    Converter(int n) throws UnsupportedEncodingException {
        this.ccsid_ = n;
        this.chooseImpl();
    }

    Converter(int n, AS400 aS400) throws UnsupportedEncodingException {
        this.ccsid_ = n;
        this.system_ = aS400;
        this.chooseImpl();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.chooseImpl();
    }

    private void chooseImpl() throws UnsupportedEncodingException {
        if (this.system_ == null) {
            this.impl = (ConverterImpl)AS400.loadImpl("com.ibm.as400.access.ConverterImplRemote");
            if (this.impl == null) {
                throw new UnsupportedEncodingException();
            }
            if (this.encoding_ != null) {
                this.impl.setEncoding(this.encoding_);
            } else {
                this.impl.setCcsid(this.ccsid_, null);
            }
        } else {
            this.impl = (ConverterImpl)this.system_.loadImpl2("com.ibm.as400.access.ConverterImplRemote", "com.ibm.as400.access.ConverterImplProxy");
            AS400Impl aS400Impl = this.system_.getImpl();
            try {
                this.impl.setCcsid(this.ccsid_, aS400Impl);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                try {
                    this.system_.connectService(6);
                    this.impl.setCcsid(this.ccsid_, aS400Impl);
                }
                catch (Exception exception) {
                    throw unsupportedEncodingException;
                }
            }
        }
    }

    String byteArrayToString(byte[] byArray) {
        return this.impl.byteArrayToString(byArray, 0, byArray.length);
    }

    String byteArrayToString(byte[] byArray, int n) {
        return this.impl.byteArrayToString(byArray, n, byArray.length - n);
    }

    String byteArrayToString(byte[] byArray, int n, int n2) {
        return this.impl.byteArrayToString(byArray, n, n2);
    }

    String byteArrayToString(byte[] byArray, int n, int n2, int n3) {
        return this.byteArrayToString(byArray, n, n2, new BidiConversionProperties(n3));
    }

    String byteArrayToString(byte[] byArray, int n, int n2, BidiConversionProperties bidiConversionProperties) {
        return this.impl.byteArrayToString(byArray, n, n2, bidiConversionProperties);
    }

    int getCcsid() {
        return this.impl.getCcsid();
    }

    String getEncoding() {
        return this.impl.getEncoding();
    }

    byte[] stringToByteArray(String string) {
        return this.impl.stringToByteArray(string);
    }

    byte[] stringToByteArray(String string, int n) {
        return this.stringToByteArray(string, new BidiConversionProperties(n));
    }

    byte[] stringToByteArray(String string, BidiConversionProperties bidiConversionProperties) {
        return this.impl.stringToByteArray(string, bidiConversionProperties);
    }

    void stringToByteArray(String string, byte[] byArray) throws CharConversionException {
        byte[] byArray2 = this.impl.stringToByteArray(string);
        if (byArray2.length > byArray.length) {
            System.arraycopy(byArray2, 0, byArray, 0, byArray.length);
            throw new CharConversionException();
        }
        System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
    }

    void stringToByteArray(String string, byte[] byArray, int n) throws CharConversionException {
        byte[] byArray2 = this.impl.stringToByteArray(string);
        if (byArray2.length > byArray.length - n) {
            System.arraycopy(byArray2, 0, byArray, n, byArray.length - n);
            throw new CharConversionException();
        }
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
    }

    void stringToByteArray(String string, byte[] byArray, int n, int n2) throws CharConversionException {
        byte[] byArray2 = this.impl.stringToByteArray(string);
        if (byArray2.length > n2) {
            System.arraycopy(byArray2, 0, byArray, n, n2);
            throw new CharConversionException();
        }
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
    }

    void stringToByteArray(String string, byte[] byArray, int n, int n2, int n3) throws CharConversionException {
        this.stringToByteArray(string, byArray, n, n2, new BidiConversionProperties(n3));
    }

    void stringToByteArray(String string, byte[] byArray, int n, int n2, BidiConversionProperties bidiConversionProperties) throws CharConversionException {
        byte[] byArray2 = this.impl.stringToByteArray(string, bidiConversionProperties);
        if (byArray2.length > n2) {
            System.arraycopy(byArray2, 0, byArray, n, n2);
            throw new CharConversionException();
        }
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
    }
}

