/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ClientAccessDataStream;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.DataStream;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InputStream;

class AS400StrSvrReplyDS
extends ClientAccessDataStream {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";

    AS400StrSvrReplyDS() {
    }

    int getRC() {
        return this.get32bit(20);
    }

    byte[] getUserIdBytes() {
        int n = this.findCP(4356);
        if (n == -1) {
            return null;
        }
        byte[] byArray = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
        System.arraycopy(this.data_, n + 10, byArray, 0, this.get32bit(n) - 10);
        return byArray;
    }

    byte[] getJobNameBytes() {
        int n = this.findCP(4383);
        if (n == -1) {
            return new byte[0];
        }
        byte[] byArray = new byte[this.get32bit(n) - 10];
        System.arraycopy(this.data_, n + 10, byArray, 0, byArray.length);
        return byArray;
    }

    int findCP(int n) {
        for (int i = 24; i < this.data_.length - 1; i += this.get32bit(i)) {
            if (this.get16bit(i + 4) != n) continue;
            return i;
        }
        return -1;
    }

    void read(InputStream inputStream) throws IOException {
        byte[] byArray;
        if (Trace.traceOn_) {
            Trace.log(1, "Receiving start server reply...");
        }
        if (DataStream.readFromStream(inputStream, byArray = new byte[20], 0, 20) < 20) {
            if (Trace.traceOn_) {
                Trace.log(2, "Failed to read all of the start server reply header.");
            }
            throw new ConnectionDroppedException(2);
        }
        this.data_ = new byte[BinaryConverter.byteArrayToInt(byArray, 0)];
        System.arraycopy(byArray, 0, this.data_, 0, 20);
        this.readAfterHeader(inputStream);
    }
}

