/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.kafka;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.pentaho.big.data.api.cluster.NamedCluster;
import org.pentaho.big.data.api.cluster.NamedClusterService;
import org.pentaho.big.data.api.cluster.service.locator.NamedClusterServiceLocator;
import org.pentaho.big.data.kettle.plugins.kafka.KafkaConsumerField;
import org.pentaho.big.data.kettle.plugins.kafka.KafkaConsumerInput;
import org.pentaho.big.data.kettle.plugins.kafka.KafkaConsumerInputData;
import org.pentaho.big.data.kettle.plugins.kafka.KafkaFactory;
import org.pentaho.bigdata.api.jaas.JaasConfigService;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ObjectLocationSpecificationMethod;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionDeep;
import org.pentaho.di.core.injection.InjectionSupported;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.streaming.common.BaseStreamStepMeta;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.osgi.metastore.locator.api.MetastoreLocator;
import org.w3c.dom.Node;

@Step(id="KafkaConsumerInput", image="KafkaConsumerInput.svg", i18nPackageName="org.pentaho.big.data.kettle.plugins.kafka", name="KafkaConsumer.TypeLongDesc", description="KafkaConsumer.TypeTooltipDesc", categoryDescription="i18n:org.pentaho.di.trans.step:BaseStep.Category.Streaming", documentationUrl="Products/Data_Integration/Transformation_Step_Reference/Kafka_Consumer")
@InjectionSupported(localizationPrefix="KafkaConsumerInputMeta.Injection.", groups={"CONFIGURATION_PROPERTIES"})
public class KafkaConsumerInputMeta
extends BaseStreamStepMeta
implements StepMetaInterface {
    public static final String CLUSTER_NAME = "clusterName";
    public static final String TOPIC = "topic";
    public static final String CONSUMER_GROUP = "consumerGroup";
    public static final String TRANSFORMATION_PATH = "transformationPath";
    public static final String BATCH_SIZE = "batchSize";
    public static final String BATCH_DURATION = "batchDuration";
    public static final String CONNECTION_TYPE = "connectionType";
    public static final String DIRECT_BOOTSTRAP_SERVERS = "directBootstrapServers";
    public static final String ADVANCED_CONFIG = "advancedConfig";
    public static final String CONFIG_OPTION = "option";
    public static final String OPTION_PROPERTY = "property";
    public static final String OPTION_VALUE = "value";
    public static final String TOPIC_FIELD_NAME = "topic";
    public static final String OFFSET_FIELD_NAME = "offset";
    public static final String PARTITION_FIELD_NAME = "partition";
    public static final String TIMESTAMP_FIELD_NAME = "timestamp";
    public static final String OUTPUT_FIELD_TAG_NAME = "OutputField";
    public static final String KAFKA_NAME_ATTRIBUTE = "kafkaName";
    public static final String TYPE_ATTRIBUTE = "type";
    public static final String AUTO_COMMIT = "AUTO_COMMIT";
    private static Class<?> PKG = KafkaConsumerInput.class;
    @Injection(name="CONNECTION_TYPE")
    private ConnectionType connectionType = ConnectionType.DIRECT;
    @Injection(name="DIRECT_BOOTSTRAP_SERVERS")
    private String directBootstrapServers;
    @Injection(name="CLUSTER_NAME")
    private String clusterName;
    @Injection(name="TOPICS")
    private List<String> topics = new ArrayList<String>();
    @Injection(name="CONSUMER_GROUP")
    private String consumerGroup;
    @InjectionDeep(prefix="KEY")
    private KafkaConsumerField keyField;
    @InjectionDeep(prefix="MESSAGE")
    private KafkaConsumerField messageField;
    @Injection(name="NAMES", group="CONFIGURATION_PROPERTIES")
    protected transient List<String> injectedConfigNames;
    @Injection(name="VALUES", group="CONFIGURATION_PROPERTIES")
    protected transient List<String> injectedConfigValues;
    @Injection(name="AUTO_COMMIT")
    private boolean autoCommit = true;
    private Map<String, String> config = new LinkedHashMap<String, String>();
    private KafkaConsumerField topicField;
    private KafkaConsumerField offsetField;
    private KafkaConsumerField partitionField;
    private KafkaConsumerField timestampField;
    private transient KafkaFactory kafkaFactory = KafkaFactory.defaultFactory();
    private NamedClusterService namedClusterService;
    private MetastoreLocator metastoreLocator;
    private NamedClusterServiceLocator namedClusterServiceLocator;

    public KafkaConsumerInputMeta() {
        this.keyField = new KafkaConsumerField(KafkaConsumerField.Name.KEY, BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.KeyField", (String[])new String[0]));
        this.messageField = new KafkaConsumerField(KafkaConsumerField.Name.MESSAGE, BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.MessageField", (String[])new String[0]));
        this.topicField = new KafkaConsumerField(KafkaConsumerField.Name.TOPIC, BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.TopicField", (String[])new String[0]));
        this.partitionField = new KafkaConsumerField(KafkaConsumerField.Name.PARTITION, BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.PartitionField", (String[])new String[0]), KafkaConsumerField.Type.Integer);
        this.offsetField = new KafkaConsumerField(KafkaConsumerField.Name.OFFSET, BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.OffsetField", (String[])new String[0]), KafkaConsumerField.Type.Integer);
        this.timestampField = new KafkaConsumerField(KafkaConsumerField.Name.TIMESTAMP, BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.TimestampField", (String[])new String[0]), KafkaConsumerField.Type.Integer);
        this.setSpecificationMethod(ObjectLocationSpecificationMethod.FILENAME);
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) {
        this.readData(stepnode);
    }

    private void readData(Node stepnode) {
        this.setClusterName(XMLHandler.getTagValue((Node)stepnode, (String)CLUSTER_NAME));
        List topicsNode = XMLHandler.getNodes((Node)stepnode, (String)"topic");
        topicsNode.forEach(node -> {
            String displayName = XMLHandler.getNodeValue((Node)node);
            this.addTopic(displayName);
        });
        this.setConsumerGroup(XMLHandler.getTagValue((Node)stepnode, (String)CONSUMER_GROUP));
        this.setTransformationPath(XMLHandler.getTagValue((Node)stepnode, (String)TRANSFORMATION_PATH));
        String subStepTag = XMLHandler.getTagValue((Node)stepnode, (String)"SUB_STEP");
        if (!StringUtil.isEmpty((String)subStepTag)) {
            this.setSubStep(subStepTag);
        }
        this.setFileName(XMLHandler.getTagValue((Node)stepnode, (String)TRANSFORMATION_PATH));
        this.setBatchSize(XMLHandler.getTagValue((Node)stepnode, (String)BATCH_SIZE));
        this.setBatchDuration(XMLHandler.getTagValue((Node)stepnode, (String)BATCH_DURATION));
        this.setConnectionType(ConnectionType.valueOf(XMLHandler.getTagValue((Node)stepnode, (String)CONNECTION_TYPE)));
        this.setDirectBootstrapServers(XMLHandler.getTagValue((Node)stepnode, (String)DIRECT_BOOTSTRAP_SERVERS));
        String autoCommitValue = XMLHandler.getTagValue((Node)stepnode, (String)AUTO_COMMIT);
        this.setAutoCommit("Y".equals(autoCommitValue) || Strings.isNullOrEmpty((String)autoCommitValue));
        List ofNode = XMLHandler.getNodes((Node)stepnode, (String)OUTPUT_FIELD_TAG_NAME);
        ofNode.forEach(node -> {
            String displayName = XMLHandler.getNodeValue((Node)node);
            String kafkaName = XMLHandler.getTagAttribute((Node)node, (String)KAFKA_NAME_ATTRIBUTE);
            String type = XMLHandler.getTagAttribute((Node)node, (String)TYPE_ATTRIBUTE);
            KafkaConsumerField field = new KafkaConsumerField(KafkaConsumerField.Name.valueOf(kafkaName.toUpperCase()), displayName, KafkaConsumerField.Type.valueOf(type));
            this.setField(field);
        });
        this.config = new LinkedHashMap<String, String>();
        Optional.ofNullable(XMLHandler.getSubNode((Node)stepnode, (String)ADVANCED_CONFIG)).map(Node::getChildNodes).ifPresent(nodes -> IntStream.range(0, nodes.getLength()).mapToObj(nodes::item).filter(node -> node.getNodeType() == 1).forEach(node -> {
            if (CONFIG_OPTION.equals(node.getNodeName())) {
                this.config.put(node.getAttributes().getNamedItem(OPTION_PROPERTY).getTextContent(), node.getAttributes().getNamedItem(OPTION_VALUE).getTextContent());
            } else {
                this.config.put(node.getNodeName(), node.getTextContent());
            }
        }));
    }

    protected void setField(KafkaConsumerField field) {
        field.getKafkaName().setFieldOnMeta(this, field);
    }

    public void setDefault() {
        this.batchSize = "1000";
        this.batchDuration = "1000";
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        this.setClusterName(rep.getStepAttributeString(id_step, CLUSTER_NAME));
        int topicCount = rep.countNrStepAttributes(id_step, "topic");
        for (int i = 0; i < topicCount; ++i) {
            this.addTopic(rep.getStepAttributeString(id_step, i, "topic"));
        }
        this.setConsumerGroup(rep.getStepAttributeString(id_step, CONSUMER_GROUP));
        this.setTransformationPath(rep.getStepAttributeString(id_step, TRANSFORMATION_PATH));
        this.setSubStep(rep.getStepAttributeString(id_step, "SUB_STEP"));
        this.setFileName(rep.getStepAttributeString(id_step, TRANSFORMATION_PATH));
        this.setBatchSize(rep.getStepAttributeString(id_step, BATCH_SIZE));
        this.setBatchDuration(rep.getStepAttributeString(id_step, BATCH_DURATION));
        this.setConnectionType(ConnectionType.valueOf(rep.getStepAttributeString(id_step, CONNECTION_TYPE)));
        this.setDirectBootstrapServers(rep.getStepAttributeString(id_step, DIRECT_BOOTSTRAP_SERVERS));
        this.setAutoCommit(rep.getStepAttributeBoolean(id_step, 0, AUTO_COMMIT, true));
        for (KafkaConsumerField.Name name : KafkaConsumerField.Name.values()) {
            String prefix = "OutputField_" + (Object)((Object)name);
            String value = rep.getStepAttributeString(id_step, prefix);
            String type = rep.getStepAttributeString(id_step, prefix + "_" + TYPE_ATTRIBUTE);
            if (value == null) continue;
            this.setField(new KafkaConsumerField(name, value, KafkaConsumerField.Type.valueOf(type)));
        }
        this.config = new LinkedHashMap<String, String>();
        int i = 0;
        while ((long)i < rep.getStepAttributeInteger(id_step, "advancedConfig_COUNT")) {
            this.config.put(rep.getStepAttributeString(id_step, i, "advancedConfig_NAME"), rep.getStepAttributeString(id_step, i, "advancedConfig_VALUE"));
            ++i;
        }
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId transId, ObjectId stepId) throws KettleException {
        rep.saveStepAttribute(transId, stepId, CLUSTER_NAME, this.clusterName);
        int i = 0;
        for (String topic : this.topics) {
            rep.saveStepAttribute(transId, stepId, i++, "topic", topic);
        }
        rep.saveStepAttribute(transId, stepId, CONSUMER_GROUP, this.consumerGroup);
        rep.saveStepAttribute(transId, stepId, TRANSFORMATION_PATH, this.transformationPath);
        rep.saveStepAttribute(transId, stepId, "SUB_STEP", this.getSubStep());
        rep.saveStepAttribute(transId, stepId, BATCH_SIZE, this.batchSize);
        rep.saveStepAttribute(transId, stepId, BATCH_DURATION, this.batchDuration);
        rep.saveStepAttribute(transId, stepId, CONNECTION_TYPE, this.connectionType.name());
        rep.saveStepAttribute(transId, stepId, DIRECT_BOOTSTRAP_SERVERS, this.directBootstrapServers);
        rep.saveStepAttribute(transId, stepId, AUTO_COMMIT, this.autoCommit);
        List<KafkaConsumerField> fields = this.getFieldDefinitions();
        for (KafkaConsumerField field : fields) {
            String prefix = "OutputField_" + field.getKafkaName().toString();
            rep.saveStepAttribute(transId, stepId, prefix, field.getOutputName());
            rep.saveStepAttribute(transId, stepId, prefix + "_" + TYPE_ATTRIBUTE, field.getOutputType().toString());
        }
        rep.saveStepAttribute(transId, stepId, "advancedConfig_COUNT", (long)this.getConfig().size());
        i = 0;
        for (String propName : this.getConfig().keySet()) {
            rep.saveStepAttribute(transId, stepId, i, "advancedConfig_NAME", propName);
            rep.saveStepAttribute(transId, stepId, i++, "advancedConfig_VALUE", this.getConfig().get(propName));
        }
    }

    public RowMeta getRowMeta(String origin, VariableSpace space) throws KettleStepException {
        RowMeta rowMeta = new RowMeta();
        this.putFieldOnRowMeta(this.getKeyField(), (RowMetaInterface)rowMeta, origin, space);
        this.putFieldOnRowMeta(this.getMessageField(), (RowMetaInterface)rowMeta, origin, space);
        this.putFieldOnRowMeta(this.getTopicField(), (RowMetaInterface)rowMeta, origin, space);
        this.putFieldOnRowMeta(this.getPartitionField(), (RowMetaInterface)rowMeta, origin, space);
        this.putFieldOnRowMeta(this.getOffsetField(), (RowMetaInterface)rowMeta, origin, space);
        this.putFieldOnRowMeta(this.getTimestampField(), (RowMetaInterface)rowMeta, origin, space);
        return rowMeta;
    }

    private void putFieldOnRowMeta(KafkaConsumerField field, RowMetaInterface rowMeta, String origin, VariableSpace space) throws KettleStepException {
        if (field != null && !Utils.isEmpty((CharSequence)field.getOutputName())) {
            try {
                String value = space.environmentSubstitute(field.getOutputName());
                ValueMetaInterface v = ValueMetaFactory.createValueMeta((String)value, (int)field.getOutputType().getValueMetaInterfaceType());
                v.setOrigin(origin);
                rowMeta.addValueMeta(v);
            }
            catch (KettlePluginException e) {
                throw new KettleStepException(BaseMessages.getString(PKG, (String)"KafkaConsumerInputMeta.UnableToCreateValueType", (Object[])new Object[]{field}), (Throwable)e);
            }
        }
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new KafkaConsumerInput(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    public StepDataInterface getStepData() {
        return new KafkaConsumerInputData();
    }

    public void setTopics(ArrayList<String> topics) {
        this.topics = topics;
    }

    public void addTopic(String topic) {
        this.topics.add(topic);
    }

    public void setConsumerGroup(String consumerGroup) {
        this.consumerGroup = consumerGroup;
    }

    public String getBootstrapServers() {
        if (ConnectionType.DIRECT.equals((Object)this.getConnectionType())) {
            return this.getDirectBootstrapServers();
        }
        return Optional.ofNullable(this.namedClusterService.getNamedClusterByName(this.parentStepMeta.getParentTransMeta().environmentSubstitute(this.clusterName), this.metastoreLocator.getMetastore())).map(NamedCluster::getKafkaBootstrapServers).orElse("");
    }

    public List<String> getTopics() {
        return this.topics;
    }

    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    public KafkaConsumerField getKeyField() {
        return this.keyField;
    }

    public KafkaConsumerField getMessageField() {
        return this.messageField;
    }

    public KafkaConsumerField getTopicField() {
        return this.topicField;
    }

    public KafkaConsumerField getOffsetField() {
        return this.offsetField;
    }

    public KafkaConsumerField getPartitionField() {
        return this.partitionField;
    }

    public KafkaConsumerField getTimestampField() {
        return this.timestampField;
    }

    public String getDirectBootstrapServers() {
        return this.directBootstrapServers;
    }

    public void setKeyField(KafkaConsumerField keyField) {
        this.keyField = keyField;
    }

    public void setMessageField(KafkaConsumerField messageField) {
        this.messageField = messageField;
    }

    public void setTopicField(KafkaConsumerField topicField) {
        this.topicField = topicField;
    }

    public void setOffsetField(KafkaConsumerField offsetField) {
        this.offsetField = offsetField;
    }

    public void setPartitionField(KafkaConsumerField partitionField) {
        this.partitionField = partitionField;
    }

    public void setTimestampField(KafkaConsumerField timestampField) {
        this.timestampField = timestampField;
    }

    public void setDirectBootstrapServers(String directBootstrapServers) {
        this.directBootstrapServers = directBootstrapServers;
    }

    public ConnectionType getConnectionType() {
        return this.connectionType;
    }

    public void setConnectionType(ConnectionType connectionType) {
        this.connectionType = connectionType;
    }

    public String getXML() {
        StringBuilder retval = new StringBuilder();
        retval.append("    ").append(XMLHandler.addTagValue((String)CLUSTER_NAME, (String)this.clusterName));
        this.parentStepMeta.getParentTransMeta().getNamedClusterEmbedManager().registerUrl("hc://" + this.clusterName);
        this.getTopics().forEach(topic -> retval.append("    ").append(XMLHandler.addTagValue((String)"topic", (String)topic)));
        retval.append("    ").append(XMLHandler.addTagValue((String)CONSUMER_GROUP, (String)this.consumerGroup));
        retval.append("    ").append(XMLHandler.addTagValue((String)TRANSFORMATION_PATH, (String)this.transformationPath));
        retval.append("    ").append(XMLHandler.addTagValue((String)"SUB_STEP", (String)this.getSubStep()));
        retval.append("    ").append(XMLHandler.addTagValue((String)BATCH_SIZE, (String)this.batchSize));
        retval.append("    ").append(XMLHandler.addTagValue((String)BATCH_DURATION, (String)this.batchDuration));
        retval.append("    ").append(XMLHandler.addTagValue((String)CONNECTION_TYPE, (String)this.connectionType.name()));
        retval.append("    ").append(XMLHandler.addTagValue((String)DIRECT_BOOTSTRAP_SERVERS, (String)this.directBootstrapServers));
        retval.append("    ").append(XMLHandler.addTagValue((String)AUTO_COMMIT, (boolean)this.autoCommit));
        this.getFieldDefinitions().forEach(field -> retval.append("    ").append(XMLHandler.addTagValue((String)OUTPUT_FIELD_TAG_NAME, (String)field.getOutputName(), (boolean)true, (String[])new String[]{KAFKA_NAME_ATTRIBUTE, field.getKafkaName().toString(), TYPE_ATTRIBUTE, field.getOutputType().toString()})));
        retval.append("    ").append(XMLHandler.openTag((String)ADVANCED_CONFIG)).append(Const.CR);
        this.getConfig().forEach((key, value) -> retval.append("        ").append(XMLHandler.addTagValue((String)CONFIG_OPTION, (String)"", (boolean)true, (String[])new String[]{OPTION_PROPERTY, key, OPTION_VALUE, value})));
        retval.append("    ").append(XMLHandler.closeTag((String)ADVANCED_CONFIG)).append(Const.CR);
        return retval.toString();
    }

    public List<KafkaConsumerField> getFieldDefinitions() {
        return Lists.newArrayList((Object[])new KafkaConsumerField[]{this.getKeyField(), this.getMessageField(), this.getTopicField(), this.getPartitionField(), this.getOffsetField(), this.getTimestampField()});
    }

    public KafkaFactory getKafkaFactory() {
        return this.kafkaFactory;
    }

    void setKafkaFactory(KafkaFactory kafkaFactory) {
        this.kafkaFactory = kafkaFactory;
    }

    public NamedClusterService getNamedClusterService() {
        return this.namedClusterService;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public MetastoreLocator getMetastoreLocator() {
        return this.metastoreLocator;
    }

    public void setNamedClusterService(NamedClusterService namedClusterService) {
        this.namedClusterService = namedClusterService;
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public Optional<JaasConfigService> getJaasConfigService() {
        if (ConnectionType.DIRECT.equals((Object)this.getConnectionType())) {
            return Optional.empty();
        }
        try {
            return Optional.ofNullable(this.namedClusterServiceLocator.getService(this.namedClusterService.getNamedClusterByName(this.parentStepMeta.getParentTransMeta().environmentSubstitute(this.getClusterName()), this.getMetastoreLocator().getMetastore()), JaasConfigService.class));
        }
        catch (Exception e) {
            this.getLog().logDebug("problem getting jaas config", new Object[]{e});
            return Optional.empty();
        }
    }

    public NamedClusterServiceLocator getNamedClusterServiceLocator() {
        return this.namedClusterServiceLocator;
    }

    public void setNamedClusterServiceLocator(NamedClusterServiceLocator namedClusterServiceLocator) {
        this.namedClusterServiceLocator = namedClusterServiceLocator;
    }

    public void setMetastoreLocator(MetastoreLocator metastoreLocator) {
        this.metastoreLocator = metastoreLocator;
    }

    public void setConfig(Map<String, String> config) {
        this.config = config;
    }

    public Map<String, String> getConfig() {
        this.applyInjectedProperties();
        return this.config;
    }

    protected void applyInjectedProperties() {
        if (this.injectedConfigNames != null || this.injectedConfigValues != null) {
            Preconditions.checkState((this.injectedConfigNames != null ? 1 : 0) != 0, (Object)"Options names were not injected");
            Preconditions.checkState((this.injectedConfigValues != null ? 1 : 0) != 0, (Object)"Options values were not injected");
            Preconditions.checkState((this.injectedConfigNames.size() == this.injectedConfigValues.size() ? 1 : 0) != 0, (Object)"Injected different number of options names and value");
            this.setConfig(IntStream.range(0, this.injectedConfigNames.size()).boxed().collect(Collectors.toMap(this.injectedConfigNames::get, this.injectedConfigValues::get, (v1, v2) -> v1, LinkedHashMap::new)));
            this.injectedConfigNames = null;
            this.injectedConfigValues = null;
        }
    }

    public KafkaConsumerInputMeta copyObject() {
        KafkaConsumerInputMeta newClone = (KafkaConsumerInputMeta)((Object)this.clone());
        newClone.connectionType = this.connectionType;
        newClone.topics = new ArrayList<String>(this.topics);
        newClone.keyField = new KafkaConsumerField(this.keyField);
        newClone.messageField = new KafkaConsumerField(this.messageField);
        if (null != this.injectedConfigNames) {
            newClone.injectedConfigNames = new ArrayList<String>(this.injectedConfigNames);
        }
        if (null != this.injectedConfigValues) {
            newClone.injectedConfigValues = new ArrayList<String>(this.injectedConfigValues);
        }
        newClone.config = new LinkedHashMap<String, String>(this.config);
        newClone.topicField = new KafkaConsumerField(this.topicField);
        newClone.offsetField = new KafkaConsumerField(this.offsetField);
        newClone.partitionField = new KafkaConsumerField(this.partitionField);
        newClone.timestampField = new KafkaConsumerField(this.timestampField);
        newClone.kafkaFactory = this.kafkaFactory;
        newClone.namedClusterService = this.namedClusterService;
        newClone.metastoreLocator = this.metastoreLocator;
        newClone.namedClusterServiceLocator = this.namedClusterServiceLocator;
        return newClone;
    }

    public static enum ConnectionType {
        DIRECT,
        CLUSTER;

    }
}

